/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.promise;

import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseImpl;

public class Deferred<T> {
    private final PromiseImpl<T> promise;

    public Deferred() {
        this(null, null);
    }

    public Deferred(Executor callbackExecutor) {
        this(callbackExecutor, null);
    }

    public Deferred(Executor callbackExecutor, ScheduledExecutorService scheduledExecutor) {
        this.promise = new PromiseImpl(callbackExecutor, scheduledExecutor);
    }

    public Promise<T> getPromise() {
        return this.promise;
    }

    public void resolve(T value) {
        this.promise.resolve(value, null);
    }

    public void fail(Throwable failure) {
        this.promise.resolve(null, Objects.requireNonNull(failure));
    }

    public Promise<Void> resolveWith(Promise<? extends T> with) {
        return this.promise.resolveWith(with);
    }

    public String toString() {
        return this.promise.toString();
    }
}

