/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.promise;

import java.lang.reflect.InvocationTargetException;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.osgi.util.function.Callback;
import org.osgi.util.function.Function;
import org.osgi.util.function.Predicate;
import org.osgi.util.promise.Failure;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.Success;
import org.osgi.util.promise.TimeoutException;

final class PromiseImpl<T>
implements Promise<T> {
    private final Executor callbackExecutor;
    private final ScheduledExecutorService scheduledExecutor;
    private final ConcurrentLinkedQueue<Runnable> callbacks;
    private final CountDownLatch resolved;
    private T value;
    private Throwable fail;

    PromiseImpl(Executor callbackExecutor, ScheduledExecutorService scheduledExecutor) {
        this.callbackExecutor = callbackExecutor;
        this.scheduledExecutor = scheduledExecutor;
        this.callbacks = new ConcurrentLinkedQueue();
        this.resolved = new CountDownLatch(1);
    }

    PromiseImpl(T v, Throwable f, Executor callbackExecutor, ScheduledExecutorService scheduledExecutor) {
        if (f == null) {
            this.value = v;
        } else {
            this.fail = f;
        }
        this.callbackExecutor = callbackExecutor;
        this.scheduledExecutor = scheduledExecutor;
        this.callbacks = new ConcurrentLinkedQueue();
        this.resolved = new CountDownLatch(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tryResolve(T v, Throwable f) {
        CountDownLatch countDownLatch = this.resolved;
        synchronized (countDownLatch) {
            block6: {
                if (this.resolved.getCount() != 0L) break block6;
                return false;
            }
            if (f == null) {
                this.value = v;
            } else {
                this.fail = f;
            }
            this.resolved.countDown();
        }
        this.notifyCallbacks();
        return true;
    }

    void resolve(T v, Throwable f) {
        if (!this.tryResolve(v, f)) {
            throw new IllegalStateException("Already resolved");
        }
    }

    @Override
    public boolean isDone() {
        return this.resolved.getCount() == 0L;
    }

    @Override
    public T getValue() throws InvocationTargetException, InterruptedException {
        this.resolved.await();
        if (this.fail == null) {
            return this.value;
        }
        throw new InvocationTargetException(this.fail);
    }

    @Override
    public Throwable getFailure() throws InterruptedException {
        this.resolved.await();
        return this.fail;
    }

    public String toString() {
        if (!this.isDone()) {
            return String.valueOf(super.toString()) + "[unresolved]";
        }
        boolean interrupted = Thread.interrupted();
        try {
            Throwable t = this.getFailure();
            if (t != null) {
                String string = String.valueOf(super.toString()) + "[failed: " + t + "]";
                return string;
            }
            String string = String.valueOf(super.toString()) + "[resolved: " + this.getValue() + "]";
            return string;
        }
        catch (InterruptedException | InvocationTargetException e) {
            String string = String.valueOf(super.toString()) + "[" + e + "]";
            return string;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public Promise<T> onResolve(Runnable callback) {
        this.callbacks.offer(callback);
        this.notifyCallbacks();
        return this;
    }

    private void notifyCallbacks() {
        if (this.resolved.getCount() != 0L) {
            return;
        }
        Executor executor = this.callbackExecutor;
        Runnable callback = this.callbacks.poll();
        while (callback != null) {
            if (executor == null) {
                executor = DefaultExecutors.callbackExecutor();
            }
            try {
                try {
                    executor.execute(callback);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    callback.run();
                }
            }
            catch (Throwable t) {
                PromiseImpl.uncaughtException(t);
            }
            callback = this.callbacks.poll();
        }
    }

    static void uncaughtException(Throwable t) {
        try {
            Thread thread = Thread.currentThread();
            thread.getUncaughtExceptionHandler().uncaughtException(thread, t);
        }
        catch (Throwable throwable) {}
    }

    @Override
    public <R> Promise<R> then(Success<? super T, ? extends R> success, Failure failure) {
        PromiseImpl<T> chained;
        PromiseImpl<T> promiseImpl = chained = new PromiseImpl<T>(this.callbackExecutor, this.scheduledExecutor);
        promiseImpl.getClass();
        this.onResolve(promiseImpl.new Then<T>(this, success, failure));
        return chained;
    }

    @Override
    public <R> Promise<R> then(Success<? super T, ? extends R> success) {
        return this.then(success, null);
    }

    @Override
    public Promise<T> then(Callback callback) {
        PromiseImpl<T> chained;
        PromiseImpl<T> promiseImpl = chained = new PromiseImpl<T>(this.callbackExecutor, this.scheduledExecutor);
        promiseImpl.getClass();
        this.onResolve(promiseImpl.new Chain(this, callback));
        return chained;
    }

    Promise<Void> resolveWith(Promise<? extends T> with) {
        PromiseImpl<Void> chained = new PromiseImpl<Void>(this.callbackExecutor, this.scheduledExecutor);
        with.onResolve(new ResolveWith(with, chained));
        return chained;
    }

    @Override
    public Promise<T> filter(Predicate<? super T> predicate) {
        PromiseImpl<T> chained;
        PromiseImpl<T> promiseImpl = chained = new PromiseImpl<T>(this.callbackExecutor, this.scheduledExecutor);
        promiseImpl.getClass();
        this.onResolve(promiseImpl.new Filter(this, predicate));
        return chained;
    }

    @Override
    public <R> Promise<R> map(Function<? super T, ? extends R> mapper) {
        PromiseImpl<T> chained;
        PromiseImpl<T> promiseImpl = chained = new PromiseImpl<T>(this.callbackExecutor, this.scheduledExecutor);
        promiseImpl.getClass();
        this.onResolve(promiseImpl.new Map<T>(this, mapper));
        return chained;
    }

    @Override
    public <R> Promise<R> flatMap(Function<? super T, Promise<? extends R>> mapper) {
        PromiseImpl<T> chained;
        PromiseImpl<T> promiseImpl = chained = new PromiseImpl<T>(this.callbackExecutor, this.scheduledExecutor);
        promiseImpl.getClass();
        this.onResolve(promiseImpl.new FlatMap<T>(this, mapper));
        return chained;
    }

    @Override
    public Promise<T> recover(Function<Promise<?>, ? extends T> recovery) {
        PromiseImpl<T> chained;
        PromiseImpl<T> promiseImpl = chained = new PromiseImpl<T>(this.callbackExecutor, this.scheduledExecutor);
        promiseImpl.getClass();
        this.onResolve(promiseImpl.new Recover(this, recovery));
        return chained;
    }

    @Override
    public Promise<T> recoverWith(Function<Promise<?>, Promise<? extends T>> recovery) {
        PromiseImpl<T> chained;
        PromiseImpl<T> promiseImpl = chained = new PromiseImpl<T>(this.callbackExecutor, this.scheduledExecutor);
        promiseImpl.getClass();
        this.onResolve(promiseImpl.new RecoverWith(this, recovery));
        return chained;
    }

    @Override
    public Promise<T> fallbackTo(Promise<? extends T> fallback) {
        PromiseImpl<T> chained;
        PromiseImpl<T> promiseImpl = chained = new PromiseImpl<T>(this.callbackExecutor, this.scheduledExecutor);
        promiseImpl.getClass();
        this.onResolve(promiseImpl.new FallbackTo(this, fallback));
        return chained;
    }

    ScheduledFuture<?> schedule(Runnable operation, long delay, TimeUnit unit) {
        ScheduledExecutorService executor = this.scheduledExecutor;
        if (executor == null) {
            executor = DefaultExecutors.scheduledExecutor();
        }
        try {
            try {
                return executor.schedule(operation, delay, unit);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                operation.run();
            }
        }
        catch (Throwable t) {
            PromiseImpl.uncaughtException(t);
        }
        return null;
    }

    @Override
    public Promise<T> timeout(long millis) {
        PromiseImpl<T> chained = new PromiseImpl<T>(this.callbackExecutor, this.scheduledExecutor);
        if (!this.isDone()) {
            PromiseImpl<T> promiseImpl = chained;
            promiseImpl.getClass();
            this.onResolve(promiseImpl.new Timeout(millis, TimeUnit.MILLISECONDS));
        }
        PromiseImpl<T> promiseImpl = chained;
        promiseImpl.getClass();
        this.onResolve(promiseImpl.new Chain(this));
        return chained;
    }

    @Override
    public Promise<T> delay(long millis) {
        PromiseImpl<T> chained;
        PromiseImpl<T> promiseImpl = chained = new PromiseImpl<T>(this.callbackExecutor, this.scheduledExecutor);
        promiseImpl.getClass();
        this.onResolve(new Delay(promiseImpl.new Chain(this), millis, TimeUnit.MILLISECONDS));
        return chained;
    }

    private final class Chain
    implements Runnable {
        private final Promise<? extends T> promise;
        private final Throwable failure;
        private final Callback callback;

        Chain(Promise<? extends T> promise) {
            this.promise = promise;
            this.failure = null;
            this.callback = null;
        }

        Chain(Promise<? extends T> promise, Throwable failure) {
            this.promise = promise;
            this.failure = Objects.requireNonNull(failure);
            this.callback = null;
        }

        Chain(Promise<? extends T> promise, Callback callback) {
            this.promise = promise;
            this.failure = null;
            this.callback = Objects.requireNonNull(callback);
        }

        @Override
        public void run() {
            if (this.callback != null) {
                try {
                    this.callback.run();
                }
                catch (Throwable e) {
                    PromiseImpl.this.tryResolve(null, e);
                    return;
                }
            }
            Result result = Result.collect(this.promise);
            if (result.fail != null && this.failure != null) {
                result.fail = this.failure;
            }
            PromiseImpl.this.tryResolve(result.value, result.fail);
        }
    }

    private static final class DefaultExecutors
    implements ThreadFactory,
    RejectedExecutionHandler,
    Runnable {
        private static final DefaultExecutors callbacks = new DefaultExecutors();
        private static final ScheduledExecutor scheduledExecutor = new ScheduledExecutor(2, callbacks);
        private static final ThreadPoolExecutor callbackExecutor = new ThreadPoolExecutor(0, 64, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), callbacks, callbacks);
        private final AtomicBoolean shutdownHookInstalled = new AtomicBoolean();
        private final ThreadFactory delegateThreadFactory = Executors.defaultThreadFactory();

        static Executor callbackExecutor() {
            return callbackExecutor;
        }

        static ScheduledExecutorService scheduledExecutor() {
            return scheduledExecutor;
        }

        private DefaultExecutors() {
        }

        @Override
        public Thread newThread(Runnable r) {
            if (this.shutdownHookInstalled.compareAndSet(false, true)) {
                Thread shutdownThread = this.delegateThreadFactory.newThread(this);
                shutdownThread.setName("ExecutorShutdownHook," + shutdownThread.getName());
                try {
                    Runtime.getRuntime().addShutdownHook(shutdownThread);
                }
                catch (IllegalStateException illegalStateException) {
                    callbackExecutor.shutdown();
                    scheduledExecutor.shutdown();
                }
            }
            Thread t = this.delegateThreadFactory.newThread(r);
            t.setName("PromiseImpl," + t.getName());
            t.setDaemon(true);
            return t;
        }

        @Override
        public void rejectedExecution(Runnable callback, ThreadPoolExecutor executor) {
            try {
                callback.run();
            }
            catch (Throwable t) {
                PromiseImpl.uncaughtException(t);
            }
        }

        @Override
        public void run() {
            callbackExecutor.setMaximumPoolSize(Math.max(1, callbackExecutor.getPoolSize()));
            scheduledExecutor.shutdown();
            BlockingQueue<Runnable> queue = scheduledExecutor.getQueue();
            if (!queue.isEmpty()) {
                Object[] objectArray = queue.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    RunnableScheduledFuture future;
                    Object r = objectArray[n2];
                    if (r instanceof RunnableScheduledFuture && (future = (RunnableScheduledFuture)r).getDelay(TimeUnit.NANOSECONDS) > 0L && queue.remove(future)) {
                        future.run();
                        scheduledExecutor.afterExecute(future, null);
                    }
                    ++n2;
                }
                scheduledExecutor.shutdown();
            }
            try {
                scheduledExecutor.awaitTermination(20L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            callbackExecutor.shutdown();
            try {
                callbackExecutor.awaitTermination(20L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }

        private static final class ScheduledExecutor
        extends ScheduledThreadPoolExecutor {
            ScheduledExecutor(int corePoolSize, ThreadFactory threadFactory) {
                super(corePoolSize, threadFactory);
            }

            /*
             * Exception decompiling
             */
            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 5[CATCHBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }
    }

    private final class Delay
    implements Runnable {
        private final Runnable operation;
        private final long delay;
        private final TimeUnit unit;

        Delay(Runnable operation, long delay, TimeUnit unit) {
            this.operation = operation;
            this.delay = delay;
            this.unit = unit;
        }

        @Override
        public void run() {
            PromiseImpl.this.schedule(this.operation, this.delay, this.unit);
        }
    }

    private final class FallbackTo
    implements Runnable {
        private final Promise<T> promise;
        private final Promise<? extends T> fallback;

        FallbackTo(Promise<T> promise, Promise<? extends T> fallback) {
            this.promise = promise;
            this.fallback = Objects.requireNonNull(fallback);
        }

        @Override
        public void run() {
            Result result = Result.collect(this.promise);
            if (result.fail != null) {
                this.fallback.onResolve(new Chain(this.fallback, result.fail));
                return;
            }
            PromiseImpl.this.tryResolve(result.value, result.fail);
        }
    }

    private final class Filter
    implements Runnable {
        private final Promise<? extends T> promise;
        private final Predicate<? super T> predicate;

        Filter(Promise<? extends T> promise, Predicate<? super T> predicate) {
            this.promise = promise;
            this.predicate = Objects.requireNonNull(predicate);
        }

        @Override
        public void run() {
            Result result = Result.collect(this.promise);
            if (result.fail == null) {
                try {
                    if (!this.predicate.test(result.value)) {
                        result.fail = new NoSuchElementException();
                    }
                }
                catch (Throwable e) {
                    result.fail = e;
                }
            }
            PromiseImpl.this.tryResolve(result.value, result.fail);
        }
    }

    private final class FlatMap<P>
    implements Runnable {
        private final Promise<? extends P> promise;
        private final Function<? super P, Promise<? extends T>> mapper;

        FlatMap(Promise<? extends P> promise, Function<? super P, Promise<? extends T>> mapper) {
            this.promise = promise;
            this.mapper = Objects.requireNonNull(mapper);
        }

        @Override
        public void run() {
            Result<? extends P> result = Result.collect(this.promise);
            if (result.fail == null) {
                Promise flatmap = null;
                try {
                    flatmap = this.mapper.apply(result.value);
                }
                catch (Throwable e) {
                    result.fail = e;
                }
                if (flatmap != null) {
                    flatmap.onResolve(new Chain(flatmap));
                    return;
                }
            }
            PromiseImpl.this.tryResolve(null, result.fail);
        }
    }

    private final class Map<P>
    implements Runnable {
        private final Promise<? extends P> promise;
        private final Function<? super P, ? extends T> mapper;

        Map(Promise<? extends P> promise, Function<? super P, ? extends T> mapper) {
            this.promise = promise;
            this.mapper = Objects.requireNonNull(mapper);
        }

        @Override
        public void run() {
            Result<? extends P> result = Result.collect(this.promise);
            Object v = null;
            if (result.fail == null) {
                try {
                    v = this.mapper.apply(result.value);
                }
                catch (Throwable e) {
                    result.fail = e;
                }
            }
            PromiseImpl.this.tryResolve(v, result.fail);
        }
    }

    private final class Recover
    implements Runnable {
        private final Promise<T> promise;
        private final Function<Promise<?>, ? extends T> recovery;

        Recover(Promise<T> promise, Function<Promise<?>, ? extends T> recovery) {
            this.promise = promise;
            this.recovery = Objects.requireNonNull(recovery);
        }

        @Override
        public void run() {
            Result result = Result.collect(this.promise);
            if (result.fail != null) {
                try {
                    Object v = this.recovery.apply(this.promise);
                    if (v != null) {
                        result.value = v;
                        result.fail = null;
                    }
                }
                catch (Throwable e) {
                    result.fail = e;
                }
            }
            PromiseImpl.this.tryResolve(result.value, result.fail);
        }
    }

    private final class RecoverWith
    implements Runnable {
        private final Promise<T> promise;
        private final Function<Promise<?>, Promise<? extends T>> recovery;

        RecoverWith(Promise<T> promise, Function<Promise<?>, Promise<? extends T>> recovery) {
            this.promise = promise;
            this.recovery = Objects.requireNonNull(recovery);
        }

        @Override
        public void run() {
            Result result = Result.collect(this.promise);
            if (result.fail != null) {
                Promise recovered = null;
                try {
                    recovered = this.recovery.apply(this.promise);
                }
                catch (Throwable e) {
                    result.fail = e;
                }
                if (recovered != null) {
                    recovered.onResolve(new Chain(recovered));
                    return;
                }
            }
            PromiseImpl.this.tryResolve(result.value, result.fail);
        }
    }

    private final class ResolveWith
    implements Runnable {
        private final Promise<? extends T> promise;
        private final PromiseImpl<Void> chained;

        ResolveWith(Promise<? extends T> promise, PromiseImpl<Void> chained) {
            this.promise = promise;
            this.chained = chained;
        }

        @Override
        public void run() {
            Throwable f = null;
            Result result = Result.collect(this.promise);
            try {
                PromiseImpl.this.resolve(result.value, result.fail);
            }
            catch (Throwable e) {
                f = e;
            }
            this.chained.tryResolve(null, f);
        }
    }

    static final class Result<P> {
        Throwable fail;
        P value;

        Result() {
        }

        static <R> Result<R> collect(Promise<? extends R> promise) {
            Result result = new Result();
            boolean interrupted = Thread.interrupted();
            try {
                try {
                    result.fail = promise.getFailure();
                    if (result.fail == null) {
                        result.value = promise.getValue();
                    }
                }
                catch (Throwable e) {
                    result.fail = e;
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            return result;
        }
    }

    private final class Then<P>
    implements Runnable {
        private final Promise<P> promise;
        private final Success<P, ? extends T> success;
        private final Failure failure;

        Then(Promise<P> promise, Success<? super P, ? extends T> success, Failure failure) {
            this.promise = promise;
            this.success = success;
            this.failure = failure;
        }

        @Override
        public void run() {
            Throwable f = Result.collect(this.promise).fail;
            if (f != null) {
                if (this.failure != null) {
                    try {
                        this.failure.fail(this.promise);
                    }
                    catch (Throwable e) {
                        f = e;
                    }
                }
            } else if (this.success != null) {
                Promise returned = null;
                try {
                    returned = this.success.call(this.promise);
                }
                catch (Throwable e) {
                    f = e;
                }
                if (returned != null) {
                    returned.onResolve(new Chain(returned));
                    return;
                }
            }
            PromiseImpl.this.tryResolve(null, f);
        }
    }

    private final class Timeout
    implements Runnable {
        private final ScheduledFuture<?> future;

        Timeout(long timeout, TimeUnit unit) {
            this.future = PromiseImpl.this.schedule(new TimeoutAction(), timeout, unit);
        }

        @Override
        public void run() {
            if (this.future != null) {
                this.future.cancel(false);
            }
        }
    }

    private final class TimeoutAction
    implements Runnable {
        TimeoutAction() {
        }

        @Override
        public void run() {
            PromiseImpl.this.tryResolve(null, new TimeoutException());
        }
    }
}

