/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.promise;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.util.promise.Deferred;
import org.osgi.util.promise.FailedPromisesException;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseImpl;

public class Promises {
    private Promises() {
    }

    public static <T> Promise<T> resolved(T value) {
        return new PromiseImpl<T>(value, null, null, null);
    }

    public static <T> Promise<T> failed(Throwable failure) {
        return new PromiseImpl<Object>(null, Objects.requireNonNull(failure), null, null);
    }

    public static <T, S extends T> Promise<List<T>> all(Collection<Promise<S>> promises) {
        return Promises.all(new Deferred<List<T>>(), promises);
    }

    public static <T, S extends T> Promise<List<T>> all(Deferred<List<T>> deferred, Collection<Promise<S>> promises) {
        if (promises.isEmpty()) {
            ArrayList result = new ArrayList();
            deferred.resolve(result);
        } else {
            ArrayList list = new ArrayList(promises);
            All all = new All(deferred, list);
            for (Promise promise : list) {
                promise.onResolve(all);
            }
        }
        return deferred.getPromise();
    }

    @SafeVarargs
    public static <T> Promise<List<T>> all(Promise<? extends T> ... promises) {
        List list = Arrays.asList(promises);
        return Promises.all(list);
    }

    @SafeVarargs
    public static <T> Promise<List<T>> all(Deferred<List<T>> deferred, Promise<? extends T> ... promises) {
        List list = Arrays.asList(promises);
        return Promises.all(deferred, list);
    }

    private static final class All<T>
    implements Runnable {
        private final Deferred<List<T>> chained;
        private final List<Promise<? extends T>> promises;
        private final AtomicInteger promiseCount;

        All(Deferred<List<T>> chained, List<Promise<? extends T>> promises) {
            if (chained.getPromise().isDone()) {
                throw new IllegalStateException("Already resolved");
            }
            this.chained = chained;
            this.promises = promises;
            this.promiseCount = new AtomicInteger(promises.size());
        }

        @Override
        public void run() {
            if (this.promiseCount.decrementAndGet() != 0) {
                return;
            }
            ArrayList value = new ArrayList(this.promises.size());
            ArrayList failed = new ArrayList(this.promises.size());
            Throwable cause = null;
            for (Promise<? extends T> promise : this.promises) {
                PromiseImpl.Result<? extends T> result = PromiseImpl.Result.collect(promise);
                if (result.fail != null) {
                    failed.add(promise);
                    if (cause != null) continue;
                    cause = result.fail;
                    continue;
                }
                value.add(result.value);
            }
            if (failed.isEmpty()) {
                this.chained.resolve(value);
            } else {
                this.chained.fail(new FailedPromisesException(failed, cause));
            }
        }
    }
}

