/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.core.internal.preferences.exchange.ILegacyPreferences;
import org.eclipse.core.internal.preferences.exchange.IProductPreferencesService;
import org.eclipse.core.internal.preferences.legacy.InitLegacyPreferences;
import org.eclipse.core.internal.preferences.legacy.ProductPreferencesService;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.internal.runtime.AuthorizationHandler;
import org.eclipse.core.internal.runtime.DataArea;
import org.eclipse.core.internal.runtime.Log;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.internal.runtime.MetaDataKeeper;
import org.eclipse.core.internal.runtime.PlatformActivator;
import org.eclipse.core.internal.runtime.Product;
import org.eclipse.core.internal.runtime.ResourceTranslator;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.app.Activator;
import org.eclipse.equinox.internal.app.CommandLineArgs;
import org.eclipse.equinox.internal.app.EclipseAppContainer;
import org.eclipse.equinox.internal.app.IBranding;
import org.eclipse.equinox.log.ExtendedLogReaderService;
import org.eclipse.equinox.log.ExtendedLogService;
import org.eclipse.equinox.log.LogFilter;
import org.eclipse.equinox.log.Logger;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogListener;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public final class InternalPlatform {
    private static final String[] ARCH_LIST = new String[]{"PA_RISC", "ppc", "sparc", "x86", "x86_64", "ia64", "ia64_32"};
    public static boolean DEBUG = false;
    public static boolean DEBUG_PLUGIN_PREFERENCES = false;
    static boolean splashEnded = false;
    private static boolean initialized;
    private static final String KEYRING = "-keyring";
    private static String keyringFile;
    private static Map<Bundle, Log> logs;
    private static final String[] OS_LIST;
    private static String password;
    private static final String PASSWORD = "-password";
    private static final String PLUGIN_PATH = ".plugin-path";
    public static final String PROP_APPLICATION = "eclipse.application";
    public static final String PROP_ARCH = "osgi.arch";
    public static final String PROP_CONFIG_AREA = "osgi.configuration.area";
    public static final String PROP_CONSOLE_LOG = "eclipse.consoleLog";
    public static final String PROP_DEBUG = "osgi.debug";
    public static final String PROP_DEV = "osgi.dev";
    public static final String PROP_INSTALL_AREA = "osgi.install.area";
    public static final String PROP_NL = "osgi.nl";
    public static final String PROP_OS = "osgi.os";
    public static final String PROP_PRODUCT = "eclipse.product";
    public static final String PROP_WS = "osgi.ws";
    public static final String PROP_ACTIVATE_PLUGINS = "eclipse.activateRuntimePlugins";
    private static final InternalPlatform singleton;
    private static final String[] WS_LIST;
    private Path cachedInstanceLocation;
    private ServiceTracker<Location, Location> configurationLocation = null;
    private BundleContext context;
    private Map<IBundleGroupProvider, ServiceRegistration<IBundleGroupProvider>> groupProviders = new HashMap<IBundleGroupProvider, ServiceRegistration<IBundleGroupProvider>>(3);
    private ServiceTracker<Location, Location> installLocation = null;
    private ServiceTracker<Location, Location> instanceLocation = null;
    private ServiceTracker<Location, Location> userLocation = null;
    private Plugin runtimeInstance;
    private ServiceRegistration<ILegacyPreferences> legacyPreferencesService = null;
    private ServiceRegistration<IProductPreferencesService> customPreferencesService = null;
    private ServiceTracker<EnvironmentInfo, EnvironmentInfo> environmentTracker = null;
    private ServiceTracker<FrameworkLog, FrameworkLog> logTracker = null;
    private ServiceTracker<PackageAdmin, PackageAdmin> bundleTracker = null;
    private ServiceTracker<DebugOptions, DebugOptions> debugTracker = null;
    private ServiceTracker<IContentTypeManager, IContentTypeManager> contentTracker = null;
    private ServiceTracker<IPreferencesService, IPreferencesService> preferencesTracker = null;
    private ServiceTracker<IBundleGroupProvider, IBundleGroupProvider> groupProviderTracker = null;
    private ServiceTracker<ExtendedLogReaderService, ExtendedLogReaderService> logReaderTracker = null;
    private ServiceTracker<ExtendedLogService, ExtendedLogService> extendedLogTracker = null;
    private IProduct product;

    static {
        logs = new HashMap<Bundle, Log>(5);
        OS_LIST = new String[]{"aix", "hpux", "linux", "macosx", "qnx", "solaris", "win32"};
        password = "";
        singleton = new InternalPlatform();
        WS_LIST = new String[]{"carbon", "cocoa", "gtk", "motif", "photon", "win32", "wpf"};
    }

    public static InternalPlatform getDefault() {
        return singleton;
    }

    private InternalPlatform() {
    }

    public void addLogListener(ILogListener listener) {
        this.assertInitialized();
        RuntimeLog.addLogListener((ILogListener)listener);
    }

    private void assertInitialized() {
        if (!initialized) {
            Assert.isTrue((boolean)false, (String)Messages.meta_appNotInit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endSplash() {
        InternalPlatform internalPlatform = this;
        synchronized (internalPlatform) {
            if (splashEnded) {
                return;
            }
            splashEnded = true;
        }
        IApplicationContext applicationContext = this.getApplicationContext();
        if (applicationContext != null) {
            applicationContext.applicationRunning();
        }
    }

    public IAdapterManager getAdapterManager() {
        this.assertInitialized();
        return AdapterManager.getDefault();
    }

    public String[] getApplicationArgs() {
        return CommandLineArgs.getApplicationArgs();
    }

    public boolean getBooleanOption(String option, boolean defaultValue) {
        String value = this.getOption(option);
        if (value == null) {
            return defaultValue;
        }
        return value.equalsIgnoreCase("true");
    }

    public Bundle getBundle(String symbolicName) {
        PackageAdmin packageAdmin = this.getBundleAdmin();
        if (packageAdmin == null) {
            return null;
        }
        Bundle[] bundles = packageAdmin.getBundles(symbolicName, null);
        if (bundles == null) {
            return null;
        }
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if ((bundle.getState() & 3) == 0) {
                return bundle;
            }
            ++n2;
        }
        return null;
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    public String getBundleId(Object object) {
        if (object == null) {
            return null;
        }
        PackageAdmin packageAdmin = this.getBundleAdmin();
        if (packageAdmin == null) {
            return null;
        }
        Bundle source = packageAdmin.getBundle(object.getClass());
        if (source != null && source.getSymbolicName() != null) {
            return source.getSymbolicName();
        }
        return null;
    }

    public IBundleGroupProvider[] getBundleGroupProviders() {
        return (IBundleGroupProvider[])this.groupProviderTracker.getServices((Object[])new IBundleGroupProvider[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBundleGroupProvider(IBundleGroupProvider provider) {
        ServiceRegistration registration = this.getBundleContext().registerService(IBundleGroupProvider.class, (Object)provider, null);
        Map<IBundleGroupProvider, ServiceRegistration<IBundleGroupProvider>> map = this.groupProviders;
        synchronized (map) {
            this.groupProviders.put(provider, (ServiceRegistration<IBundleGroupProvider>)registration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterBundleGroupProvider(IBundleGroupProvider provider) {
        ServiceRegistration<IBundleGroupProvider> registration;
        Map<IBundleGroupProvider, ServiceRegistration<IBundleGroupProvider>> map = this.groupProviders;
        synchronized (map) {
            registration = this.groupProviders.remove(provider);
        }
        if (registration == null) {
            return;
        }
        registration.unregister();
    }

    public Bundle[] getBundles(String symbolicName, String version) {
        PackageAdmin packageAdmin = this.getBundleAdmin();
        if (packageAdmin == null) {
            return null;
        }
        Bundle[] bundles = packageAdmin.getBundles(symbolicName, version);
        if (bundles == null) {
            return null;
        }
        if (bundles.length == 1 && (bundles[0].getState() & 3) == 0) {
            return bundles;
        }
        Bundle[] selectedBundles = new Bundle[bundles.length];
        int added = 0;
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if ((bundle.getState() & 3) == 0) {
                selectedBundles[added++] = bundle;
            }
            ++n2;
        }
        if (added == 0) {
            return null;
        }
        Bundle[] results = new Bundle[added];
        System.arraycopy(selectedBundles, 0, results, 0, added);
        return results;
    }

    public String[] getCommandLineArgs() {
        return CommandLineArgs.getAllArgs();
    }

    public Location getConfigurationLocation() {
        this.assertInitialized();
        return (Location)this.configurationLocation.getService();
    }

    public IContentTypeManager getContentTypeManager() {
        return this.contentTracker == null ? null : (IContentTypeManager)this.contentTracker.getService();
    }

    public EnvironmentInfo getEnvironmentInfoService() {
        return this.environmentTracker == null ? null : (EnvironmentInfo)this.environmentTracker.getService();
    }

    public Bundle[] getFragments(Bundle bundle) {
        PackageAdmin packageAdmin = this.getBundleAdmin();
        if (packageAdmin == null) {
            return null;
        }
        return packageAdmin.getFragments(bundle);
    }

    public FrameworkLog getFrameworkLog() {
        return this.logTracker == null ? null : (FrameworkLog)this.logTracker.getService();
    }

    public Bundle[] getHosts(Bundle bundle) {
        PackageAdmin packageAdmin = this.getBundleAdmin();
        if (packageAdmin == null) {
            return null;
        }
        return packageAdmin.getHosts(bundle);
    }

    public Location getInstallLocation() {
        this.assertInitialized();
        return (Location)this.installLocation.getService();
    }

    public URL getInstallURL() {
        Location location = this.getInstallLocation();
        if (location == null) {
            throw new IllegalStateException("The installation location must not be null");
        }
        return location.getURL();
    }

    public Location getInstanceLocation() {
        this.assertInitialized();
        return (Location)this.instanceLocation.getService();
    }

    public IPath getLocation() throws IllegalStateException {
        if (this.cachedInstanceLocation == null) {
            Location location = this.getInstanceLocation();
            if (location == null) {
                return null;
            }
            File file = new File(location.getURL().getFile());
            this.cachedInstanceLocation = new Path(file.toString());
        }
        return this.cachedInstanceLocation;
    }

    public ILog getLog(Bundle bundle) {
        Log result = logs.get(bundle);
        if (result != null) {
            return result;
        }
        ExtendedLogService logService = (ExtendedLogService)this.extendedLogTracker.getService();
        Logger logger = logService == null ? null : logService.getLogger(bundle, "org.eclipse.equinox.logger");
        result = new Log(bundle, logger);
        ExtendedLogReaderService logReader = (ExtendedLogReaderService)this.logReaderTracker.getService();
        logReader.addLogListener((LogListener)result, (LogFilter)result);
        logs.put(bundle, result);
        return result;
    }

    public DataArea getMetaArea() {
        return MetaDataKeeper.getMetaArea();
    }

    public String getNL() {
        return this.getBundleContext().getProperty(PROP_NL);
    }

    public String getNLExtensions() {
        String nlExtensions = PlatformActivator.getContext().getProperty("osgi.nl.extensions");
        if (nlExtensions == null) {
            return "";
        }
        if (!nlExtensions.startsWith("@")) {
            nlExtensions = String.valueOf('@') + nlExtensions;
        }
        return nlExtensions;
    }

    public String getOption(String option) {
        DebugOptions options = this.getDebugOptions();
        if (options != null) {
            return options.getOption(option);
        }
        return null;
    }

    public String getOS() {
        return this.getBundleContext().getProperty(PROP_OS);
    }

    public String getOSArch() {
        return this.getBundleContext().getProperty(PROP_ARCH);
    }

    public PlatformAdmin getPlatformAdmin() {
        if (this.context == null) {
            return null;
        }
        ServiceReference platformAdminReference = this.context.getServiceReference(PlatformAdmin.class);
        if (platformAdminReference == null) {
            return null;
        }
        return (PlatformAdmin)this.context.getService(platformAdminReference);
    }

    public URL[] getPluginPath(URL pluginPathLocation) {
        InputStream input = null;
        if (pluginPathLocation == null) {
            return null;
        }
        try {
            input = pluginPathLocation.openStream();
        }
        catch (IOException iOException) {}
        if (input == null) {
            try {
                URL url = new URL("platform:/base/.plugin-path");
                input = url.openStream();
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {}
        }
        if (input == null) {
            return null;
        }
        URL[] result = null;
        try {
            try {
                result = this.readPluginPath(input);
            }
            finally {
                input.close();
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    public IPreferencesService getPreferencesService() {
        return this.preferencesTracker == null ? null : (IPreferencesService)this.preferencesTracker.getService();
    }

    public IProduct getProduct() {
        IBranding branding;
        if (this.product != null) {
            return this.product;
        }
        EclipseAppContainer container = Activator.getContainer();
        IBranding iBranding = branding = container == null ? null : container.getBranding();
        if (branding == null) {
            return null;
        }
        Object brandingProduct = branding.getProduct();
        if (!(brandingProduct instanceof IProduct)) {
            brandingProduct = new Product(branding);
        }
        this.product = (IProduct)brandingProduct;
        return this.product;
    }

    public IExtensionRegistry getRegistry() {
        return RegistryFactory.getRegistry();
    }

    public ResourceBundle getResourceBundle(Bundle bundle) {
        return ResourceTranslator.getResourceBundle((Bundle)bundle);
    }

    public String getResourceString(Bundle bundle, String value) {
        return ResourceTranslator.getResourceString((Bundle)bundle, (String)value);
    }

    public String getResourceString(Bundle bundle, String value, ResourceBundle resourceBundle) {
        return ResourceTranslator.getResourceString((Bundle)bundle, (String)value, (ResourceBundle)resourceBundle);
    }

    public Plugin getRuntimeInstance() {
        return this.runtimeInstance;
    }

    private IApplicationContext getApplicationContext() {
        Collection references;
        try {
            references = this.context.getServiceReferences(IApplicationContext.class, "(eclipse.application.type=main.thread)");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return null;
        }
        if (references == null || references.isEmpty()) {
            return null;
        }
        ServiceReference firstRef = (ServiceReference)references.iterator().next();
        IApplicationContext result = (IApplicationContext)this.context.getService(firstRef);
        if (result != null) {
            this.context.ungetService(firstRef);
            return result;
        }
        return null;
    }

    public IPath getStateLocation(Bundle bundle) {
        return this.getStateLocation(bundle, true);
    }

    public IPath getStateLocation(Bundle bundle, boolean create) throws IllegalStateException {
        this.assertInitialized();
        IPath result = this.getMetaArea().getStateLocation(bundle);
        if (create) {
            result.toFile().mkdirs();
        }
        return result;
    }

    public long getStateTimeStamp() {
        PlatformAdmin admin = this.getPlatformAdmin();
        return admin == null ? -1L : admin.getState(false).getTimeStamp();
    }

    public Location getUserLocation() {
        this.assertInitialized();
        return (Location)this.userLocation.getService();
    }

    public String getWS() {
        return this.getBundleContext().getProperty(PROP_WS);
    }

    private void initializeAuthorizationHandler() {
        try {
            AuthorizationHandler.setKeyringFile(keyringFile);
            AuthorizationHandler.setPassword(password);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
    }

    void initializeDebugFlags() {
        DEBUG = this.getBooleanOption("org.eclipse.core.runtime/debug", false);
        if (DEBUG) {
            DEBUG_PLUGIN_PREFERENCES = this.getBooleanOption("org.eclipse.core.runtime/preferences/plugin", false);
        }
    }

    public boolean isFragment(Bundle bundle) {
        PackageAdmin packageAdmin = this.getBundleAdmin();
        if (packageAdmin == null) {
            return false;
        }
        return (packageAdmin.getBundleType(bundle) & 1) > 0;
    }

    public boolean isRunning() {
        try {
            return initialized && this.context != null && this.context.getBundle().getState() == 32;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    public String[] knownOSArchValues() {
        return ARCH_LIST;
    }

    public String[] knownOSValues() {
        return OS_LIST;
    }

    public String[] knownWSValues() {
        return WS_LIST;
    }

    public void log(IStatus status) {
        RuntimeLog.log((IStatus)status);
    }

    private void processCommandLine(String[] args) {
        if (args == null || args.length == 0) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                String arg = args[++i];
                if (args[i - 1].equalsIgnoreCase(KEYRING)) {
                    keyringFile = arg;
                }
                if (args[i - 1].equalsIgnoreCase(PASSWORD)) {
                    password = arg;
                }
            }
            ++i;
        }
    }

    private URL[] readPluginPath(InputStream input) {
        Properties ini = new Properties();
        try {
            ini.load(input);
        }
        catch (IOException iOException) {
            return null;
        }
        ArrayList<URL> result = new ArrayList<URL>(5);
        Enumeration<?> groups = ini.propertyNames();
        while (groups.hasMoreElements()) {
            String group = (String)groups.nextElement();
            StringTokenizer entries = new StringTokenizer(ini.getProperty(group), ";");
            while (entries.hasMoreElements()) {
                String entry = (String)entries.nextElement();
                if (entry.equals("")) continue;
                try {
                    result.add(new URL(entry));
                }
                catch (MalformedURLException malformedURLException) {
                    System.err.println("Ignoring plugin: " + entry);
                }
            }
        }
        return result.toArray(new URL[result.size()]);
    }

    public void removeLogListener(ILogListener listener) {
        this.assertInitialized();
        RuntimeLog.removeLogListener((ILogListener)listener);
    }

    public void setRuntimeInstance(Plugin runtime) {
        this.runtimeInstance = runtime;
    }

    public void start(BundleContext runtimeContext) {
        boolean shouldActivate;
        this.context = runtimeContext;
        this.openOSGiTrackers();
        splashEnded = false;
        this.processCommandLine(this.getEnvironmentInfoService().getNonFrameworkArgs());
        this.initializeDebugFlags();
        initialized = true;
        this.getMetaArea();
        this.initializeAuthorizationHandler();
        this.startServices();
        boolean bl = shouldActivate = !"false".equalsIgnoreCase(this.context.getProperty(PROP_ACTIVATE_PLUGINS));
        if (shouldActivate) {
            new DefaultScope();
            Job.getJobManager();
        }
    }

    public void stop(BundleContext bundleContext) {
        this.assertInitialized();
        this.stopServices();
        initialized = false;
        this.closeOSGITrackers();
        this.context = null;
    }

    private void openOSGiTrackers() {
        Filter filter = null;
        try {
            filter = this.context.createFilter(Location.INSTANCE_FILTER);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.instanceLocation = new ServiceTracker(this.context, filter, null);
        this.instanceLocation.open();
        try {
            filter = this.context.createFilter(Location.USER_FILTER);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.userLocation = new ServiceTracker(this.context, filter, null);
        this.userLocation.open();
        try {
            filter = this.context.createFilter(Location.CONFIGURATION_FILTER);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.configurationLocation = new ServiceTracker(this.context, filter, null);
        this.configurationLocation.open();
        try {
            filter = this.context.createFilter(Location.INSTALL_FILTER);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.installLocation = new ServiceTracker(this.context, filter, null);
        this.installLocation.open();
        if (this.context != null) {
            this.logTracker = new ServiceTracker(this.context, FrameworkLog.class, null);
            this.logTracker.open();
        }
        if (this.context != null) {
            this.bundleTracker = new ServiceTracker(this.context, PackageAdmin.class, null);
            this.bundleTracker.open();
        }
        if (this.context != null) {
            this.contentTracker = new ServiceTracker(this.context, IContentTypeManager.class, null);
            this.contentTracker.open();
        }
        if (this.context != null) {
            this.preferencesTracker = new ServiceTracker(this.context, IPreferencesService.class, null);
            this.preferencesTracker.open();
        }
        try {
            filter = this.context.createFilter("(objectClass=" + IBundleGroupProvider.class.getName() + ")");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.groupProviderTracker = new ServiceTracker(this.context, filter, null);
        this.groupProviderTracker.open();
        this.logReaderTracker = new ServiceTracker(this.context, ExtendedLogReaderService.class.getName(), null);
        this.logReaderTracker.open();
        this.extendedLogTracker = new ServiceTracker(this.context, ExtendedLogService.class, null);
        this.extendedLogTracker.open();
        this.environmentTracker = new ServiceTracker(this.context, EnvironmentInfo.class, null);
        this.environmentTracker.open();
        this.debugTracker = new ServiceTracker(this.context, DebugOptions.class, null);
        this.debugTracker.open();
    }

    private void startServices() {
        this.customPreferencesService = this.context.registerService(IProductPreferencesService.class, (Object)new ProductPreferencesService(), new Hashtable());
        this.legacyPreferencesService = this.context.registerService(ILegacyPreferences.class, (Object)new InitLegacyPreferences(), new Hashtable());
    }

    private void stopServices() {
        if (this.legacyPreferencesService != null) {
            this.legacyPreferencesService.unregister();
            this.legacyPreferencesService = null;
        }
        if (this.customPreferencesService != null) {
            this.customPreferencesService.unregister();
            this.customPreferencesService = null;
        }
    }

    private PackageAdmin getBundleAdmin() {
        return this.bundleTracker == null ? null : (PackageAdmin)this.bundleTracker.getService();
    }

    private DebugOptions getDebugOptions() {
        return this.debugTracker == null ? null : (DebugOptions)this.debugTracker.getService();
    }

    private void closeOSGITrackers() {
        if (this.preferencesTracker != null) {
            this.preferencesTracker.close();
            this.preferencesTracker = null;
        }
        if (this.contentTracker != null) {
            this.contentTracker.close();
            this.contentTracker = null;
        }
        if (this.debugTracker != null) {
            this.debugTracker.close();
            this.debugTracker = null;
        }
        if (this.bundleTracker != null) {
            this.bundleTracker.close();
            this.bundleTracker = null;
        }
        if (this.logTracker != null) {
            this.logTracker.close();
            this.logTracker = null;
        }
        if (this.groupProviderTracker != null) {
            this.groupProviderTracker.close();
            this.groupProviderTracker = null;
        }
        if (this.environmentTracker != null) {
            this.environmentTracker.close();
            this.environmentTracker = null;
        }
        if (this.logReaderTracker != null) {
            this.logReaderTracker.close();
            this.logReaderTracker = null;
        }
        if (this.extendedLogTracker != null) {
            this.extendedLogTracker.close();
            this.extendedLogTracker = null;
        }
        if (this.installLocation != null) {
            this.installLocation.close();
            this.installLocation = null;
        }
        if (this.userLocation != null) {
            this.userLocation.close();
            this.userLocation = null;
        }
        if (this.configurationLocation != null) {
            this.configurationLocation.close();
            this.configurationLocation = null;
        }
        if (this.instanceLocation != null) {
            this.instanceLocation.close();
            this.instanceLocation = null;
        }
    }

    public static void message(String message) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(new Date(System.currentTimeMillis()));
        buffer.append(" - [");
        buffer.append(Thread.currentThread().getName());
        buffer.append("] ");
        buffer.append(message);
        System.out.println(buffer.toString());
    }

    public static void start(Bundle bundle) throws BundleException {
        int originalState = bundle.getState();
        if ((originalState & 0x20) != 0) {
            return;
        }
        try {
            bundle.start(1);
        }
        catch (BundleException e) {
            if ((originalState & 8) != 0 && (bundle.getState() & 8) != 0) {
                return;
            }
            throw e;
        }
    }
}

