/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.intro.target;

import java.text.MessageFormat;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.rap.ui.internal.intro.target.IntroMessages;
import org.eclipse.rap.ui.internal.intro.target.TargetProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public final class InstallTargetDialog
extends Dialog {
    private boolean shouldSwitchTarget = true;

    public InstallTargetDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(112);
    }

    public boolean shouldSwitchTarget() {
        return this.shouldSwitchTarget;
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        return new Point(initialSize.x + 100, initialSize.y - 150);
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        this.configureDialog();
        this.createTargetDescription(result);
        this.createSwitchTargetArea(result);
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    private void configureDialog() {
        this.getShell().setText(IntroMessages.InstallDialog_ShellTitle);
    }

    private void createTargetDescription(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 128, true, false));
        container.setLayout((Layout)new GridLayout());
        Label targetDescriptionLabel = new Label(container, 64);
        targetDescriptionLabel.setLayoutData((Object)this.getLayoutDataForDescriptions());
        String text = MessageFormat.format(IntroMessages.InstallTargetDialog_TargetDescriptionMsg, TargetProvider.getVersion());
        targetDescriptionLabel.setText(text);
    }

    private void createSwitchTargetArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(4, 4, true, false));
        container.setLayout((Layout)new GridLayout());
        final Button switchTarget = new Button(container, 32);
        switchTarget.setText(IntroMessages.InstallDialog_switchTarget);
        switchTarget.setSelection(true);
        switchTarget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstallTargetDialog.this.shouldSwitchTarget = switchTarget.getSelection();
            }
        });
        Label lblDescription = new Label(container, 64);
        lblDescription.setLayoutData((Object)this.getLayoutDataForDescriptions());
        lblDescription.setText(IntroMessages.InstallDialog_TargetDescription);
    }

    private GridData getLayoutDataForDescriptions() {
        GridData gridData = new GridData(768);
        gridData.widthHint = 120;
        return gridData;
    }
}

