/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.pde.internal.launching.launcher.LauncherUtils;
import org.eclipse.pde.ui.launcher.EquinoxLaunchConfiguration;
import org.eclipse.rap.ui.internal.launch.Activator;
import org.eclipse.rap.ui.internal.launch.LaunchMessages;
import org.eclipse.rap.ui.internal.launch.PortBusyStatusHandler;
import org.eclipse.rap.ui.internal.launch.RAPLaunchConfig;
import org.eclipse.rap.ui.internal.launch.URLBuilder;
import org.eclipse.rap.ui.internal.launch.util.ErrorUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public final class RAPLaunchDelegate
extends EquinoxLaunchConfiguration {
    private static final String VMARG_PORT = "-Dorg.osgi.service.http.port=";
    private static final String VMARG_DEVELOPMENT_MODE = "-Dorg.eclipse.rap.rwt.developmentMode=";
    private static final String VMARG_SESSION_TIMEOUT = "-Dorg.eclipse.equinox.http.jetty.context.sessioninactiveinterval=";
    private static final String VMARG_CONTEXT_PATH = "-Dorg.eclipse.equinox.http.jetty.context.path=";
    private static final int CONNECT_TIMEOUT = 20000;
    private ILaunch launch;
    private RAPLaunchConfig config;
    private int port;
    private final boolean testMode;

    public RAPLaunchDelegate() {
        this(false);
    }

    public RAPLaunchDelegate(boolean testMode) {
        this.testMode = testMode;
    }

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        SubProgressMonitor subMonitor = this.doPreLaunch(config, launch, monitor);
        super.launch(config, mode, launch, (IProgressMonitor)subMonitor);
    }

    public SubProgressMonitor doPreLaunch(ILaunchConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.launch = launch;
        this.config = new RAPLaunchConfig(config);
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, -1);
        this.terminateIfRunning((IProgressMonitor)subMonitor);
        subMonitor = new SubProgressMonitor(monitor, -1);
        this.warnIfPortBusy(subMonitor);
        subMonitor = new SubProgressMonitor(monitor, -1);
        this.port = this.determinePort((IProgressMonitor)subMonitor);
        if (this.config.getOpenBrowser()) {
            this.registerBrowserOpener();
        }
        return subMonitor;
    }

    public String[] getVMArguments(ILaunchConfiguration config) throws CoreException {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(super.getVMArguments(config)));
        list.addAll(Arrays.asList(this.getRAPVMArguments()));
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    public String[] getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        ArrayList<String> newProgrammArguments = new ArrayList<String>();
        String[] originalPogramArguments = super.getProgramArguments(configuration);
        newProgrammArguments.addAll(Arrays.asList(originalPogramArguments));
        String[] dataLocationArgument = this.getDataLocationArgument();
        newProgrammArguments.addAll(Arrays.asList(dataLocationArgument));
        String[] result = new String[newProgrammArguments.size()];
        newProgrammArguments.toArray(result);
        return result;
    }

    private String[] getDataLocationArgument() throws CoreException {
        String dataLocationResolved = this.getResolvedDataLoacation();
        String[] result = dataLocationResolved.length() > 0 ? new String[]{"-data", dataLocationResolved} : new String[]{};
        return result;
    }

    private String getResolvedDataLoacation() throws CoreException {
        String dataLocation = this.config.getDataLocation();
        String dataLocationResolved = this.resolveDataLocation(dataLocation);
        return dataLocationResolved;
    }

    private String resolveDataLocation(String dataLocation) throws CoreException {
        VariablesPlugin variablePlugin = VariablesPlugin.getDefault();
        IStringVariableManager stringVariableManager = variablePlugin.getStringVariableManager();
        return stringVariableManager.performStringSubstitution(dataLocation);
    }

    private String[] getRAPVMArguments() throws CoreException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(VMARG_PORT + this.port);
        list.add(VMARG_DEVELOPMENT_MODE + this.config.getDevelopmentMode());
        if (this.config.getUseSessionTimeout()) {
            list.add(VMARG_SESSION_TIMEOUT + this.config.getSessionTimeout());
        } else {
            list.add("-Dorg.eclipse.equinox.http.jetty.context.sessioninactiveinterval=0");
        }
        if (this.config.getUseManualContextPath()) {
            String contextPath = this.config.getContextPath();
            if (!contextPath.startsWith("/")) {
                contextPath = "/" + contextPath;
            }
            if (contextPath.endsWith("/")) {
                contextPath = contextPath.substring(0, contextPath.length() - 1);
            }
            list.add(VMARG_CONTEXT_PATH + contextPath);
        }
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    private void warnIfPortBusy(SubProgressMonitor monitor) throws CoreException {
        String taskName = LaunchMessages.RAPLaunchDelegate_CheckPortTaskName;
        monitor.beginTask(taskName, -1);
        try {
            IStatus status;
            Object resolution;
            DebugPlugin debugPlugin;
            IStatusHandler prompter;
            if (this.config.getUseManualPort() && RAPLaunchDelegate.isPortBusy(this.config.getPort()) && (prompter = (debugPlugin = DebugPlugin.getDefault()).getStatusHandler(promptStatus)) != null && Boolean.FALSE.equals(resolution = prompter.handleStatus(status = PortBusyStatusHandler.STATUS, (Object)this.config))) {
                String text = LaunchMessages.RAPLaunchDelegate_PortInUse;
                Object[] args = new Object[]{new Integer(this.config.getPort()), this.config.getName()};
                String msg = MessageFormat.format(text, args);
                String pluginId = "org.eclipse.rap.tools.launch";
                Status infoStatus = new Status(1, pluginId, msg);
                throw new CoreException((IStatus)infoStatus);
            }
        }
        finally {
            monitor.done();
        }
    }

    private int determinePort(IProgressMonitor monitor) throws CoreException {
        int result;
        String taskName = LaunchMessages.RAPLaunchDelegate_DeterminePortTaskName;
        monitor.beginTask(taskName, -1);
        try {
            result = this.config.getUseManualPort() ? this.config.getPort() : RAPLaunchDelegate.findFreePort();
        }
        finally {
            monitor.done();
        }
        return result;
    }

    private static int findFreePort() throws CoreException {
        int n;
        ServerSocket server = new ServerSocket(0);
        try {
            n = server.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                server.close();
                throw throwable;
            }
            catch (IOException e) {
                String msg = "Could not obtain a free port number.";
                String pluginId = Activator.getPluginId();
                Status status = new Status(4, pluginId, msg, (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        server.close();
        return n;
    }

    private static boolean isPortBusy(int port) {
        ServerSocket server = null;
        try {
            server = new ServerSocket(port);
        }
        catch (IOException iOException) {}
        if (server != null) {
            try {
                server.close();
            }
            catch (IOException iOException) {}
        }
        return server == null;
    }

    private URL getUrl() throws CoreException {
        try {
            String url = URLBuilder.fromLaunchConfig(this.config, this.port, this.testMode);
            return new URL(url);
        }
        catch (MalformedURLException e) {
            String msg = "Invalid URL.";
            String pluginId = Activator.getPluginId();
            Status status = new Status(4, pluginId, 0, msg, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private void terminateIfRunning(IProgressMonitor monitor) throws CoreException {
        String taskName = LaunchMessages.RAPLaunchDelegate_TerminatePreviousTaskName;
        monitor.beginTask(taskName, -1);
        try {
            ILaunch runningLaunch = this.findRunning();
            if (runningLaunch != null) {
                RAPLaunchDelegate.terminate(runningLaunch);
            }
        }
        finally {
            monitor.done();
        }
    }

    private ILaunch findRunning() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] runningLaunches = launchManager.getLaunches();
        ILaunch result = null;
        int i = 0;
        while (result == null && i < runningLaunches.length) {
            ILaunch runningLaunch = runningLaunches[i];
            if (runningLaunch != this.launch && this.config.getName().equals(RAPLaunchDelegate.getLaunchName(runningLaunch)) && !runningLaunch.isTerminated()) {
                result = runningLaunches[i];
            }
            ++i;
        }
        return result;
    }

    private static String getLaunchName(ILaunch launch) {
        ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
        return launchConfiguration == null ? null : launchConfiguration.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void terminate(final ILaunch previousLaunch) throws DebugException {
        final Object signal = new Object();
        final boolean[] terminated = new boolean[1];
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        debugPlugin.addDebugEventListener(new IDebugEventSetListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleDebugEvents(DebugEvent[] events) {
                int i = 0;
                while (i < events.length) {
                    DebugEvent event = events[i];
                    if (RAPLaunchDelegate.isTerminateEventFor(event, previousLaunch)) {
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                        Object object = signal;
                        synchronized (object) {
                            terminated[0] = true;
                            signal.notifyAll();
                        }
                    }
                    ++i;
                }
            }
        });
        previousLaunch.terminate();
        try {
            Object object = signal;
            synchronized (object) {
                if (!terminated[0]) {
                    signal.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    private static boolean isCreateEventFor(DebugEvent event, ILaunch launch) {
        Object source = event.getSource();
        return event.getKind() == 4 && source instanceof RuntimeProcess && ((RuntimeProcess)source).getLaunch() == launch;
    }

    private static boolean isTerminateEventFor(DebugEvent event, ILaunch launch) {
        boolean result = false;
        if (event.getKind() == 8 && event.getSource() instanceof RuntimeProcess) {
            RuntimeProcess process = (RuntimeProcess)event.getSource();
            result = process.getLaunch() == launch;
        }
        return result;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForHttpService(IProgressMonitor monitor) {
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        String taskName = LaunchMessages.RAPLaunchDelegate_WaitForHTTPTaskName;
        subMonitor.beginTask(taskName, -1);
        try {
            block10: {
                boolean interrupted;
                boolean canConnect;
                long start;
                block9: {
                    start = System.currentTimeMillis();
                    canConnect = false;
                    interrupted = false;
                    if (!true) break block9;
                    if (System.currentTimeMillis() - start > 20000L) return;
                    if (canConnect) return;
                    if (interrupted) return;
                    if (monitor.isCanceled()) return;
                    if (this.launch.isTerminated()) break block10;
                }
                do {
                    try {
                        Socket socket = new Socket(URLBuilder.getHost(), this.port);
                        socket.close();
                        canConnect = true;
                    }
                    catch (Exception exception) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {
                            interrupted = true;
                        }
                    }
                    if (System.currentTimeMillis() - start > 20000L) return;
                    if (canConnect) return;
                    if (interrupted) return;
                    if (monitor.isCanceled()) return;
                } while (!this.launch.isTerminated());
            }
            return;
        }
        finally {
            subMonitor.done();
        }
    }

    public void clear(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        this.clearDataLocation(configuration, monitor);
        super.clear(configuration, monitor);
    }

    private void clearDataLocation(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        String resolvedDataLocation = this.getResolvedDataLoacation();
        boolean isCleared = LauncherUtils.clearWorkspace((ILaunchConfiguration)configuration, (String)resolvedDataLocation, (IProgressMonitor)monitor);
        if (!isCleared) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }

    private void registerBrowserOpener() {
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        debugPlugin.addDebugEventListener(new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                int i = 0;
                while (i < events.length) {
                    DebugEvent event = events[i];
                    if (RAPLaunchDelegate.isCreateEventFor(event, RAPLaunchDelegate.this.launch)) {
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                        final String jobTaskName = LaunchMessages.RAPLaunchDelegate_StartClientTaskName;
                        Job job = new Job(jobTaskName){

                            protected IStatus run(IProgressMonitor monitor) {
                                String taskName = jobTaskName;
                                monitor.beginTask(taskName, 2);
                                try {
                                    RAPLaunchDelegate.this.waitForHttpService(monitor);
                                    monitor.worked(1);
                                    if (!RAPLaunchDelegate.this.launch.isTerminated()) {
                                        RAPLaunchDelegate.this.openBrowser(monitor);
                                    }
                                }
                                finally {
                                    monitor.done();
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        job.schedule();
                    }
                    ++i;
                }
            }
        });
    }

    private void openBrowser(IProgressMonitor monitor) {
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        String taskName = LaunchMessages.RAPLaunchDelegate_StartClientTaskName;
        subMonitor.beginTask(taskName, -1);
        try {
            URL url = null;
            try {
                url = this.getUrl();
                IWebBrowser browser = this.getBrowser();
                RAPLaunchDelegate.openUrl(browser, url);
            }
            catch (CoreException e) {
                String text = LaunchMessages.RAPLaunchDelegate_OpenBrowserFailed;
                String msg = MessageFormat.format(text, url);
                ErrorUtil.show(msg, e);
            }
        }
        finally {
            subMonitor.done();
        }
    }

    private IWebBrowser getBrowser() throws CoreException {
        final IWebBrowser[] result = new IWebBrowser[1];
        final CoreException[] exception = new CoreException[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    IWorkbenchBrowserSupport support = workbench.getBrowserSupport();
                    int style = 14;
                    style = RAPLaunchConfig.BrowserMode.EXTERNAL.equals(RAPLaunchDelegate.this.config.getBrowserMode()) ? (style |= 0x80) : (style |= 0x20);
                    String id = String.valueOf(RAPLaunchDelegate.this.config.getName()) + RAPLaunchDelegate.this.config.getBrowserMode();
                    String name = RAPLaunchDelegate.this.config.getName();
                    String toolTip = RAPLaunchDelegate.this.config.getName();
                    result[0] = support.createBrowser(style, id, name, toolTip);
                }
                catch (CoreException e) {
                    exception[0] = e;
                }
            }
        });
        if (exception[0] != null) {
            throw exception[0];
        }
        return result[0];
    }

    private static void openUrl(final IWebBrowser browser, final URL url) throws PartInitException {
        final PartInitException[] exception = new PartInitException[1];
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    browser.openURL(url);
                }
                catch (PartInitException e) {
                    String text = LaunchMessages.RAPLaunchDelegate_OpenUrlFailed;
                    String msg = MessageFormat.format(text, url);
                    String pluginId = Activator.getPluginId();
                    Status status = new Status(4, pluginId, msg, (Throwable)e);
                    exception[0] = new PartInitException((IStatus)status);
                }
            }
        });
        if (exception[0] != null) {
            throw exception[0];
        }
    }
}

