/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.tab;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.rap.ui.internal.launch.tab.AbstractExtension;
import org.eclipse.rap.ui.internal.launch.tab.ExtensionUtil;

public final class BrandingExtension
extends AbstractExtension {
    public static final String EXTENSION_ID = "org.eclipse.rap.ui.branding";
    private static final String ATTR_SERVLET_NAME = "servletName";
    private static final String DEFAULT_ENTRYPOINT_ID = "defaultEntrypointId";
    private final String servletName;
    private final String defaultEntryPointId;

    public static BrandingExtension[] findInWorkspace(IProgressMonitor monitor) {
        IPluginExtension[] extensions = ExtensionUtil.getWorkspaceExtensions(EXTENSION_ID, monitor);
        return BrandingExtension.createBrandingExtensions(extensions);
    }

    static BrandingExtension[] findAllActive(IProgressMonitor monitor) {
        IPluginExtension[] extensions = ExtensionUtil.getActiveExtensions(EXTENSION_ID, monitor);
        return BrandingExtension.createBrandingExtensions(extensions);
    }

    public static BrandingExtension[] findInActivePlugins(String[] pluginIds, IProgressMonitor monitor) {
        IPluginExtension[] extensions = ExtensionUtil.getActivePluginExtensions(pluginIds, EXTENSION_ID, monitor);
        return BrandingExtension.createBrandingExtensions(extensions);
    }

    private static BrandingExtension[] createBrandingExtensions(IPluginExtension[] extensions) {
        ArrayList<BrandingExtension> list = new ArrayList<BrandingExtension>();
        int i = 0;
        while (i < extensions.length) {
            BrandingExtension[] brandings = BrandingExtension.getBrandingExtensions(extensions[i]);
            list.addAll(Arrays.asList(brandings));
            ++i;
        }
        BrandingExtension[] result = new BrandingExtension[list.size()];
        list.toArray(result);
        return result;
    }

    private static final BrandingExtension[] getBrandingExtensions(IPluginExtension pluginExtension) {
        IPluginObject[] children = pluginExtension.getChildren();
        BrandingExtension[] result = new BrandingExtension[children.length];
        int i = 0;
        while (i < children.length) {
            String project = ExtensionUtil.getProjectName(pluginExtension);
            IPluginElement element = (IPluginElement)children[i];
            String servletName = ExtensionUtil.getAttribute(element, ATTR_SERVLET_NAME);
            String defaultEntryPointId = ExtensionUtil.getAttribute(element, DEFAULT_ENTRYPOINT_ID);
            result[i] = new BrandingExtension(project, servletName, defaultEntryPointId);
            ++i;
        }
        return result;
    }

    BrandingExtension(String project, String servletName, String defaultEntryPointId) {
        super(project);
        this.servletName = servletName;
        this.defaultEntryPointId = defaultEntryPointId;
    }

    public final String getServletName() {
        return this.servletName;
    }

    final String getDefaultEntryPointId() {
        return this.defaultEntryPointId;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        int valueHashCode = this.servletName == null ? 0 : this.servletName.hashCode();
        result = prime * result + valueHashCode;
        int projectHashCode = this.project == null ? 0 : this.project.hashCode();
        result = prime * result + projectHashCode;
        return result;
    }

    public final boolean equals(Object obj) {
        boolean result;
        if (this == obj) {
            result = true;
        } else if (obj == null) {
            result = false;
        } else if (this.getClass() != obj.getClass()) {
            result = false;
        } else {
            result = true;
            BrandingExtension other = (BrandingExtension)obj;
            if (this.servletName == null) {
                if (other.servletName != null) {
                    result = false;
                }
            } else if (!this.servletName.equals(other.servletName)) {
                result = false;
            }
            if (this.project == null) {
                if (other.project != null) {
                    result = false;
                }
            } else if (!this.project.equals(other.project)) {
                result = false;
            }
        }
        return result;
    }
}

