/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.tools.launch.rwt.internal.tab;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.rap.tools.launch.rwt.internal.config.RWTLaunchConfig;
import org.eclipse.rap.tools.launch.rwt.internal.tab.BrowserSection;
import org.eclipse.rap.tools.launch.rwt.internal.tab.EntryPointSection;
import org.eclipse.rap.tools.launch.rwt.internal.tab.HelpContextIds;
import org.eclipse.rap.tools.launch.rwt.internal.tab.ProjectSection;
import org.eclipse.rap.tools.launch.rwt.internal.tab.RAPSettingsSection;
import org.eclipse.rap.tools.launch.rwt.internal.tab.RWTLaunchTab;
import org.eclipse.rap.tools.launch.rwt.internal.tab.ServerSettingsSection;
import org.eclipse.rap.tools.launch.rwt.internal.util.Images;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class RWTMainTab
extends RWTLaunchTab {
    private ProjectSection projectSection = new ProjectSection();
    private EntryPointSection entryPointSection = new EntryPointSection();
    private BrowserSection browserSection = new BrowserSection();
    private ServerSettingsSection serverSettingsSection = new ServerSettingsSection();
    private RAPSettingsSection rapSettings = new RAPSettingsSection();
    private ILaunchConfigurationListener launchConfigListener;

    public RWTMainTab() {
        this.addLaunchConfigListener();
    }

    public String getName() {
        return "Main";
    }

    public Image getImage() {
        return Images.getImage("VIEW_MAIN_TAB");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)new GridLayout(1, false));
        this.projectSection.createControl(container);
        this.entryPointSection.createControl(container);
        this.browserSection.createControl(container);
        this.serverSettingsSection.createControl(container);
        this.rapSettings.createControl(container);
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
        HelpContextIds.assign(this.getControl(), HelpContextIds.MAIN_TAB);
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
        this.projectSection.setLaunchConfigurationDialog(dialog);
        this.entryPointSection.setLaunchConfigurationDialog(dialog);
        this.serverSettingsSection.setLaunchConfigurationDialog(dialog);
        this.browserSection.setLaunchConfigurationDialog(dialog);
        this.rapSettings.setLaunchConfigurationDialog(dialog);
    }

    public void initializeFrom(RWTLaunchConfig launchConfig) {
        this.projectSection.initializeFrom(launchConfig);
        this.entryPointSection.initializeFrom(launchConfig);
        this.serverSettingsSection.initializeFrom(launchConfig);
        this.browserSection.initializeFrom(launchConfig);
        this.rapSettings.initializeFrom(launchConfig);
    }

    public void performApply(RWTLaunchConfig launchConfig) {
        this.projectSection.performApply(launchConfig);
        this.entryPointSection.performApply(launchConfig);
        this.serverSettingsSection.performApply(launchConfig);
        this.browserSection.performApply(launchConfig);
        this.rapSettings.performApply(launchConfig);
    }

    public void dispose() {
        this.getLaunchManager().removeLaunchConfigurationListener(this.launchConfigListener);
        super.dispose();
    }

    private void addLaunchConfigListener() {
        this.launchConfigListener = this.getLaunchConfigListener();
        this.getLaunchManager().addLaunchConfigurationListener(this.launchConfigListener);
    }

    private ILaunchConfigurationListener getLaunchConfigListener() {
        return new ILaunchConfigurationListener(){

            public void launchConfigurationChanged(ILaunchConfiguration configuration) {
                RWTMainTab.this.browserSection.updateApplicationUrl(new RWTLaunchConfig(configuration));
            }

            public void launchConfigurationAdded(ILaunchConfiguration configuration) {
            }

            public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
            }
        };
    }
}

