/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.tablekit;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rwt.internal.protocol.IClientObject;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.CellToolTipUtil;
import org.eclipse.swt.internal.widgets.ICellToolTipAdapter;
import org.eclipse.swt.internal.widgets.ICellToolTipProvider;
import org.eclipse.swt.internal.widgets.ITableAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public final class TableLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.Tree";
    private static final String[] ALLOWED_STYLES = new String[]{"SINGLE", "MULTI", "CHECK", "FULL_SELECTION", "HIDE_SELECTION", "VIRTUAL", "NO_SCROLL", "NO_RADIO_GROUP", "BORDER"};
    private static final String PROP_ITEM_COUNT = "itemCount";
    private static final String PROP_ITEM_HEIGHT = "itemHeight";
    private static final String PROP_ITEM_METRICS = "itemMetrics";
    private static final String PROP_COLUMN_COUNT = "columnCount";
    private static final String PROP_TREE_COLUMN = "treeColumn";
    private static final String PROP_FIXED_COLUMNS = "fixedColumns";
    private static final String PROP_HEADER_HEIGHT = "headerHeight";
    private static final String PROP_HEADER_VISIBLE = "headerVisible";
    private static final String PROP_LINES_VISIBLE = "linesVisible";
    private static final String PROP_TOP_ITEM_INDEX = "topItemIndex";
    private static final String PROP_FOCUS_ITEM = "focusItem";
    private static final String PROP_SCROLL_LEFT = "scrollLeft";
    private static final String PROP_SELECTION = "selection";
    private static final String PROP_SORT_DIRECTION = "sortDirection";
    private static final String PROP_SORT_COLUMN = "sortColumn";
    private static final String PROP_SCROLLBARS_VISIBLE = "scrollBarsVisible";
    private static final String PROP_SCROLLBARS_SELECTION_LISTENER = "scrollBarsSelection";
    private static final String PROP_SELECTION_LISTENER = "selection";
    private static final String PROP_ALWAYS_HIDE_SELECTION = "alwaysHideSelection";
    private static final String PROP_ENABLE_CELL_TOOLTIP = "enableCellToolTip";
    private static final String PROP_CELL_TOOLTIP_TEXT = "cellToolTipText";
    private static final String PROP_MARKUP_ENABLED = "markupEnabled";
    private static final int ZERO = 0;
    private static final String[] DEFAULT_SELECTION = new String[0];
    private static final boolean[] DEFAULT_SCROLLBARS_VISIBLE = new boolean[2];
    private static final String DEFAULT_SORT_DIRECTION = "none";

    public void preserveValues(Widget widget) {
        Table table = (Table)widget;
        ControlLCAUtil.preserveValues(table);
        WidgetLCAUtil.preserveCustomVariant(table);
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_ITEM_COUNT, table.getItemCount());
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_ITEM_HEIGHT, table.getItemHeight());
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_ITEM_METRICS, TableLCA.getItemMetrics(table));
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_COLUMN_COUNT, table.getColumnCount());
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_FIXED_COLUMNS, this.getFixedColumns(table));
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_HEADER_HEIGHT, table.getHeaderHeight());
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_HEADER_VISIBLE, table.getHeaderVisible());
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_LINES_VISIBLE, table.getLinesVisible());
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_TOP_ITEM_INDEX, table.getTopIndex());
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_FOCUS_ITEM, TableLCA.getFocusItem(table));
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_SCROLL_LEFT, TableLCA.getScrollLeft(table));
        WidgetLCAUtil.preserveProperty((Widget)table, "selection", TableLCA.getSelection(table));
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_SORT_DIRECTION, TableLCA.getSortDirection(table));
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_SORT_COLUMN, table.getSortColumn());
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_SCROLLBARS_VISIBLE, TableLCA.getScrollBarsVisible(table));
        WidgetLCAUtil.preserveListener(table, PROP_SCROLLBARS_SELECTION_LISTENER, TableLCA.hasScrollBarsSelectionListener(table));
        WidgetLCAUtil.preserveListener(table, "selection", SelectionEvent.hasListener(table));
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_ALWAYS_HIDE_SELECTION, TableLCA.hasAlwaysHideSelection(table));
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_ENABLE_CELL_TOOLTIP, CellToolTipUtil.isEnabledFor(table));
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_CELL_TOOLTIP_TEXT, null);
    }

    public void readData(Widget widget) {
        Table table = (Table)widget;
        TableLCA.readTopItemIndex(table);
        TableLCA.readScrollLeft(table);
        TableLCA.readSelection(table);
        TableLCA.readFocusIndex(table);
        TableLCA.readWidgetSelected(table);
        TableLCA.readWidgetDefaultSelected(table);
        TableLCA.readCellToolTipTextRequested(table);
        ControlLCAUtil.processMouseEvents(table);
        ControlLCAUtil.processKeyEvents(table);
        ControlLCAUtil.processMenuDetect(table);
    }

    public void renderInitialization(Widget widget) throws IOException {
        Table table = (Table)widget;
        IClientObject clientObject = ClientObjectFactory.getClientObject(table);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(table.getParent()));
        clientObject.set("style", WidgetLCAUtil.getStyles(table, ALLOWED_STYLES));
        clientObject.set("appearance", "table");
        ITableAdapter adapter = table.getAdapter(ITableAdapter.class);
        if ((table.getStyle() & 0x20) != 0) {
            int[] checkMetrics = new int[]{adapter.getCheckLeft(), adapter.getCheckWidth()};
            clientObject.set("checkBoxMetrics", checkMetrics);
        }
        if (this.getFixedColumns(table) >= 0) {
            clientObject.set("splitContainer", true);
        }
        clientObject.set("indentionWidth", 0);
        clientObject.set(PROP_TREE_COLUMN, -1);
        clientObject.set(PROP_MARKUP_ENABLED, TableLCA.isMarkupEnabled(table));
    }

    public void renderChanges(Widget widget) throws IOException {
        Table table = (Table)widget;
        ControlLCAUtil.renderChanges(table);
        WidgetLCAUtil.renderCustomVariant(table);
        WidgetLCAUtil.renderProperty((Widget)table, PROP_ITEM_COUNT, table.getItemCount(), 0);
        WidgetLCAUtil.renderProperty((Widget)table, PROP_ITEM_HEIGHT, table.getItemHeight(), 0);
        TableLCA.renderItemMetrics(table);
        WidgetLCAUtil.renderProperty((Widget)table, PROP_COLUMN_COUNT, table.getColumnCount(), 0);
        WidgetLCAUtil.renderProperty((Widget)table, PROP_FIXED_COLUMNS, this.getFixedColumns(table), -1);
        WidgetLCAUtil.renderProperty((Widget)table, PROP_HEADER_HEIGHT, table.getHeaderHeight(), 0);
        WidgetLCAUtil.renderProperty((Widget)table, PROP_HEADER_VISIBLE, table.getHeaderVisible(), false);
        WidgetLCAUtil.renderProperty((Widget)table, PROP_LINES_VISIBLE, table.getLinesVisible(), false);
        WidgetLCAUtil.renderProperty((Widget)table, PROP_TOP_ITEM_INDEX, table.getTopIndex(), 0);
        WidgetLCAUtil.renderProperty((Widget)table, PROP_FOCUS_ITEM, TableLCA.getFocusItem(table), null);
        WidgetLCAUtil.renderProperty((Widget)table, PROP_SCROLL_LEFT, TableLCA.getScrollLeft(table), 0);
        WidgetLCAUtil.renderProperty((Widget)table, "selection", TableLCA.getSelection(table), DEFAULT_SELECTION);
        WidgetLCAUtil.renderProperty((Widget)table, PROP_SORT_DIRECTION, TableLCA.getSortDirection(table), DEFAULT_SORT_DIRECTION);
        WidgetLCAUtil.renderProperty((Widget)table, PROP_SORT_COLUMN, table.getSortColumn(), null);
        WidgetLCAUtil.renderProperty((Widget)table, PROP_SCROLLBARS_VISIBLE, TableLCA.getScrollBarsVisible(table), DEFAULT_SCROLLBARS_VISIBLE);
        WidgetLCAUtil.renderListener(table, PROP_SCROLLBARS_SELECTION_LISTENER, TableLCA.hasScrollBarsSelectionListener(table), false);
        WidgetLCAUtil.renderListener(table, "selection", SelectionEvent.hasListener(table), false);
        WidgetLCAUtil.renderProperty((Widget)table, PROP_ALWAYS_HIDE_SELECTION, TableLCA.hasAlwaysHideSelection(table), false);
        WidgetLCAUtil.renderProperty((Widget)table, PROP_ENABLE_CELL_TOOLTIP, CellToolTipUtil.isEnabledFor(table), false);
        WidgetLCAUtil.renderProperty((Widget)table, PROP_CELL_TOOLTIP_TEXT, TableLCA.getCellToolTipText(table), null);
    }

    public void renderDispose(Widget widget) throws IOException {
        ClientObjectFactory.getClientObject(widget).destroy();
    }

    public void doRedrawFake(Control control) {
        Table table = (Table)control;
        table.getAdapter(ITableAdapter.class).checkData();
    }

    private static void readSelection(Table table) {
        String value = WidgetLCAUtil.readPropertyValue(table, "selection");
        if (value != null) {
            int[] newSelection;
            if ("".equals(value)) {
                newSelection = new int[]{};
            } else {
                String[] selectedItems = value.split(",");
                newSelection = new int[selectedItems.length];
                int i = 0;
                while (i < selectedItems.length) {
                    String itemId = selectedItems[i];
                    TableItem item = TableLCA.getItem(table, itemId);
                    newSelection[i] = item != null ? table.indexOf(item) : -1;
                    ++i;
                }
            }
            table.deselectAll();
            table.select(newSelection);
        }
    }

    private static void readTopItemIndex(Table table) {
        String value = WidgetLCAUtil.readPropertyValue(table, PROP_TOP_ITEM_INDEX);
        if (value != null) {
            int topIndex = NumberFormatUtil.parseInt(value);
            int topOffset = topIndex * table.getItemHeight();
            table.setTopIndex(topIndex);
            TableLCA.processScrollBarSelection(table.getVerticalBar(), topOffset);
        }
    }

    private static void readFocusIndex(Table table) {
        TableItem item;
        String value = WidgetLCAUtil.readPropertyValue(table, PROP_FOCUS_ITEM);
        if (value != null && (item = TableLCA.getItem(table, value)) != null) {
            table.getAdapter(ITableAdapter.class).setFocusIndex(table.indexOf(item));
        }
    }

    private static void readScrollLeft(Table table) {
        String value = WidgetLCAUtil.readPropertyValue(table, PROP_SCROLL_LEFT);
        if (value != null) {
            int leftOffset = NumberFormatUtil.parseInt(value);
            table.getAdapter(ITableAdapter.class).setLeftOffset(leftOffset);
            TableLCA.processScrollBarSelection(table.getHorizontalBar(), leftOffset);
        }
    }

    private static void readWidgetSelected(Table table) {
        HttpServletRequest request;
        String selectionId;
        TableItem item;
        if (WidgetLCAUtil.wasEventSent(table, "org.eclipse.swt.events.widgetSelected") && (item = TableLCA.getItem(table, selectionId = (request = ContextProvider.getRequest()).getParameter("org.eclipse.swt.events.widgetSelected.item"))) != null) {
            int detail = TableLCA.getWidgetSelectedDetail();
            int id = 13;
            Rectangle bounds = new Rectangle(0, 0, 0, 0);
            int stateMask = EventLCAUtil.readStateMask("org.eclipse.swt.events.widgetSelected.modifier");
            SelectionEvent event = new SelectionEvent(table, item, id, bounds, stateMask, "", true, detail);
            event.processEvent();
        }
    }

    private static void readWidgetDefaultSelected(Table table) {
        String defaultSelectedParam = "org.eclipse.swt.events.widgetDefaultSelected";
        if (WidgetLCAUtil.wasEventSent(table, defaultSelectedParam)) {
            TableItem item = TableLCA.getFocusItem(table);
            HttpServletRequest request = ContextProvider.getRequest();
            String selectionId = request.getParameter(String.valueOf(defaultSelectedParam) + ".item");
            TableItem selectedItem = TableLCA.getItem(table, selectionId);
            if (selectedItem != null) {
                item = selectedItem;
            }
            int id = 14;
            SelectionEvent event = new SelectionEvent(table, item, id);
            event.stateMask = EventLCAUtil.readStateMask("org.eclipse.swt.events.widgetSelected.modifier");
            event.processEvent();
        }
    }

    private static int getWidgetSelectedDetail() {
        HttpServletRequest request = ContextProvider.getRequest();
        String value = request.getParameter("org.eclipse.swt.events.widgetSelected.detail");
        return "check".equals(value) ? 32 : 0;
    }

    private static void readCellToolTipTextRequested(Table table) {
        ICellToolTipProvider provider;
        ICellToolTipAdapter adapter = CellToolTipUtil.getAdapter(table);
        adapter.setCellToolTipText(null);
        if (WidgetLCAUtil.wasEventSent(table, "org.eclipse.swt.events.cellToolTipTextRequested") && (provider = adapter.getCellToolTipProvider()) != null) {
            HttpServletRequest request = ContextProvider.getRequest();
            String cell = request.getParameter("org.eclipse.swt.events.cellToolTipTextRequested.cell");
            String[] details = cell.split(",");
            String itemId = details[0];
            int columnIndex = NumberFormatUtil.parseInt(details[1]);
            TableItem item = TableLCA.getItem(table, itemId);
            if (item != null && (columnIndex == 0 || columnIndex < table.getColumnCount())) {
                provider.getToolTipText(item, columnIndex);
            }
        }
    }

    private static String getCellToolTipText(Table table) {
        ICellToolTipAdapter adapter = CellToolTipUtil.getAdapter(table);
        return adapter.getCellToolTipText();
    }

    private static boolean isMarkupEnabled(Table table) {
        return Boolean.TRUE.equals(table.getData("org.eclipse.rap.rwt.markupEnabled"));
    }

    private static String[] getSelection(Table table) {
        TableItem[] selection = table.getSelection();
        String[] result = new String[selection.length];
        int i = 0;
        while (i < result.length) {
            result[i] = WidgetUtil.getId(selection[i]);
            ++i;
        }
        return result;
    }

    private int getFixedColumns(Table table) {
        ITableAdapter tableAdapter = table.getAdapter(ITableAdapter.class);
        return tableAdapter.getFixedColumns();
    }

    private static int getScrollLeft(Table table) {
        return table.getAdapter(ITableAdapter.class).getLeftOffset();
    }

    private static TableItem getFocusItem(Table table) {
        TableItem result = null;
        ITableAdapter tableAdapter = table.getAdapter(ITableAdapter.class);
        int focusIndex = tableAdapter.getFocusIndex();
        if (focusIndex != -1) {
            result = table.getItem(focusIndex);
        }
        return result;
    }

    private static String getSortDirection(Table table) {
        String result = DEFAULT_SORT_DIRECTION;
        if (table.getSortDirection() == 128) {
            result = "up";
        } else if (table.getSortDirection() == 1024) {
            result = "down";
        }
        return result;
    }

    private static boolean[] getScrollBarsVisible(Table table) {
        return new boolean[]{TableLCA.hasHScrollBar(table), TableLCA.hasVScrollBar(table)};
    }

    private static boolean hasHScrollBar(Table table) {
        return table.getAdapter(ITableAdapter.class).hasHScrollBar();
    }

    private static boolean hasVScrollBar(Table table) {
        return table.getAdapter(ITableAdapter.class).hasVScrollBar();
    }

    private static boolean hasScrollBarsSelectionListener(Table table) {
        ScrollBar verticalBar;
        boolean result = false;
        ScrollBar horizontalBar = table.getHorizontalBar();
        if (horizontalBar != null) {
            boolean bl = result = result || SelectionEvent.hasListener(horizontalBar);
        }
        if ((verticalBar = table.getVerticalBar()) != null) {
            result = result || SelectionEvent.hasListener(verticalBar);
        }
        return result;
    }

    private static void processScrollBarSelection(ScrollBar scrollBar, int selection) {
        if (scrollBar != null) {
            scrollBar.setSelection(selection);
            if (SelectionEvent.hasListener(scrollBar)) {
                SelectionEvent evt = new SelectionEvent(scrollBar, null, 13);
                evt.stateMask = EventLCAUtil.readStateMask("org.eclipse.swt.events.widgetSelected.modifier");
                evt.processEvent();
            }
        }
    }

    static boolean hasAlwaysHideSelection(Table table) {
        Object data = table.getData(Table.ALWAYS_HIDE_SELECTION);
        return Boolean.TRUE.equals(data);
    }

    private static TableItem getItem(Table table, String itemId) {
        TableItem item;
        String[] idParts = itemId.split("#");
        if (idParts.length == 2) {
            int index = Integer.parseInt(idParts[1]);
            item = table.getItem(index);
        } else {
            item = (TableItem)WidgetUtil.find(table, itemId);
        }
        return item;
    }

    private static void renderItemMetrics(Table table) {
        ItemMetrics[] itemMetrics = TableLCA.getItemMetrics(table);
        if (WidgetLCAUtil.hasChanged(table, PROP_ITEM_METRICS, itemMetrics)) {
            int[][] metrics = new int[itemMetrics.length][7];
            int i = 0;
            while (i < itemMetrics.length) {
                metrics[i] = new int[]{i, itemMetrics[i].left, itemMetrics[i].width, itemMetrics[i].imageLeft, itemMetrics[i].imageWidth, itemMetrics[i].textLeft, itemMetrics[i].textWidth};
                ++i;
            }
            IClientObject clientObject = ClientObjectFactory.getClientObject(table);
            clientObject.set(PROP_ITEM_METRICS, metrics);
        }
    }

    static ItemMetrics[] getItemMetrics(Table table) {
        ItemMetrics[] result;
        block6: {
            ITableAdapter tableAdapter;
            int columnCount;
            block5: {
                columnCount = Math.max(1, table.getColumnCount());
                result = new ItemMetrics[columnCount];
                int i = 0;
                while (i < columnCount) {
                    result[i] = new ItemMetrics();
                    ++i;
                }
                tableAdapter = table.getAdapter(ITableAdapter.class);
                TableItem measureItem = tableAdapter.getMeasureItem();
                if (measureItem == null) break block5;
                int i2 = 0;
                while (i2 < columnCount) {
                    int leftOffset = tableAdapter.getColumnLeftOffset(i2);
                    Rectangle bounds = measureItem.getBounds(i2);
                    Rectangle imageBounds = measureItem.getImageBounds(i2);
                    Rectangle textBounds = measureItem.getTextBounds(i2);
                    int imageWidth = tableAdapter.getItemImageWidth(i2);
                    if (table.getColumnCount() > 0) {
                        TableColumn column = table.getColumn(i2);
                        int columnLeft = tableAdapter.getColumnLeft(column);
                        int columnWidth = column.getWidth();
                        int maxImageWidth = columnWidth - (imageBounds.x - columnLeft + leftOffset);
                        if (imageWidth > maxImageWidth) {
                            imageWidth = Math.max(0, maxImageWidth);
                        }
                    }
                    result[i2].left = bounds.x + leftOffset;
                    result[i2].width = bounds.width;
                    result[i2].imageLeft = imageBounds.x + leftOffset;
                    result[i2].imageWidth = imageWidth;
                    result[i2].textLeft = textBounds.x + leftOffset;
                    result[i2].textWidth = textBounds.width;
                    ++i2;
                }
                break block6;
            }
            if (table.getColumnCount() <= 0) break block6;
            int i = 0;
            while (i < columnCount) {
                TableColumn column = table.getColumn(i);
                int columnLeft = tableAdapter.getColumnLeft(column);
                int columnWidth = column.getWidth();
                result[i].left = columnLeft;
                result[i].width = columnWidth;
                ++i;
            }
        }
        return result;
    }

    static final class ItemMetrics {
        int left;
        int width;
        int imageLeft;
        int imageWidth;
        int textLeft;
        int textWidth;

        ItemMetrics() {
        }

        public boolean equals(Object obj) {
            boolean result;
            if (obj == this) {
                result = true;
            } else if (obj instanceof ItemMetrics) {
                ItemMetrics other = (ItemMetrics)obj;
                result = other.left == this.left && other.width == this.width && other.imageLeft == this.imageLeft && other.imageWidth == this.imageWidth && other.textLeft == this.textLeft && other.textWidth == this.textWidth;
            } else {
                result = false;
            }
            return result;
        }

        public int hashCode() {
            String msg = "ItemMetrics#hashCode() not implemented";
            throw new UnsupportedOperationException(msg);
        }
    }
}

