/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.textsize;

import org.eclipse.rwt.internal.application.RWTFactory;
import org.eclipse.rwt.internal.textsize.MeasurementOperator;
import org.eclipse.rwt.internal.textsize.ProbeResult;
import org.eclipse.rwt.internal.textsize.ProbeResultStore;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;

final class TextSizeStorageUtil {
    static Point lookup(FontData fontData, String string, int wrapWidth, int mode) {
        Point result = null;
        if (ProbeResultStore.getInstance().containsProbeResult(fontData)) {
            Integer key = TextSizeStorageUtil.getKey(fontData, string, wrapWidth, mode);
            result = RWTFactory.getTextSizeStorage().lookupTextSize(key);
        } else {
            MeasurementOperator.getInstance().addProbeToMeasure(fontData);
        }
        return result;
    }

    static void store(FontData fontData, String string, int wrapWidth, int mode, Point measuredTextSize) {
        TextSizeStorageUtil.checkFontExists(fontData);
        Integer key = TextSizeStorageUtil.getKey(fontData, string, wrapWidth, mode);
        RWTFactory.getTextSizeStorage().storeTextSize(key, measuredTextSize);
    }

    static Integer getKey(FontData fontData, String string, int wrapWidth, int mode) {
        ProbeResultStore instance = ProbeResultStore.getInstance();
        ProbeResult probeResult = instance.getProbeResult(fontData);
        String probeText = probeResult.getProbe().getText();
        Point probeSize = probeResult.getSize();
        int hashCode = 1;
        hashCode = 31 * hashCode + probeText.hashCode();
        hashCode = 31 * hashCode + probeSize.hashCode();
        hashCode = 31 * hashCode + fontData.hashCode();
        hashCode = 31 * hashCode + string.hashCode();
        hashCode = 31 * hashCode + wrapWidth;
        hashCode = 31 * hashCode + mode;
        return hashCode;
    }

    private static void checkFontExists(FontData fontData) {
        if (!ProbeResultStore.getInstance().containsProbeResult(fontData)) {
            String msg = "Font not probed yet: " + fontData.toString();
            throw new IllegalStateException(msg);
        }
    }

    private TextSizeStorageUtil() {
    }
}

