/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rtp.httpdeployer.internal;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.eclipse.rtp.httpdeployer.internal.CommonConstants;
import org.eclipse.rtp.httpdeployer.internal.HttpDeployerUtils;
import org.eclipse.rtp.httpdeployer.internal.RequestResults;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public abstract class AbstractHttpDeployerServlet
extends HttpServlet {
    private static final long serialVersionUID = -1882775409591126187L;

    public void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            Document requestDocument = HttpDeployerUtils.parseXmlRequest(request);
            Document responseDocument = this.parseDeleteRequest(requestDocument);
            HttpDeployerUtils.outputDocument(response, responseDocument);
        }
        catch (JDOMException jDOMException) {
            response.sendError(400);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Document responseDocument = null;
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            try {
                responseDocument = this.parsePostRequest(HttpDeployerUtils.parseXmlRequest(request));
            }
            catch (JDOMException jDOMException) {
                response.sendError(400);
                return;
            }
        }
        try {
            responseDocument = this.parseMultipartPostRequest(request);
        }
        catch (Exception exception) {
            response.sendError(400);
            return;
        }
        HttpDeployerUtils.outputDocument(response, responseDocument);
    }

    protected Document parseRequest(Document request, String searchedElement, CommonConstants.Action action) {
        Element rootElement = request.getRootElement();
        RequestResults result = new RequestResults();
        for (Object child : rootElement.getChildren()) {
            Element currentElement;
            if (!(child instanceof Element) || !(currentElement = (Element)child).getName().equals(searchedElement)) continue;
            this.handleOperation(result, currentElement, action);
        }
        return result.getDocument();
    }

    public abstract void handleOperation(RequestResults var1, Element var2, CommonConstants.Action var3);

    public abstract Document parseDeleteRequest(Document var1);

    public abstract Document parsePostRequest(Document var1);

    public abstract Document parseMultipartPostRequest(HttpServletRequest var1) throws Exception;
}

