/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.engine;

import java.io.File;
import org.eclipse.rwt.internal.engine.RWTConfiguration;
import org.eclipse.rwt.internal.util.ParamCheck;

public class RWTConfigurationImpl
implements RWTConfiguration {
    private static final String PATH_PREFIX = "WEB-INF" + File.separator;
    private static final String CLASSES_PATH = String.valueOf(PATH_PREFIX) + "classes";
    private static final String LIB_PATH = String.valueOf(PATH_PREFIX) + "lib";
    private File contextDirectory;
    private String resourcesDeliveryMode;

    public void configure(String realPath) {
        ParamCheck.notNull(realPath, "realPath");
        this.contextDirectory = new File(realPath);
    }

    public void reset() {
        this.contextDirectory = null;
    }

    public File getContextDirectory() {
        this.checkConfigured();
        return this.contextDirectory;
    }

    public File getLibraryDirectory() {
        this.checkConfigured();
        return new File(this.contextDirectory, LIB_PATH);
    }

    public File getClassDirectory() {
        this.checkConfigured();
        return new File(this.contextDirectory, CLASSES_PATH);
    }

    public String getResourcesDeliveryMode() {
        this.checkConfigured();
        if (this.resourcesDeliveryMode == null) {
            this.resourcesDeliveryMode = this.getConfigValue("resources", "deliverFromDisk");
        }
        return this.resourcesDeliveryMode;
    }

    public boolean isConfigured() {
        return this.contextDirectory != null;
    }

    private String getConfigValue(String tagName, String defaultValue) {
        String result = System.getProperty(tagName);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    private void checkConfigured() {
        if (!this.isConfigured()) {
            throw new IllegalStateException("RWTConfigurationImpl has not been configured.");
        }
    }
}

