/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.lifecycle;

import java.text.MessageFormat;
import org.eclipse.rwt.internal.lifecycle.IDisplayLifeCycleAdapter;
import org.eclipse.rwt.lifecycle.ILifeCycleAdapter;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.swt.widgets.Display;

public final class DisplayUtil {
    private DisplayUtil() {
    }

    public static IDisplayLifeCycleAdapter getLCA(Display display) {
        Class<ILifeCycleAdapter> clazz = ILifeCycleAdapter.class;
        IDisplayLifeCycleAdapter result = (IDisplayLifeCycleAdapter)display.getAdapter(clazz);
        if (result == null) {
            DisplayUtil.throwAdapterException(clazz);
        }
        return result;
    }

    public static IWidgetAdapter getAdapter(Display display) {
        IWidgetAdapter result = display.getAdapter(IWidgetAdapter.class);
        if (result == null) {
            DisplayUtil.throwAdapterException(IWidgetAdapter.class);
        }
        return result;
    }

    public static String getId(Display display) {
        return DisplayUtil.getAdapter(display).getId();
    }

    private static void throwAdapterException(Class clazz) {
        String text = "Could not retrieve an instance of ''{0}''. Probably the AdapterFactory was not properly registered.";
        Object[] param = new Object[]{clazz.getName()};
        String msg = MessageFormat.format(text, param);
        throw new IllegalStateException(msg);
    }
}

