/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.lifecycle;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.rwt.lifecycle.DefaultEntryPointFactory;
import org.eclipse.rwt.lifecycle.IEntryPoint;
import org.eclipse.rwt.lifecycle.IEntryPointFactory;
import org.eclipse.rwt.service.ISessionStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryPointManager {
    public static final String DEFAULT = "default";
    private static final String CURRENT_ENTRY_POINT = String.valueOf(EntryPointManager.class.getName()) + "#currentEntryPointName";
    private final Map<String, IEntryPointFactory> registry = new HashMap<String, IEntryPointFactory>();

    public static String getCurrentEntryPoint() {
        ISessionStore session = ContextProvider.getSession();
        return (String)session.getAttribute(CURRENT_ENTRY_POINT);
    }

    public void register(String name, Class<? extends IEntryPoint> type) {
        ParamCheck.notNull(type, "type");
        this.register(name, new DefaultEntryPointFactory(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String name, IEntryPointFactory entryPointFactory) {
        ParamCheck.notNull(name, "name");
        ParamCheck.notNull(entryPointFactory, "entryPointFactory");
        Map<String, IEntryPointFactory> map = this.registry;
        synchronized (map) {
            if (this.registry.containsKey(name)) {
                String msg = "Entry point already registered: " + name;
                throw new IllegalArgumentException(msg);
            }
            this.registry.put(name, entryPointFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(String name) {
        ParamCheck.notNull(name, "name");
        Map<String, IEntryPointFactory> map = this.registry;
        synchronized (map) {
            this.checkNameExists(name);
            this.registry.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterAll() {
        Map<String, IEntryPointFactory> map = this.registry;
        synchronized (map) {
            this.registry.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createUI(String name) {
        IEntryPointFactory factory;
        ParamCheck.notNull(name, "name");
        Map<String, IEntryPointFactory> map = this.registry;
        synchronized (map) {
            this.checkNameExists(name);
            factory = this.registry.get(name);
        }
        IEntryPoint entryPoint = factory.create();
        EntryPointManager.setCurrentEntryPoint(name);
        return entryPoint.createUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getEntryPoints() {
        Map<String, IEntryPointFactory> map = this.registry;
        synchronized (map) {
            String[] result = new String[this.registry.keySet().size()];
            this.registry.keySet().toArray(result);
            return result;
        }
    }

    private void checkNameExists(String name) {
        if (!this.registry.containsKey(name)) {
            String msg = "Entry point does not exist: " + name;
            throw new IllegalArgumentException(msg);
        }
    }

    private static void setCurrentEntryPoint(String name) {
        ISessionStore session = ContextProvider.getSession();
        session.setAttribute(CURRENT_ENTRY_POINT, name);
    }
}

