/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.lifecycle;

import java.io.IOException;
import org.eclipse.rwt.internal.application.ApplicationContext;
import org.eclipse.rwt.internal.application.ApplicationContextUtil;
import org.eclipse.rwt.internal.lifecycle.CurrentPhase;
import org.eclipse.rwt.internal.lifecycle.EntryPointManager;
import org.eclipse.rwt.internal.lifecycle.FakeContextUtil;
import org.eclipse.rwt.internal.lifecycle.IPhase;
import org.eclipse.rwt.internal.lifecycle.ISessionShutdownAdapter;
import org.eclipse.rwt.internal.lifecycle.IUIThreadHolder;
import org.eclipse.rwt.internal.lifecycle.LifeCycle;
import org.eclipse.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rwt.internal.lifecycle.PhaseExecutor;
import org.eclipse.rwt.internal.lifecycle.PhaseListenerManager;
import org.eclipse.rwt.internal.lifecycle.PrepareUIRoot;
import org.eclipse.rwt.internal.lifecycle.ProcessAction;
import org.eclipse.rwt.internal.lifecycle.ReadData;
import org.eclipse.rwt.internal.lifecycle.Render;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.ServiceContext;
import org.eclipse.rwt.internal.service.SessionStoreImpl;
import org.eclipse.rwt.lifecycle.PhaseId;
import org.eclipse.rwt.lifecycle.PhaseListener;
import org.eclipse.rwt.service.ISessionStore;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.widgets.Display;

public class SimpleLifeCycle
extends LifeCycle {
    private final PhaseListenerManager phaseListenerManager = new PhaseListenerManager(this);
    private final IPhase[] phases;

    public SimpleLifeCycle(EntryPointManager entryPointManager) {
        super(entryPointManager);
        this.phases = new IPhase[]{new PrepareUIRoot(entryPointManager), new ReadData(), new ProcessAction(), new Render()};
    }

    public void execute() throws IOException {
        SimpleLifeCycle.installSessionShutdownAdapter();
        ISessionStore sessionStore = ContextProvider.getSession();
        SimpleLifeCycle.attachThread(LifeCycleUtil.getSessionDisplay(), sessionStore);
        try {
            SessionDisplayPhaseExecutor phaseExecutor = new SessionDisplayPhaseExecutor(this.phaseListenerManager, this.phases);
            phaseExecutor.execute(PhaseId.PREPARE_UI_ROOT);
        }
        finally {
            SimpleLifeCycle.detachThread(LifeCycleUtil.getSessionDisplay(), sessionStore);
        }
    }

    public void requestThreadExec(Runnable runnable) {
        runnable.run();
    }

    public void addPhaseListener(PhaseListener phaseListener) {
        this.phaseListenerManager.addPhaseListener(phaseListener);
    }

    public void removePhaseListener(PhaseListener phaseListener) {
        this.phaseListenerManager.removePhaseListener(phaseListener);
    }

    public void sleep() {
        String msg = "The " + this.getClass().getSimpleName() + " does not support Display#sleep().";
        throw new UnsupportedOperationException(msg);
    }

    private static void installSessionShutdownAdapter() {
        SessionStoreImpl sessionStore = (SessionStoreImpl)ContextProvider.getSession();
        if (sessionStore.getShutdownAdapter() == null) {
            sessionStore.setShutdownAdapter(new SimpleSessionShutdownAdapter());
        }
    }

    private static void attachThread(Display display, ISessionStore sessionStore) {
        if (display != null) {
            IDisplayAdapter displayAdapter = display.getAdapter(IDisplayAdapter.class);
            displayAdapter.attachThread();
        }
        SimpleUIThreadHolder uiThreadHolder = new SimpleUIThreadHolder(Thread.currentThread());
        LifeCycleUtil.setUIThread(sessionStore, uiThreadHolder);
    }

    private static void detachThread(Display display, ISessionStore sessionStore) {
        if (display != null) {
            IDisplayAdapter displayAdapter = display.getAdapter(IDisplayAdapter.class);
            displayAdapter.detachThread();
        }
        LifeCycleUtil.setUIThread(sessionStore, null);
    }

    private static class SessionDisplayPhaseExecutor
    extends PhaseExecutor {
        SessionDisplayPhaseExecutor(PhaseListenerManager phaseListenerManager, IPhase[] phases) {
            super(phaseListenerManager, phases);
        }

        Display getDisplay() {
            return LifeCycleUtil.getSessionDisplay();
        }
    }

    private static class SimpleSessionShutdownAdapter
    implements ISessionShutdownAdapter {
        private Runnable shutdownCallback;
        private ISessionStore sessionStore;

        private SimpleSessionShutdownAdapter() {
        }

        public void setShutdownCallback(Runnable shutdownCallback) {
            this.shutdownCallback = shutdownCallback;
        }

        public void setSessionStore(ISessionStore sessionStore) {
            this.sessionStore = sessionStore;
        }

        public void interceptShutdown() {
            final Display display = LifeCycleUtil.getSessionDisplay(this.sessionStore);
            if (SimpleSessionShutdownAdapter.isDisplayActive(display) && this.isApplicationContextActive()) {
                FakeContextUtil.runNonUIThreadWithFakeContext(display, new Runnable(){

                    public void run() {
                        SimpleLifeCycle.attachThread(display, SimpleSessionShutdownAdapter.this.sessionStore);
                        CurrentPhase.set(PhaseId.PROCESS_ACTION);
                        display.dispose();
                    }
                });
            }
            this.shutdownCallback.run();
        }

        public void processShutdown() {
            throw new UnsupportedOperationException();
        }

        private static boolean isDisplayActive(Display display) {
            return display != null && !display.isDisposed();
        }

        private boolean isApplicationContextActive() {
            ApplicationContext applicationContext = ApplicationContextUtil.get(this.sessionStore);
            return applicationContext != null && applicationContext.isActivated();
        }
    }

    private static class SimpleUIThreadHolder
    implements IUIThreadHolder {
        private final Thread thread;

        public SimpleUIThreadHolder(Thread thread) {
            this.thread = thread;
        }

        public void updateServiceContext() {
            throw new UnsupportedOperationException();
        }

        public void terminateThread() {
            throw new UnsupportedOperationException();
        }

        public void switchThread() {
            throw new UnsupportedOperationException();
        }

        public void setServiceContext(ServiceContext serviceContext) {
            throw new UnsupportedOperationException();
        }

        public Thread getThread() {
            return this.thread;
        }

        public Object getLock() {
            throw new UnsupportedOperationException();
        }
    }
}

