/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.service;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.rwt.internal.RWTMessages;
import org.eclipse.rwt.internal.SingletonManager;
import org.eclipse.rwt.internal.lifecycle.JavaScriptResponseWriter;
import org.eclipse.rwt.internal.lifecycle.LifeCycle;
import org.eclipse.rwt.internal.lifecycle.LifeCycleFactory;
import org.eclipse.rwt.internal.lifecycle.RWTRequestVersionControl;
import org.eclipse.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.rwt.internal.service.RequestParameterBuffer;
import org.eclipse.rwt.internal.service.SessionStoreImpl;
import org.eclipse.rwt.internal.service.StartupPage;
import org.eclipse.rwt.service.IServiceHandler;
import org.eclipse.rwt.service.ISessionStore;

public class LifeCycleServiceHandler
implements IServiceHandler {
    public static final String RWT_INITIALIZE = "rwt_initialize";
    static final String SESSION_INITIALIZED = String.valueOf(LifeCycleServiceHandler.class.getName()) + "#isSessionInitialized";
    private final LifeCycleFactory lifeCycleFactory;
    private final StartupPage startupPage;

    public LifeCycleServiceHandler(LifeCycleFactory lifeCycleFactory, StartupPage startupPage) {
        this.lifeCycleFactory = lifeCycleFactory;
        this.startupPage = startupPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service() throws IOException {
        ISessionStore iSessionStore = ContextProvider.getSession();
        synchronized (iSessionStore) {
            this.synchronizedService();
        }
    }

    void synchronizedService() throws IOException {
        LifeCycleServiceHandler.initializeJavaScriptResponseWriter();
        if (RWTRequestVersionControl.getInstance().isValid() || LifeCycleServiceHandler.isSessionRestart() || ContextProvider.getRequest().getSession().isNew()) {
            this.runLifeCycle();
        } else {
            LifeCycleServiceHandler.handleInvalidRequestCounter();
        }
        LifeCycleServiceHandler.finishJavaScriptResponseWriter();
    }

    public static void initializeSession() {
        if (!LifeCycleServiceHandler.isSessionInitialized() && ContextProvider.getRequest().getParameter(RWT_INITIALIZE) != null) {
            ISessionStore session = ContextProvider.getSession();
            session.setAttribute(SESSION_INITIALIZED, Boolean.TRUE);
        }
    }

    private void runLifeCycle() throws IOException {
        LifeCycleServiceHandler.checkRequest();
        LifeCycleServiceHandler.initializeSession();
        if (LifeCycleServiceHandler.isSessionInitialized()) {
            RequestParameterBuffer.merge();
            LifeCycle lifeCycle = (LifeCycle)this.lifeCycleFactory.getLifeCycle();
            lifeCycle.execute();
        } else {
            Map parameters = ContextProvider.getRequest().getParameterMap();
            RequestParameterBuffer.store(parameters);
            this.startupPage.send();
        }
    }

    private static boolean isSessionRestart() {
        HttpServletRequest request = ContextProvider.getRequest();
        boolean startup = request.getParameter("startup") != null;
        String uiRoot = request.getParameter("uiRoot");
        HttpSession session = request.getSession();
        return !session.isNew() && !startup && uiRoot == null || startup && LifeCycleServiceHandler.isSessionInitialized();
    }

    private static void initializeJavaScriptResponseWriter() throws IOException {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        if (stateInfo.getResponseWriter() == null) {
            HttpServletResponse response = ContextProvider.getResponse();
            stateInfo.setResponseWriter(new JavaScriptResponseWriter((ServletResponse)response));
        }
    }

    private static void finishJavaScriptResponseWriter() {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        JavaScriptResponseWriter responseWriter = stateInfo.getResponseWriter();
        responseWriter.finish();
    }

    private static void handleInvalidRequestCounter() {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("message", RWTMessages.getMessage("RWT_MultipleInstancesError"));
        ProtocolMessageWriter writer = stateInfo.getResponseWriter().getProtocolWriter();
        writer.appendCall("w1", "reload", properties);
    }

    private static boolean isSessionInitialized() {
        ISessionStore session = ContextProvider.getSession();
        return Boolean.TRUE.equals(session.getAttribute(SESSION_INITIALIZED));
    }

    private static void checkRequest() {
        if (LifeCycleServiceHandler.isSessionRestart()) {
            LifeCycleServiceHandler.clearSessionStore();
        }
    }

    private static void clearSessionStore() {
        Integer version = RWTRequestVersionControl.getInstance().getCurrentRequestId();
        SessionStoreImpl sessionStore = (SessionStoreImpl)ContextProvider.getSession();
        sessionStore.valueUnbound(null);
        sessionStore.valueBound(null);
        SingletonManager.install(sessionStore);
        RWTRequestVersionControl.getInstance().setCurrentRequestId(version);
    }
}

