/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.textsize;

import java.util.HashMap;
import org.eclipse.rwt.internal.application.RWTFactory;
import org.eclipse.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rwt.internal.protocol.IClientObject;
import org.eclipse.rwt.internal.textsize.MeasurementItem;
import org.eclipse.rwt.internal.textsize.MeasurementOperator;
import org.eclipse.rwt.internal.textsize.Probe;
import org.eclipse.rwt.internal.textsize.TextSizeUtilFacade;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public final class TextSizeUtilFacadeImpl
extends TextSizeUtilFacade {
    static final String PROPERTY_STRINGS = "strings";
    static final String METHOD_MEASURE_STRINGS = "measureStrings";
    static final String PROPERTY_FONTS = "fonts";
    static final String METHOD_PROBE = "probe";

    public Object[] getStartupProbeObjectInternal() {
        Object[] result = null;
        Probe[] probeList = RWTFactory.getProbeStore().getProbes();
        if (probeList.length > 0) {
            result = new Object[probeList.length];
            int i = 0;
            while (i < probeList.length) {
                result[i] = TextSizeUtilFacadeImpl.createProbeParamObject(probeList[i]);
                ++i;
            }
        }
        return result;
    }

    public String createMeasurementStringInternal(String string, boolean expandNewLines) {
        return expandNewLines ? string : WidgetLCAUtil.replaceNewLines(string, " ");
    }

    public void writeStringMeasurementsInternal() {
        MeasurementItem[] items = MeasurementOperator.getInstance().getItems();
        if (items.length > 0) {
            Object[] itemsObject = new Object[items.length];
            int i = 0;
            while (i < items.length) {
                itemsObject[i] = TextSizeUtilFacadeImpl.createItemParamObject(items[i]);
                ++i;
            }
            TextSizeUtilFacadeImpl.callDisplayMethod(METHOD_MEASURE_STRINGS, PROPERTY_STRINGS, itemsObject);
        }
    }

    public void writeFontProbingInternal() {
        Probe[] probeList = MeasurementOperator.getInstance().getProbes();
        if (probeList.length > 0) {
            Object[] probesObject = new Object[probeList.length];
            int i = 0;
            while (i < probeList.length) {
                probesObject[i] = TextSizeUtilFacadeImpl.createProbeParamObject(probeList[i]);
                ++i;
            }
            TextSizeUtilFacadeImpl.callDisplayMethod(METHOD_PROBE, PROPERTY_FONTS, probesObject);
        }
    }

    private static void callDisplayMethod(String method, String property, Object value) {
        Display display = Display.getCurrent();
        if (display != null) {
            IClientObject clientObject = ClientObjectFactory.getForDisplay(display);
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put(property, value);
            clientObject.call(method, args);
        }
    }

    static Object createItemParamObject(MeasurementItem item) {
        Object[] result = new Object[7];
        result[0] = new Integer(item.hashCode());
        result[1] = item.getTextToMeasure();
        FontData fontData = item.getFontData();
        result[2] = WidgetLCAUtil.parseFontName(fontData.getName());
        result[3] = new Integer(fontData.getHeight());
        result[4] = (fontData.getStyle() & 1) != 0;
        result[5] = (fontData.getStyle() & 2) != 0;
        result[6] = new Integer(item.getWrapWidth());
        return result;
    }

    static Object createProbeParamObject(Probe probe) {
        Object[] result = new Object[6];
        FontData fontData = probe.getFontData();
        result[0] = new Integer(fontData.hashCode());
        result[1] = probe.getText();
        result[2] = WidgetLCAUtil.parseFontName(fontData.getName());
        result[3] = new Integer(fontData.getHeight());
        result[4] = (fontData.getStyle() & 1) != 0;
        result[5] = (fontData.getStyle() & 2) != 0;
        return result;
    }
}

