/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.datetimekit;

import java.io.IOException;
import org.eclipse.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.internal.widgets.IDateTimeAdapter;
import org.eclipse.swt.internal.widgets.datetimekit.AbstractDateTimeLCADelegate;
import org.eclipse.swt.internal.widgets.datetimekit.DateTimeLCAUtil;
import org.eclipse.swt.widgets.DateTime;

final class DateTimeCalendarLCA
extends AbstractDateTimeLCADelegate {
    static final String PROP_DAY = "day";
    static final String PROP_MONTH = "month";
    static final String PROP_YEAR = "year";

    DateTimeCalendarLCA() {
    }

    void preserveValues(DateTime dateTime) {
        ControlLCAUtil.preserveValues(dateTime);
        IWidgetAdapter adapter = WidgetUtil.getAdapter(dateTime);
        boolean hasListeners = SelectionEvent.hasListener(dateTime);
        adapter.preserve("selectionListeners", hasListeners);
        adapter.preserve(PROP_DAY, new Integer(dateTime.getDay()));
        adapter.preserve(PROP_MONTH, new Integer(dateTime.getMonth()));
        adapter.preserve(PROP_YEAR, new Integer(dateTime.getYear()));
        WidgetLCAUtil.preserveCustomVariant(dateTime);
    }

    void readData(DateTime dateTime) {
        String day = WidgetLCAUtil.readPropertyValue(dateTime, PROP_DAY);
        String month = WidgetLCAUtil.readPropertyValue(dateTime, PROP_MONTH);
        String year = WidgetLCAUtil.readPropertyValue(dateTime, PROP_YEAR);
        if (day != null && month != null && year != null) {
            dateTime.setDate(NumberFormatUtil.parseInt(year), NumberFormatUtil.parseInt(month), NumberFormatUtil.parseInt(day));
        }
        ControlLCAUtil.processSelection(dateTime, null, true);
        ControlLCAUtil.processMouseEvents(dateTime);
        ControlLCAUtil.processKeyEvents(dateTime);
        ControlLCAUtil.processMenuDetect(dateTime);
        WidgetLCAUtil.processHelp(dateTime);
    }

    void renderInitialization(DateTime dateTime) throws IOException {
        IDateTimeAdapter dateTimeAdapter = DateTimeLCAUtil.getDateTimeAdapter(dateTime);
        JSWriter writer = JSWriter.getWriterFor(dateTime);
        String style = "";
        if ((dateTime.getStyle() & 0x8000) != 0) {
            style = "short";
        } else if ((dateTime.getStyle() & 0x10000) != 0) {
            style = "medium";
        } else if ((dateTime.getStyle() & 0x10000000) != 0) {
            style = "long";
        }
        DateTimeLCAUtil.initCellSize(dateTime);
        Object[] args = new Object[]{style, dateTimeAdapter.getMonthNames(), dateTimeAdapter.getWeekdayShortNames()};
        writer.newWidget("org.eclipse.swt.widgets.DateTimeCalendar", args);
        ControlLCAUtil.writeStyleFlags(dateTime);
    }

    void renderChanges(DateTime dateTime) throws IOException {
        ControlLCAUtil.writeChanges(dateTime);
        this.writeYear(dateTime);
        this.writeMonth(dateTime);
        this.writeDay(dateTime);
        DateTimeLCAUtil.writeListener(dateTime);
        WidgetLCAUtil.writeCustomVariant(dateTime);
    }

    private void writeDay(DateTime dateTime) throws IOException {
        Integer newValue = new Integer(dateTime.getDay());
        if (WidgetLCAUtil.hasChanged(dateTime, PROP_DAY, newValue)) {
            JSWriter writer = JSWriter.getWriterFor(dateTime);
            writer.set(PROP_DAY, newValue);
        }
    }

    private void writeMonth(DateTime dateTime) throws IOException {
        Integer newValue = new Integer(dateTime.getMonth());
        if (WidgetLCAUtil.hasChanged(dateTime, PROP_MONTH, newValue)) {
            JSWriter writer = JSWriter.getWriterFor(dateTime);
            writer.set(PROP_MONTH, newValue);
        }
    }

    private void writeYear(DateTime dateTime) throws IOException {
        Integer newValue = new Integer(dateTime.getYear());
        if (WidgetLCAUtil.hasChanged(dateTime, PROP_YEAR, newValue)) {
            JSWriter writer = JSWriter.getWriterFor(dateTime);
            writer.set(PROP_YEAR, newValue);
        }
    }
}

