/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.datetimekit;

import java.io.IOException;
import org.eclipse.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.internal.widgets.IDateTimeAdapter;
import org.eclipse.swt.internal.widgets.datetimekit.AbstractDateTimeLCADelegate;
import org.eclipse.swt.internal.widgets.datetimekit.DateTimeLCAUtil;
import org.eclipse.swt.widgets.DateTime;

final class DateTimeDateLCA
extends AbstractDateTimeLCADelegate {
    static final String PROP_DAY = "day";
    static final String PROP_MONTH = "month";
    static final String PROP_YEAR = "year";

    DateTimeDateLCA() {
    }

    void preserveValues(DateTime dateTime) {
        ControlLCAUtil.preserveValues(dateTime);
        IWidgetAdapter adapter = WidgetUtil.getAdapter(dateTime);
        boolean hasListeners = SelectionEvent.hasListener(dateTime);
        adapter.preserve("selectionListeners", hasListeners);
        adapter.preserve(PROP_DAY, new Integer(dateTime.getDay()));
        adapter.preserve(PROP_MONTH, new Integer(dateTime.getMonth()));
        adapter.preserve(PROP_YEAR, new Integer(dateTime.getYear()));
        this.preserveSubWidgetsBounds(dateTime);
        WidgetLCAUtil.preserveCustomVariant(dateTime);
    }

    void readData(DateTime dateTime) {
        String day = WidgetLCAUtil.readPropertyValue(dateTime, PROP_DAY);
        String month = WidgetLCAUtil.readPropertyValue(dateTime, PROP_MONTH);
        String year = WidgetLCAUtil.readPropertyValue(dateTime, PROP_YEAR);
        if (day != null && month != null && year != null) {
            dateTime.setDate(NumberFormatUtil.parseInt(year), NumberFormatUtil.parseInt(month), NumberFormatUtil.parseInt(day));
        }
        ControlLCAUtil.processSelection(dateTime, null, true);
        ControlLCAUtil.processMouseEvents(dateTime);
        ControlLCAUtil.processKeyEvents(dateTime);
        ControlLCAUtil.processMenuDetect(dateTime);
        WidgetLCAUtil.processHelp(dateTime);
    }

    void renderInitialization(DateTime dateTime) throws IOException {
        IDateTimeAdapter dateTimeAdapter = DateTimeLCAUtil.getDateTimeAdapter(dateTime);
        JSWriter writer = JSWriter.getWriterFor(dateTime);
        String style = "";
        if ((dateTime.getStyle() & 0x8000) != 0) {
            style = "short";
        } else if ((dateTime.getStyle() & 0x10000) != 0) {
            style = "medium";
        } else if ((dateTime.getStyle() & 0x10000000) != 0) {
            style = "long";
        }
        if ((dateTime.getStyle() & 4) != 0) {
            style = String.valueOf(style) + "drop_down";
        }
        DateTimeLCAUtil.initCellSize(dateTime);
        Object[] args = new Object[]{style, dateTimeAdapter.getMonthNames(), dateTimeAdapter.getWeekdayNames(), dateTimeAdapter.getWeekdayShortNames(), dateTimeAdapter.getDateSeparator(), dateTimeAdapter.getDatePattern()};
        writer.newWidget("org.eclipse.swt.widgets.DateTimeDate", args);
        ControlLCAUtil.writeStyleFlags(dateTime);
    }

    void renderChanges(DateTime dateTime) throws IOException {
        ControlLCAUtil.writeChanges(dateTime);
        this.writeYear(dateTime);
        this.writeMonth(dateTime);
        this.writeDay(dateTime);
        DateTimeLCAUtil.writeListener(dateTime);
        this.writeSubWidgetsBounds(dateTime);
        WidgetLCAUtil.writeCustomVariant(dateTime);
    }

    private void writeDay(DateTime dateTime) throws IOException {
        Integer newValue = new Integer(dateTime.getDay());
        if (WidgetLCAUtil.hasChanged(dateTime, PROP_DAY, newValue)) {
            JSWriter writer = JSWriter.getWriterFor(dateTime);
            writer.set(PROP_DAY, newValue);
        }
    }

    private void writeMonth(DateTime dateTime) throws IOException {
        Integer newValue = new Integer(dateTime.getMonth());
        if (WidgetLCAUtil.hasChanged(dateTime, PROP_MONTH, newValue)) {
            JSWriter writer = JSWriter.getWriterFor(dateTime);
            writer.set(PROP_MONTH, newValue);
        }
    }

    private void writeYear(DateTime dateTime) throws IOException {
        Integer newValue = new Integer(dateTime.getYear());
        if (WidgetLCAUtil.hasChanged(dateTime, PROP_YEAR, newValue)) {
            JSWriter writer = JSWriter.getWriterFor(dateTime);
            writer.set(PROP_YEAR, newValue);
        }
    }

    private void writeSubWidgetsBounds(DateTime dateTime) throws IOException {
        DateTimeLCAUtil.writeSubWidgetBounds(dateTime, 0);
        DateTimeLCAUtil.writeSubWidgetBounds(dateTime, 4);
        DateTimeLCAUtil.writeSubWidgetBounds(dateTime, 2);
        DateTimeLCAUtil.writeSubWidgetBounds(dateTime, 5);
        DateTimeLCAUtil.writeSubWidgetBounds(dateTime, 1);
        DateTimeLCAUtil.writeSubWidgetBounds(dateTime, 6);
        DateTimeLCAUtil.writeSubWidgetBounds(dateTime, 3);
        DateTimeLCAUtil.writeSubWidgetBounds(dateTime, 7);
        DateTimeLCAUtil.writeSubWidgetBounds(dateTime, 13);
    }

    private void preserveSubWidgetsBounds(DateTime dateTime) {
        DateTimeLCAUtil.preserveSubWidgetBounds(dateTime, 0);
        DateTimeLCAUtil.preserveSubWidgetBounds(dateTime, 4);
        DateTimeLCAUtil.preserveSubWidgetBounds(dateTime, 2);
        DateTimeLCAUtil.preserveSubWidgetBounds(dateTime, 5);
        DateTimeLCAUtil.preserveSubWidgetBounds(dateTime, 1);
        DateTimeLCAUtil.preserveSubWidgetBounds(dateTime, 6);
        DateTimeLCAUtil.preserveSubWidgetBounds(dateTime, 3);
        DateTimeLCAUtil.preserveSubWidgetBounds(dateTime, 7);
        DateTimeLCAUtil.preserveSubWidgetBounds(dateTime, 13);
    }
}

