/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.labelkit;

import java.io.IOException;
import org.eclipse.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rwt.internal.protocol.IClientObject;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.internal.widgets.labelkit.AbstractLabelLCADelegate;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;

final class StandardLabelLCA
extends AbstractLabelLCADelegate {
    private static final String TYPE = "rwt.widgets.Label";
    private static final String PROP_TEXT = "text";
    private static final String PROP_ALIGNMENT = "alignment";
    private static final String PROP_IMAGE = "image";
    private static final String DEFAULT_ALIGNMENT = "left";

    StandardLabelLCA() {
    }

    void preserveValues(Label label) {
        ControlLCAUtil.preserveValues(label);
        WidgetLCAUtil.preserveCustomVariant(label);
        WidgetLCAUtil.preserveProperty((Widget)label, PROP_TEXT, label.getText());
        WidgetLCAUtil.preserveProperty((Widget)label, PROP_IMAGE, label.getImage());
        WidgetLCAUtil.preserveProperty((Widget)label, PROP_ALIGNMENT, StandardLabelLCA.getAlignment(label));
    }

    void readData(Label label) {
        ControlLCAUtil.processMouseEvents(label);
        ControlLCAUtil.processKeyEvents(label);
        ControlLCAUtil.processMenuDetect(label);
        WidgetLCAUtil.processHelp(label);
    }

    void renderInitialization(Label label) throws IOException {
        IClientObject clientObject = ClientObjectFactory.getForWidget(label);
        clientObject.create(TYPE);
        clientObject.setProperty("parent", WidgetUtil.getId(label.getParent()));
        clientObject.setProperty("style", WidgetLCAUtil.getStyles(label));
    }

    void renderChanges(Label label) throws IOException {
        ControlLCAUtil.renderChanges(label);
        WidgetLCAUtil.renderCustomVariant(label);
        WidgetLCAUtil.renderProperty((Widget)label, PROP_TEXT, label.getText(), "");
        WidgetLCAUtil.renderProperty((Widget)label, PROP_IMAGE, label.getImage(), null);
        WidgetLCAUtil.renderProperty((Widget)label, PROP_ALIGNMENT, StandardLabelLCA.getAlignment(label), DEFAULT_ALIGNMENT);
    }

    private static String getAlignment(Label label) {
        int alignment = label.getAlignment();
        String result = (alignment & 0x4000) != 0 ? DEFAULT_ALIGNMENT : ((alignment & 0x1000000) != 0 ? "center" : ((alignment & 0x20000) != 0 ? "right" : DEFAULT_ALIGNMENT));
        return result;
    }
}

