/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.menuitemkit;

import java.io.IOException;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.internal.widgets.ItemLCAUtil;
import org.eclipse.swt.internal.widgets.menuitemkit.MenuItemDelegateLCA;
import org.eclipse.swt.internal.widgets.menuitemkit.MenuItemLCAUtil;
import org.eclipse.swt.widgets.MenuItem;

final class CheckMenuItemLCA
extends MenuItemDelegateLCA {
    private static final String ITEM_TYPE_CHECK = "check";

    CheckMenuItemLCA() {
    }

    void preserveValues(MenuItem menuItem) {
        ItemLCAUtil.preserve(menuItem);
        IWidgetAdapter adapter = WidgetUtil.getAdapter(menuItem);
        boolean hasListener = SelectionEvent.hasListener(menuItem);
        adapter.preserve("selectionListeners", hasListener);
        adapter.preserve("selection", menuItem.getSelection());
        MenuItemLCAUtil.preserveEnabled(menuItem);
        WidgetLCAUtil.preserveCustomVariant(menuItem);
        WidgetLCAUtil.preserveHelpListener(menuItem);
    }

    void readData(MenuItem menuItem) {
        String value = WidgetLCAUtil.readPropertyValue(menuItem, "selection");
        if (value != null) {
            menuItem.setSelection(Boolean.valueOf(value));
        }
        ControlLCAUtil.processSelection(menuItem, null, false);
        WidgetLCAUtil.processHelp(menuItem);
        MenuItemLCAUtil.processArmEvent(menuItem);
    }

    void renderInitialization(MenuItem menuItem) throws IOException {
        MenuItemLCAUtil.newItem(menuItem, "org.eclipse.rwt.widgets.MenuItem", ITEM_TYPE_CHECK);
    }

    void renderChanges(MenuItem menuItem) throws IOException {
        MenuItemLCAUtil.writeImageAndText(menuItem);
        MenuItemLCAUtil.writeSelectionListener(menuItem);
        MenuItemLCAUtil.writeSelection(menuItem);
        MenuItemLCAUtil.writeEnabled(menuItem);
        WidgetLCAUtil.writeCustomVariant(menuItem);
        WidgetLCAUtil.writeHelpListener(menuItem);
    }
}

