/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.osgi.internal;

import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import org.eclipse.rap.rwt.osgi.ApplicationReference;
import org.eclipse.rap.rwt.osgi.internal.ApplicationLauncherImpl;
import org.eclipse.rap.rwt.osgi.internal.CutOffContextPathWrapper;
import org.eclipse.rap.rwt.osgi.internal.HttpContextWrapper;
import org.eclipse.rap.rwt.osgi.internal.ServletContextWrapper;
import org.eclipse.rwt.application.Application;
import org.eclipse.rwt.application.ApplicationConfigurator;
import org.eclipse.rwt.engine.RWTServlet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

class ApplicationReferenceImpl
implements ApplicationReference {
    static final String SERVLET_CONTEXT_FINDER_ALIAS = "servlet_context_finder";
    static final String DEFAULT_ALIAS = "rap";
    private ApplicationConfigurator configurator;
    private HttpService httpService;
    private HttpContext httpContext;
    private String contextLocation;
    private String contextName;
    private ServletContext servletContextWrapper;
    private Application application;
    private ApplicationLauncherImpl applicationLauncher;
    private ServiceRegistration<?> serviceRegistration;
    private volatile boolean alive;

    ApplicationReferenceImpl(ApplicationConfigurator configurator, HttpService httpService, HttpContext httpContext, String contextName, String contextLocation, ApplicationLauncherImpl applicationLauncher) {
        this.configurator = configurator;
        this.httpService = httpService;
        this.httpContext = this.createWrappedHttpContext(httpContext);
        this.contextLocation = contextLocation;
        this.contextName = contextName;
        this.applicationLauncher = applicationLauncher;
    }

    void start() {
        this.createApplication(this.registerServletContextProviderServlet());
        try {
            this.startRWTApplication();
        }
        finally {
            this.unregisterServletContextProviderServlet();
        }
        this.markAlive();
    }

    private void createApplication(HttpServlet contextProviderServlet) {
        ServletContext servletContext = contextProviderServlet.getServletContext();
        this.servletContextWrapper = new ServletContextWrapper(servletContext, this.contextLocation);
        this.application = new Application(this.configurator, this.servletContextWrapper);
    }

    private void startRWTApplication() {
        this.application.start();
        this.registerServlets();
        this.registerResourceDirectory();
        this.registerAsService();
    }

    private void registerServlets() {
        String[] aliases = this.application.getServletNames();
        if (aliases.length == 0) {
            this.registerServlet(DEFAULT_ALIAS, (HttpServlet)new RWTServlet());
        }
        String[] stringArray = aliases;
        int n = aliases.length;
        int n2 = 0;
        while (n2 < n) {
            String alias = stringArray[n2];
            this.registerServlet(alias, (HttpServlet)new RWTServlet());
            ++n2;
        }
    }

    public void stopApplication() {
        if (!this.hasBeenStopped()) {
            this.doStopApplication();
        }
    }

    private synchronized boolean hasBeenStopped() {
        boolean result;
        boolean bl = result = !this.alive;
        if (this.alive) {
            this.markNotAlive();
        }
        return result;
    }

    private void doStopApplication() {
        this.registerServletContextProviderServlet();
        this.notifyAboutToStop();
        try {
            this.stopRWTApplication();
        }
        finally {
            this.unregisterServletContextProviderServlet();
        }
        this.clearFields();
    }

    private void stopRWTApplication() {
        this.unregisterServlets();
        this.unregisterResourcesDirectory();
        this.serviceRegistration.unregister();
        this.application.stop();
    }

    private void unregisterServlets() {
        String[] aliases = this.application.getServletNames();
        if (aliases.length == 0) {
            this.unregisterServlet(DEFAULT_ALIAS);
        }
        String[] stringArray = aliases;
        int n = aliases.length;
        int n2 = 0;
        while (n2 < n) {
            String alias = stringArray[n2];
            this.unregisterServlet(alias);
            ++n2;
        }
    }

    boolean belongsTo(Object service) {
        return this.configurator == service || this.httpService == service;
    }

    private void unregisterServletContextProviderServlet() {
        this.unregisterServlet(SERVLET_CONTEXT_FINDER_ALIAS);
    }

    private HttpContext createWrappedHttpContext(HttpContext httpContext) {
        HttpContextWrapper result = httpContext == null ? this.wrapHttpContext(this.httpService.createDefaultHttpContext()) : this.wrapHttpContext(httpContext);
        return result;
    }

    private HttpContextWrapper wrapHttpContext(HttpContext createDefaultHttpContext) {
        return new HttpContextWrapper(createDefaultHttpContext);
    }

    private HttpServlet registerServletContextProviderServlet() {
        HttpServlet result = new HttpServlet(){
            private static final long serialVersionUID = 1L;
        };
        this.registerServlet(SERVLET_CONTEXT_FINDER_ALIAS, result);
        return result;
    }

    private void registerAsService() {
        String clazz = ApplicationReference.class.getName();
        this.serviceRegistration = this.getBundleContext().registerService(clazz, (Object)this, null);
    }

    private BundleContext getBundleContext() {
        return this.applicationLauncher.getBundleContext();
    }

    private void registerServlet(String alias, HttpServlet servlet) {
        try {
            CutOffContextPathWrapper wrapper = new CutOffContextPathWrapper(servlet, this.servletContextWrapper, alias);
            this.httpService.registerServlet(String.valueOf(this.getContextSegment()) + "/" + alias, (Servlet)wrapper, null, this.httpContext);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception shouldNotHappen) {
            throw new RuntimeException(shouldNotHappen);
        }
    }

    private void registerResourceDirectory() {
        String alias = "rwt-resources";
        String location = String.valueOf(this.contextLocation) + "/" + alias;
        try {
            this.httpService.registerResources(String.valueOf(this.getContextSegment()) + "/" + alias, location, this.httpContext);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception shouldNotHappen) {
            throw new RuntimeException(shouldNotHappen);
        }
    }

    private void clearFields() {
        this.application = null;
        this.httpService = null;
        this.httpContext = null;
        this.configurator = null;
        this.contextName = null;
        this.contextLocation = null;
        this.applicationLauncher = null;
        this.servletContextWrapper = null;
    }

    private void unregisterServlet(String alias) {
        this.httpService.unregister(String.valueOf(this.getContextSegment()) + "/" + alias);
    }

    private void unregisterResourcesDirectory() {
        this.httpService.unregister(String.valueOf(this.getContextSegment()) + "/" + "rwt-resources");
    }

    private void notifyAboutToStop() {
        this.applicationLauncher.notifyContextAboutToStop(this);
    }

    private String getContextSegment() {
        String result = "";
        if (this.contextName != null) {
            result = "/" + this.contextName;
        }
        return result;
    }

    boolean isAlive() {
        return this.alive;
    }

    private void markAlive() {
        this.alive = true;
    }

    private void markNotAlive() {
        this.alive = false;
    }
}

