/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.application;

import java.util.HashSet;
import javax.servlet.ServletContext;
import org.eclipse.rwt.application.ApplicationConfigurator;
import org.eclipse.rwt.branding.AbstractBranding;
import org.eclipse.rwt.internal.application.ApplicationContext;
import org.eclipse.rwt.internal.application.ApplicationContextUtil;
import org.eclipse.rwt.internal.util.ParamCheck;

public class Application {
    public static final String RESOURCES = "rwt-resources";
    private final ServletContext servletContext;
    private final ApplicationContext applicationContext;

    public Application(ApplicationConfigurator configurator, ServletContext servletContext) {
        ParamCheck.notNull(servletContext, "servletContext");
        ParamCheck.notNull(configurator, "configurator");
        this.applicationContext = new ApplicationContext(configurator, servletContext);
        this.servletContext = servletContext;
    }

    public void start() {
        ApplicationContextUtil.set(this.servletContext, this.applicationContext);
        this.activateApplicationContext();
    }

    public void stop() {
        try {
            if (this.applicationContext.isActivated()) {
                this.applicationContext.deactivate();
            }
        }
        finally {
            ApplicationContextUtil.remove(this.servletContext);
        }
    }

    public String[] getServletNames() {
        AbstractBranding[] all = this.applicationContext.getBrandingManager().getAll();
        HashSet<String> names = new HashSet<String>();
        AbstractBranding[] abstractBrandingArray = all;
        int n = all.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractBranding branding = abstractBrandingArray[n2];
            names.add(branding.getServletName());
            ++n2;
        }
        return names.toArray(new String[names.size()]);
    }

    private void activateApplicationContext() {
        try {
            this.applicationContext.activate();
        }
        catch (RuntimeException rte) {
            ApplicationContextUtil.remove(this.servletContext);
            throw rte;
        }
    }
}

