/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.protocol;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.rwt.internal.protocol.JsonUtil;
import org.eclipse.rwt.internal.theme.JsonObject;
import org.eclipse.rwt.internal.theme.JsonValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Operation {
    private final String action;
    private final String target;
    private Map<String, Object> details;
    private Map<String, Object> properties;

    Operation(String target, String action) {
        this.target = target;
        this.action = action;
        this.details = new LinkedHashMap<String, Object>();
        this.properties = new LinkedHashMap<String, Object>();
    }

    String getTarget() {
        return this.target;
    }

    String getAction() {
        return this.action;
    }

    void appendProperty(String key, JsonValue value) {
        if (this.properties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicate property " + key);
        }
        this.properties.put(key, value);
    }

    void appendProperties(Map<String, Object> properties) {
        if (properties != null && !properties.isEmpty()) {
            Set<String> keySet = properties.keySet();
            for (String key : keySet) {
                this.appendProperty(key, JsonUtil.createJsonValue(properties.get(key)));
            }
        }
    }

    void appendDetail(String key, JsonValue value) {
        if (this.details.containsKey(key)) {
            throw new IllegalArgumentException("Duplicate detail " + key);
        }
        this.details.put(key, value);
    }

    JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.append("target", this.target);
        json.append("action", this.action);
        if (!this.details.isEmpty()) {
            Set<String> keySet = this.details.keySet();
            for (String key : keySet) {
                json.append(key, JsonUtil.createJsonValue(this.details.get(key)));
            }
        }
        if (!this.properties.isEmpty()) {
            JsonValue jsonObject = JsonUtil.createJsonObject(this.properties);
            json.append("properties", jsonObject);
        }
        return json;
    }
}

