/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.protocol;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public final class RWTStylesUtil {
    public static String[] getAllowedStylesForWidget(Widget widget) {
        Class<?> widgetClass = widget.getClass();
        String[] result = RWTStylesUtil.getAllowedStylesByClass(widgetClass);
        while (result == null) {
            widgetClass = widgetClass.getSuperclass();
            result = RWTStylesUtil.getAllowedStylesByClass(widgetClass);
        }
        return result;
    }

    private static String[] getAllowedStylesByClass(Class clazz) {
        String[] result = null;
        String widgetType = clazz.getName();
        AllowedStyles[] allowedStylesArray = AllowedStyles.values();
        int n = allowedStylesArray.length;
        int n2 = 0;
        while (n2 < n) {
            AllowedStyles allowedStyles = allowedStylesArray[n2];
            if (allowedStyles.getWidgetType().equals(widgetType)) {
                result = allowedStyles.getStyles();
            }
            ++n2;
        }
        return result;
    }

    private RWTStylesUtil() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AllowedStyles {
        BUTTON(Button.class.getName(), new String[]{"CHECK", "PUSH", "RADIO", "TOGGLE", "FLAT", "WRAP", "LEFT", "RIGHT", "CENTER", "BORDER", "LEFT_TO_RIGHT"}),
        COLOR_DIALOG(ColorDialog.class.getName(), new String[]{"APPLICATION_MODAL", "PRIMARY_MODAL", "SYSTEM_MODAL"}),
        COMBO(Combo.class.getName(), new String[]{"DROP_DOWN", "READ_ONLY", "NO_FOCUS", "NO_RADIO_GROUP", "H_SCROLL", "V_SCROLL", "BORDER", "LEFT_TO_RIGHT"}),
        CCOMBO(CCombo.class.getName(), new String[]{"FLAT", "READ_ONLY", "NO_FOCUS", "NO_RADIO_GROUP", "H_SCROLL", "V_SCROLL", "BORDER", "LEFT_TO_RIGHT"}),
        COMPOSITE(Composite.class.getName(), new String[]{"NO_FOCUS", "NO_RADIO_GROUP", "H_SCROLL", "V_SCROLL", "BORDER", "LEFT_TO_RIGHT"}),
        CONTROL(Control.class.getName(), new String[]{"BORDER", "LEFT_TO_RIGHT"}),
        COOL_BAR(CoolBar.class.getName(), new String[]{"FLAT", "HORIZONTAL", "VERTICAL", "NO_FOCUS", "NO_RADIO_GROUP", "H_SCROLL", "V_SCROLL", "BORDER", "LEFT_TO_RIGHT"}),
        COOL_ITEM(CoolItem.class.getName(), new String[]{"DROP_DOWN"}),
        DATE_TIME(DateTime.class.getName(), new String[]{"DATE", "TIME", "CALENDAR", "SHORT", "MEDIUM", "LONG", "DROP_DOWN", "NO_FOCUS", "NO_RADIO_GROUP", "H_SCROLL", "V_SCROLL", "BORDER", "LEFT_TO_RIGHT"}),
        DECORATIONS(Decorations.class.getName(), new String[]{"NO_FOCUS", "NO_RADIO_GROUP", "H_SCROLL", "V_SCROLL", "BORDER", "LEFT_TO_RIGHT"}),
        DIALOG(Dialog.class.getName(), new String[]{"APPLICATION_MODAL", "PRIMARY_MODAL", "SYSTEM_MODAL"}),
        EXPAND_BAR(ExpandBar.class.getName(), new String[]{"V_SCROLL", "NO_FOCUS", "NO_RADIO_GROUP", "H_SCROLL", "V_SCROLL", "BORDER", "LEFT_TO_RIGHT"}),
        FONT_DIALOG(FontDialog.class.getName(), new String[]{"APPLICATION_MODAL", "PRIMARY_MODAL", "SYSTEM_MODAL"}),
        GROUP(Group.class.getName(), new String[]{"SHADOW_ETCHED_IN", "SHADOW_ETCHED_OUT", "SHADOW_IN", "SHADOW_OUT", "SHADOW_NONE", "NO_FOCUS", "NO_RADIO_GROUP", "H_SCROLL", "V_SCROLL", "BORDER", "LEFT_TO_RIGHT"}),
        LABEL(Label.class.getName(), new String[]{"SEPARATOR", "HORIZONTAL", "VERTICAL", "SHADOW_IN", "SHADOW_OUT", "SHADOW_NONE", "CENTER", "LEFT", "RIGHT", "WRAP", "BORDER", "LEFT_TO_RIGHT"}),
        CLABEL(CLabel.class.getName(), new String[]{"SHADOW_IN", "SHADOW_OUT", "SHADOW_NONE", "CENTER", "LEFT", "RIGHT", "BORDER", "LEFT_TO_RIGHT"}),
        LINK(Link.class.getName(), new String[]{"BORDER", "LEFT_TO_RIGHT"}),
        LIST(List.class.getName(), new String[]{"SINGLE", "MULTI", "H_SCROLL", "V_SCROLL", "BORDER", "LEFT_TO_RIGHT"}),
        MENU(Menu.class.getName(), new String[]{"BAR", "DROP_DOWN", "POP_UP", "NO_RADIO_GROUP", "LEFT_TO_RIGHT"}),
        MENU_ITEM(MenuItem.class.getName(), new String[]{"CHECK", "CASCADE", "PUSH", "RADIO", "SEPARATOR"}),
        MESSAGE_BOX(MessageBox.class.getName(), new String[]{"ICON_ERROR", "ICON_INFORMATION", "ICON_QUESTION", "ICON_WARNING", "ICON_WORKING", "OK", "CANCEL", "NO", "RETRY", "YES", "ABORT", "IGNORE", "APPLICATION_MODAL", "PRIMARY_MODAL", "SYSTEM_MODAL"}),
        PROGRESS_BAR(ProgressBar.class.getName(), new String[]{"SMOOTH", "HORIZONTAL", "VERTICAL", "INDETERMINATE", "BORDER", "LEFT_TO_RIGHT"}),
        SASH(Sash.class.getName(), new String[]{"HORIZONTAL", "VERTICAL", "SMOOTH", "BORDER", "LEFT_TO_RIGHT"}),
        SCALE(Scale.class.getName(), new String[]{"HORIZONTAL", "VERTICAL", "BORDER", "LEFT_TO_RIGHT"}),
        SCROLLABLE(Scrollable.class.getName(), new String[]{"H_SCROLL", "V_SCROLL", "BORDER", "LEFT_TO_RIGHT"}),
        SCROLL_BAR(ScrollBar.class.getName(), new String[]{"HORIZONTAL", "VERTICAL"}),
        SHELL(Shell.class.getName(), new String[]{"BORDER", "CLOSE", "MIN", "MAX", "NO_TRIM", "RESIZE", "TITLE", "ON_TOP", "TOOL", "SHEET", "APPLICATION_MODAL", "MODELESS", "PRIMARY_MODAL", "SYSTEM_MODAL"}),
        SLIDER(Slider.class.getName(), new String[]{"HORIZONTAL", "VERTICAL", "BORDER", "LEFT_TO_RIGHT"}),
        SPINNER(Spinner.class.getName(), new String[]{"READ_ONLY", "WRAP", "NO_FOCUS", "NO_RADIO_GROUP", "H_SCROLL", "V_SCROLL", "BORDER", "LEFT_TO_RIGHT"}),
        TAB_FOLDER(TabFolder.class.getName(), new String[]{"TOP", "BOTTOM", "NO_FOCUS", "NO_RADIO_GROUP", "H_SCROLL", "V_SCROLL", "BORDER", "LEFT_TO_RIGHT"}),
        TABLE(Table.class.getName(), new String[]{"SINGLE", "MULTI", "CHECK", "FULL_SELECTION", "HIDE_SELECTION", "VIRTUAL", "NO_FOCUS", "NO_RADIO_GROUP", "H_SCROLL", "V_SCROLL", "BORDER", "LEFT_TO_RIGHT"}),
        TABLE_COLUMN(TableColumn.class.getName(), new String[]{"LEFT", "RIGHT", "CENTER"}),
        TEXT(Text.class.getName(), new String[]{"CENTER", "LEFT", "MULTI", "PASSWORD", "SEARCH", "SINGLE", "RIGHT", "READ_ONLY", "WRAP", "H_SCROLL", "V_SCROLL", "BORDER", "LEFT_TO_RIGHT"}),
        TOOL_BAR(ToolBar.class.getName(), new String[]{"FLAT", "HORIZONTAL", "VERTICAL", "NO_FOCUS", "NO_RADIO_GROUP", "BORDER", "LEFT_TO_RIGHT"}),
        TOOL_ITEM(ToolItem.class.getName(), new String[]{"PUSH", "CHECK", "RADIO", "SEPARATOR", "DROP_DOWN"}),
        TOOL_TIP(ToolTip.class.getName(), new String[]{"BALLOON", "ICON_ERROR", "ICON_INFORMATION", "ICON_WARNING"}),
        TREE(Tree.class.getName(), new String[]{"SINGLE", "MULTI", "CHECK", "FULL_SELECTION", "VIRTUAL", "NO_SCROLL", "NO_FOCUS", "NO_RADIO_GROUP", "H_SCROLL", "V_SCROLL", "BORDER", "LEFT_TO_RIGHT"}),
        TREE_COLUMN(TreeColumn.class.getName(), new String[]{"LEFT", "RIGHT", "CENTER"}),
        CANVAS(Canvas.class.getName(), new String[]{"NO_FOCUS", "NO_RADIO_GROUP", "H_SCROLL", "V_SCROLL", "BORDER", "LEFT_TO_RIGHT"}),
        WIDGET(Widget.class.getName(), new String[0]);

        private String[] styles;
        private String widgetType;

        private AllowedStyles(String widgetType, String[] styles) {
            this.widgetType = widgetType;
            this.styles = styles;
        }

        public String getWidgetType() {
            return this.widgetType;
        }

        public String[] getStyles() {
            return this.styles;
        }
    }
}

