/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.service;

import java.io.IOException;
import javax.servlet.ServletException;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.ServiceHandlerRegistry;
import org.eclipse.rwt.service.IServiceHandler;
import org.eclipse.rwt.service.IServiceManager;

public class ServiceManager
implements IServiceManager {
    private final ServiceHandlerRegistry customHandlers;
    private final IServiceHandler handlerDispatcher;
    private final IServiceHandler lifeCycleRequestHandler;

    public ServiceManager(IServiceHandler lifeCycleRequestHandler) {
        this.lifeCycleRequestHandler = lifeCycleRequestHandler;
        this.customHandlers = new ServiceHandlerRegistry();
        this.handlerDispatcher = new HandlerDispatcher();
    }

    public void registerServiceHandler(String id, IServiceHandler handler) {
        this.customHandlers.put(id, handler);
    }

    public void unregisterServiceHandler(String id) {
        this.customHandlers.remove(id);
    }

    public IServiceHandler getHandler() {
        return this.handlerDispatcher;
    }

    public void clear() {
        this.customHandlers.clear();
    }

    public IServiceHandler getCustomHandler(String customHandlerId) {
        return this.customHandlers.get(customHandlerId);
    }

    private static String getCustomHandlerId() {
        return ContextProvider.getRequest().getParameter("custom_service_handler");
    }

    private IServiceHandler getLifeCycleRequestHandler() {
        return this.lifeCycleRequestHandler;
    }

    private boolean isCustomHandler() {
        return this.customHandlers.isCustomHandler(ServiceManager.getCustomHandlerId());
    }

    private IServiceHandler getCustomHandler() {
        return this.getCustomHandler(ServiceManager.getCustomHandlerId());
    }

    private class HandlerDispatcher
    implements IServiceHandler {
        private HandlerDispatcher() {
        }

        public void service() throws ServletException, IOException {
            if (ServiceManager.this.isCustomHandler()) {
                IServiceHandler customHandler = ServiceManager.this.getCustomHandler();
                customHandler.service();
            } else {
                ServiceManager.this.getLifeCycleRequestHandler().service();
            }
        }
    }
}

