/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.service;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.branding.AbstractBranding;
import org.eclipse.rwt.internal.branding.BrandingUtil;
import org.eclipse.rwt.internal.lifecycle.JavaScriptResponseWriter;
import org.eclipse.rwt.internal.resources.ResourceRegistry;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.StartupPageConfigurer;
import org.eclipse.rwt.internal.service.StartupPageTemplateHolder;
import org.eclipse.rwt.internal.theme.QxImage;
import org.eclipse.rwt.internal.theme.QxType;
import org.eclipse.rwt.internal.theme.SimpleSelector;
import org.eclipse.rwt.internal.theme.ThemeUtil;
import org.eclipse.rwt.internal.util.EncodingUtil;
import org.eclipse.rwt.internal.util.URLHelper;

public final class StartupPage {
    private final IStartupPageConfigurer configurer;

    public StartupPage(ResourceRegistry resourceRegistry) {
        this.configurer = new StartupPageConfigurer(resourceRegistry);
    }

    public IStartupPageConfigurer getConfigurer() {
        return this.configurer;
    }

    void send() throws IOException {
        if (this.configurer.isModifiedSince()) {
            this.render();
        } else {
            AbstractBranding branding = BrandingUtil.determineBranding();
            if (branding.getThemeId() != null) {
                ThemeUtil.setCurrentThemeId(branding.getThemeId());
            }
        }
    }

    private void render() throws IOException {
        HttpServletResponse response = ContextProvider.getResponse();
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        StartupPageTemplateHolder template = this.configurer.getTemplate();
        template.replace(StartupPageTemplateHolder.VAR_BACKGROUND_IMAGE, StartupPage.getBgImage());
        template.replace(StartupPageTemplateHolder.VAR_SERVLET, URLHelper.getServletName());
        template.replace(StartupPageTemplateHolder.VAR_ENTRY_POINT, EncodingUtil.encodeHTMLEntities(StartupPage.getEntryPoint()));
        String[] tokens = template.getTokens();
        JavaScriptResponseWriter responseWriter = StartupPage.getResponseWriter();
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i] != null) {
                responseWriter.write(tokens[i]);
            }
            ++i;
        }
    }

    private static String getBgImage() {
        QxImage image;
        String resourceName;
        String result = "";
        QxType cssValue = ThemeUtil.getCssValue("Display", "background-image", SimpleSelector.DEFAULT);
        if (cssValue instanceof QxImage && (resourceName = (image = (QxImage)cssValue).getResourceName()) != null) {
            result = RWT.getResourceManager().getLocation(resourceName);
        }
        return result;
    }

    private static String getEntryPoint() {
        HttpServletRequest request = ContextProvider.getRequest();
        String result = request.getParameter("startup");
        if (result == null) {
            result = "default";
        }
        return result;
    }

    private static JavaScriptResponseWriter getResponseWriter() {
        return ContextProvider.getStateInfo().getResponseWriter();
    }

    public static interface IStartupPageConfigurer {
        public StartupPageTemplateHolder getTemplate() throws IOException;

        public boolean isModifiedSince();
    }
}

