/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.rwt.internal.theme.IThemeCssElement;
import org.eclipse.rwt.internal.theme.JsonArray;
import org.eclipse.rwt.internal.theme.JsonObject;
import org.eclipse.rwt.internal.theme.JsonValue;
import org.eclipse.rwt.internal.theme.QxType;
import org.eclipse.rwt.internal.theme.Theme;
import org.eclipse.rwt.internal.theme.ThemeCssValuesMap;
import org.eclipse.rwt.internal.theme.ThemePropertyAdapterRegistry;
import org.eclipse.rwt.internal.theme.css.ConditionalValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThemeStoreWriter {
    private final IThemeCssElement[] allThemeableWidgetElements;
    private final Collection<ThemeEntry> themes;

    public ThemeStoreWriter(IThemeCssElement[] elements) {
        this.allThemeableWidgetElements = elements;
        this.themes = new ArrayList<ThemeEntry>();
    }

    public void addTheme(Theme theme, boolean isDefault) {
        this.themes.add(new ThemeEntry(theme, isDefault));
    }

    public String createJs() {
        QxType[] allValues = this.getValuesFromAllThemes();
        Map valuesMap = ThemeStoreWriter.createValuesMap(allValues);
        StringBuffer jsCode = new StringBuffer();
        jsCode.append("( function( ts ) {\n");
        jsCode.append("ts.defineValues( ");
        jsCode.append(ThemeStoreWriter.createJsonFromValuesMap(valuesMap));
        jsCode.append(" );\n");
        for (ThemeEntry themeEntry : this.themes) {
            jsCode.append("ts.setThemeCssValues( ");
            jsCode.append(JsonValue.valueOf(themeEntry.theme.getJsId()));
            jsCode.append(", ");
            jsCode.append(this.createThemeJson(themeEntry.theme));
            jsCode.append(", ");
            jsCode.append(themeEntry.isDefault);
            jsCode.append(" );\n");
        }
        jsCode.append("} )( org.eclipse.swt.theme.ThemeStore.getInstance() );\n");
        return jsCode.toString();
    }

    private JsonObject createThemeJson(Theme theme) {
        JsonObject result = new JsonObject();
        ThemeCssValuesMap valuesMap = theme.getValuesMap();
        int i = 0;
        while (i < this.allThemeableWidgetElements.length) {
            IThemeCssElement element = this.allThemeableWidgetElements[i];
            String elementName = element.getName();
            JsonObject elementObj = this.createThemeJsonForElement(valuesMap, element);
            result.append(elementName, elementObj);
            ++i;
        }
        return result;
    }

    private JsonObject createThemeJsonForElement(ThemeCssValuesMap valuesMap, IThemeCssElement element) {
        JsonObject result = new JsonObject();
        String[] properties = element.getProperties();
        ThemePropertyAdapterRegistry registry = ThemePropertyAdapterRegistry.getInstance();
        int i = 0;
        while (i < properties.length) {
            String propertyName = properties[i];
            JsonArray valuesArray = new JsonArray();
            String elementName = element.getName();
            ConditionalValue[] values = valuesMap.getValues(elementName, propertyName);
            int j = 0;
            while (j < values.length) {
                ConditionalValue conditionalValue = values[j];
                JsonArray array = new JsonArray();
                array.append(JsonArray.valueOf(conditionalValue.constraints));
                QxType value = conditionalValue.value;
                ThemePropertyAdapterRegistry.ThemePropertyAdapter adapter = registry.getPropertyAdapter(value.getClass());
                String cssKey = adapter.getKey(value);
                array.append(cssKey);
                valuesArray.append(array);
                ++j;
            }
            result.append(propertyName, valuesArray);
            ++i;
        }
        return result;
    }

    private QxType[] getValuesFromAllThemes() {
        LinkedHashSet<QxType> valueSet = new LinkedHashSet<QxType>();
        for (ThemeEntry themeEntry : this.themes) {
            Theme theme = themeEntry.theme;
            ThemeCssValuesMap valuesMap = theme.getValuesMap();
            QxType[] values = valuesMap.getAllValues();
            int i = 0;
            while (i < values.length) {
                valueSet.add(values[i]);
                ++i;
            }
        }
        return valueSet.toArray(new QxType[valueSet.size()]);
    }

    private static Map createValuesMap(QxType[] values) {
        LinkedHashMap<String, JsonObject> result = new LinkedHashMap<String, JsonObject>();
        int i = 0;
        while (i < values.length) {
            ThemeStoreWriter.appendValueToMap(values[i], result);
            ++i;
        }
        return result;
    }

    private static void appendValueToMap(QxType propertyValue, Map<String, JsonObject> valuesMap) {
        String slot;
        ThemePropertyAdapterRegistry registry = ThemePropertyAdapterRegistry.getInstance();
        ThemePropertyAdapterRegistry.ThemePropertyAdapter adapter = registry.getPropertyAdapter(propertyValue.getClass());
        if (adapter != null && (slot = adapter.getSlot(propertyValue)) != null) {
            String key = adapter.getKey(propertyValue);
            JsonValue value = adapter.getValue(propertyValue);
            if (value != null) {
                JsonObject slotObject = ThemeStoreWriter.getSlot(valuesMap, slot);
                slotObject.append(key, value);
            }
        }
    }

    private static JsonValue createJsonFromValuesMap(Map valuesMap) {
        JsonObject result = new JsonObject();
        Set entrySet = valuesMap.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            JsonValue value = (JsonValue)entry.getValue();
            result.append(key, value);
        }
        return result;
    }

    private static JsonObject getSlot(Map<String, JsonObject> valuesMap, String name) {
        JsonObject result = valuesMap.get(name);
        if (result == null) {
            result = new JsonObject();
            valuesMap.put(name, result);
        }
        return result;
    }

    private static final class ThemeEntry {
        final Theme theme;
        final boolean isDefault;

        ThemeEntry(Theme theme, boolean isDefault) {
            this.theme = theme;
            this.isDefault = isDefault;
        }
    }
}

