/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme.css;

import org.eclipse.rwt.internal.theme.QxType;
import org.eclipse.rwt.internal.theme.StyleSheetBuilder;
import org.eclipse.rwt.internal.theme.css.CssFileReader;
import org.eclipse.rwt.internal.theme.css.PropertyResolver;
import org.eclipse.rwt.internal.theme.css.StylePropertyMap;
import org.eclipse.rwt.internal.theme.css.StyleRule;
import org.eclipse.rwt.internal.theme.css.StyleSheet;
import org.eclipse.rwt.resources.ResourceLoader;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;

public class DocumentHandlerImpl
implements DocumentHandler {
    private String uri;
    private final CssFileReader reader;
    private final ResourceLoader loader;
    private final StyleSheetBuilder styleSheetBuilder;
    private StylePropertyMap currentStyleProperties;

    public DocumentHandlerImpl(CssFileReader reader, ResourceLoader loader) {
        this.reader = reader;
        this.loader = loader;
        this.styleSheetBuilder = new StyleSheetBuilder();
    }

    public void startDocument(InputSource source) throws CSSException {
        this.uri = source.getURI();
        this.log("=== startDocument " + this.uri + "===");
    }

    public void endDocument(InputSource source) throws CSSException {
        this.log("___ endDocument ___");
    }

    public void startSelector(SelectorList selectors) throws CSSException {
        this.log("startSelector " + DocumentHandlerImpl.toString(selectors));
        this.currentStyleProperties = new StylePropertyMap();
    }

    public void endSelector(SelectorList selectors) throws CSSException {
        this.log("endSelector " + DocumentHandlerImpl.toString(selectors));
        StyleRule styleRule = new StyleRule(selectors, this.currentStyleProperties);
        this.styleSheetBuilder.addStyleRule(styleRule);
        this.currentStyleProperties = null;
    }

    public void property(String name, LexicalUnit value, boolean important) throws CSSException {
        this.log("  property " + name + " := " + PropertyResolver.toString(value) + (important ? " !" : ""));
        if (important) {
            this.reader.addProblem(new CSSException("Important rules not supported - ignored"));
        }
        if (this.currentStyleProperties != null) {
            try {
                QxType resolved = PropertyResolver.resolveProperty(name, value, this.loader);
                this.currentStyleProperties.setProperty(name, resolved);
            }
            catch (IllegalArgumentException e) {
                this.reader.addProblem(new CSSException("Failed to read property " + name + ": " + e.getMessage()));
            }
        }
    }

    public void comment(String text) throws CSSException {
        this.log("    /*" + text + "*/");
    }

    public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
        this.log("importStyle " + uri + ", " + media + ", " + defaultNamespaceURI);
        this.reader.addProblem(new CSSException("import rules not supported - ignored"));
    }

    public void namespaceDeclaration(String prefix, String uri) throws CSSException {
        this.log("namespaceDeclaration " + prefix + ", " + uri);
        this.reader.addProblem(new CSSException("unsupported namespace declaration '" + prefix + ":" + uri + "' - ignored"));
    }

    public void ignorableAtRule(String atRule) throws CSSException {
        this.log("ignorableAtRule " + atRule);
        this.reader.addProblem(new CSSException("unsupported at rule '" + atRule + "' - ignored"));
    }

    public void startPage(String name, String pseudo_page) throws CSSException {
        this.log("startPage " + name + ", " + pseudo_page);
        this.reader.addProblem(new CSSException("page rules not supported - ignored"));
    }

    public void endPage(String name, String pseudo_page) throws CSSException {
        this.log("endPage " + name + ", " + pseudo_page);
    }

    public void startMedia(SACMediaList media) throws CSSException {
        this.log("startMedia " + media);
        this.reader.addProblem(new CSSException("media rules not supported - ignored"));
    }

    public void endMedia(SACMediaList media) throws CSSException {
        this.log("endMedia " + media);
    }

    public void startFontFace() throws CSSException {
        this.log("startFontFace");
        this.reader.addProblem(new CSSException("font face rules not supported - ignored"));
    }

    public void endFontFace() throws CSSException {
        this.log("end FontFace");
    }

    public StyleSheet getStyleSheet() {
        return this.styleSheetBuilder.getStyleSheet();
    }

    private void log(String message) {
    }

    private static String toString(SelectorList patterns) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        int length = patterns.getLength();
        int i = 0;
        while (i < length) {
            buffer.append(" ");
            Selector selector = patterns.item(i);
            buffer.append(selector.toString());
            ++i;
        }
        buffer.append(" ]");
        return buffer.toString();
    }
}

