/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.widgets;

import java.text.MessageFormat;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.IBrowserHistory;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.events.BrowserHistoryEvent;
import org.eclipse.rwt.events.BrowserHistoryListener;
import org.eclipse.rwt.internal.application.RWTFactory;
import org.eclipse.rwt.internal.events.EventAdapter;
import org.eclipse.rwt.internal.events.IEventAdapter;
import org.eclipse.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.util.EncodingUtil;
import org.eclipse.rwt.internal.widgets.JSExecutor;
import org.eclipse.rwt.lifecycle.PhaseEvent;
import org.eclipse.rwt.lifecycle.PhaseId;
import org.eclipse.rwt.lifecycle.PhaseListener;
import org.eclipse.rwt.service.SessionStoreEvent;
import org.eclipse.rwt.service.SessionStoreListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BrowserHistory
implements IBrowserHistory,
PhaseListener,
Adaptable,
SessionStoreListener {
    private static final String EVENT_HISTORY_NAVIGATED = "org.eclipse.rwt.events.historyNavigated";
    private static final String EVENT_HISTORY_NAVIGATED_ENTRY_ID = "org.eclipse.rwt.events.historyNavigated.entryId";
    private static final String ADD_TO_HISTORY = "qx.client.History.getInstance().addToHistory( {0}, {1} );";
    private final Display display = Display.getCurrent();
    private IEventAdapter eventAdapter;

    public BrowserHistory() {
        RWTFactory.getLifeCycleFactory().getLifeCycle().addPhaseListener(this);
        RWT.getSessionStore().addSessionStoreListener(this);
    }

    @Override
    public void createEntry(String id, String text) {
        if (id == null) {
            SWT.error(4);
        }
        if (id.length() == 0) {
            SWT.error(5);
        }
        String quotedId = "\"" + EncodingUtil.escapeDoubleQuoted(id) + "\"";
        String quotedText = text;
        if (quotedText != null) {
            quotedText = "\"" + EncodingUtil.escapeDoubleQuoted(text) + "\"";
        }
        Object[] args = new String[]{quotedId, quotedText};
        JSExecutor.executeJS(MessageFormat.format(ADD_TO_HISTORY, args));
    }

    @Override
    public void addBrowserHistoryListener(BrowserHistoryListener listener) {
        if (listener == null) {
            SWT.error(4);
        }
        BrowserHistoryEvent.addListener(this, listener);
    }

    @Override
    public void removeBrowserHistoryListener(BrowserHistoryListener lsnr) {
        if (lsnr == null) {
            SWT.error(4);
        }
        BrowserHistoryEvent.removeListener(this, lsnr);
    }

    @Override
    public void afterPhase(PhaseEvent event) {
    }

    @Override
    public void beforePhase(PhaseEvent event) {
        HttpServletRequest request;
        String isEvent;
        if (this.display == LifeCycleUtil.getSessionDisplay() && Boolean.valueOf(isEvent = (request = ContextProvider.getRequest()).getParameter(EVENT_HISTORY_NAVIGATED)).booleanValue()) {
            String entryId = request.getParameter(EVENT_HISTORY_NAVIGATED_ENTRY_ID);
            BrowserHistoryEvent evt = new BrowserHistoryEvent((Object)this, entryId);
            evt.processEvent();
        }
    }

    @Override
    public PhaseId getPhaseId() {
        return PhaseId.PROCESS_ACTION;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        Object result;
        if (adapter == IEventAdapter.class) {
            if (this.eventAdapter == null) {
                this.eventAdapter = new EventAdapter();
            }
            result = this.eventAdapter;
        } else {
            result = RWTFactory.getAdapterManager().getAdapter(this, adapter);
        }
        return (T)result;
    }

    @Override
    public void beforeDestroy(SessionStoreEvent event) {
        RWTFactory.getLifeCycleFactory().getLifeCycle().removePhaseListener(this);
    }
}

