/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.lifecycle;

import java.io.IOException;
import java.lang.reflect.Field;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rwt.internal.protocol.IClientObject;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.events.ActivateEvent;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.graphics.ImageFactory;
import org.eclipse.swt.internal.widgets.ControlUtil;
import org.eclipse.swt.internal.widgets.IControlAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ControlLCAUtil {
    private static final String JS_FUNC_ADD_ACTIVATE_LISTENER_WIDGET = "addActivateListenerWidget";
    private static final String JS_FUNC_REMOVE_ACTIVATE_LISTENER_WIDGET = "removeActivateListenerWidget";
    private static final String JS_FUNC_SET_HAS_LISTENER = "setHasListener";
    private static final String JS_EVENT_TYPE_FOCUS = "focus";
    private static final String JS_EVENT_TYPE_MOUSE = "mouse";
    private static final String JS_EVENT_TYPE_MENU_DETECT = "menuDetect";
    private static final String PROP_ACTIVATE_LISTENER = "activateListener";
    private static final String PROP_FOCUS_LISTENER = "focusListener";
    private static final String PROP_MOUSE_LISTENER = "mouseListener";
    private static final String PROP_KEY_LISTENER = "keyListener";
    private static final String PROP_TRAVERSE_LISTENER = "traverseListener";
    private static final String PROP_MENU_DETECT_LISTENER = "menuDetectListener";
    private static final String PROP_TAB_INDEX = "tabIndex";
    private static final String PROP_CURSOR = "cursor";
    private static final String PROP_BACKGROUND_IMAGE = "backgroundImage";
    private static final String USER_DATA_KEY_LISTENER = "keyListener";
    private static final String USER_DATA_TRAVERSE_LISTENER = "traverseListener";
    private static final String USER_DATA_BACKGROUND_IMAGE_SIZE = "backgroundImageSize";
    private static final String ATT_CANCEL_KEY_EVENT = String.valueOf(ControlLCAUtil.class.getName()) + "#cancelKeyEvent";
    private static final String ATT_ALLOW_KEY_EVENT = String.valueOf(ControlLCAUtil.class.getName()) + "#allowKeyEvent";
    static final String JSFUNC_CANCEL_EVENT = "org.eclipse.rwt.KeyEventUtil.getInstance().cancelEvent";
    static final String JSFUNC_ALLOW_EVENT = "org.eclipse.rwt.KeyEventUtil.getInstance().allowEvent";
    static final int MAX_STATIC_ZORDER = 300;
    private static final String CURSOR_UPARROW = "widget/cursors/up_arrow.cur";

    private ControlLCAUtil() {
    }

    public static void preserveValues(Control control) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter(control);
        WidgetLCAUtil.preserveBounds(control, control.getBounds());
        if (!(control instanceof Shell)) {
            adapter.preserve("zindex", new Integer(ControlLCAUtil.getZIndex(control)));
        }
        adapter.preserve(PROP_TAB_INDEX, new Integer(ControlLCAUtil.getTabIndex(control)));
        WidgetLCAUtil.preserveToolTipText(control, control.getToolTipText());
        adapter.preserve("menu", control.getMenu());
        adapter.preserve("visible", ControlLCAUtil.getVisible(control));
        WidgetLCAUtil.preserveEnabled(control, control.getEnabled());
        IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
        WidgetLCAUtil.preserveForeground(control, controlAdapter.getUserForeground());
        WidgetLCAUtil.preserveBackground(control, controlAdapter.getUserBackground(), controlAdapter.getBackgroundTransparency());
        ControlLCAUtil.preserveBackgroundImage(control);
        WidgetLCAUtil.preserveFont(control, controlAdapter.getUserFont());
        adapter.preserve(PROP_CURSOR, control.getCursor());
        adapter.preserve("hasControlListeners", ControlEvent.hasListener(control));
        adapter.preserve(PROP_ACTIVATE_LISTENER, ActivateEvent.hasListener(control));
        adapter.preserve(PROP_MOUSE_LISTENER, MouseEvent.hasListener(control));
        if ((control.getStyle() & 0x80000) == 0) {
            adapter.preserve(PROP_FOCUS_LISTENER, FocusEvent.hasListener(control));
        }
        adapter.preserve("keyListener", KeyEvent.hasListener(control));
        adapter.preserve("traverseListener", TraverseEvent.hasListener(control));
        WidgetLCAUtil.preserveHelpListener(control);
        ControlLCAUtil.preserveMenuDetectListener(control);
    }

    public static void preserveBackgroundImage(Control control) {
        IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
        Image image = controlAdapter.getUserBackgroundImage();
        IWidgetAdapter adapter = WidgetUtil.getAdapter(control);
        adapter.preserve(PROP_BACKGROUND_IMAGE, image);
    }

    public static void preserveMenuDetectListener(Control control) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter(control);
        boolean hasListener = MenuDetectEvent.hasListener(control);
        adapter.preserve(PROP_MENU_DETECT_LISTENER, hasListener);
    }

    public static void readBounds(Control control) {
        Rectangle current = control.getBounds();
        Rectangle newBounds = WidgetLCAUtil.readBounds(control, current);
        control.setBounds(newBounds);
    }

    public static void processMouseEvents(Control control) {
        Point point;
        MouseEvent event;
        String eventId;
        if (WidgetLCAUtil.wasEventSent(control, "org.eclipse.swt.events.mouseDown")) {
            MouseEvent event2 = new MouseEvent(control, 3);
            event2.button = ControlLCAUtil.readIntParam("org.eclipse.swt.events.mouseDown.button");
            Point point2 = ControlLCAUtil.readXYParams(control, "org.eclipse.swt.events.mouseDown.x", "org.eclipse.swt.events.mouseDown.y");
            event2.x = point2.x;
            event2.y = point2.y;
            event2.time = ControlLCAUtil.readIntParam("org.eclipse.swt.events.mouseDown.time");
            event2.stateMask = EventLCAUtil.readStateMask("org.eclipse.swt.events.mouseDown.modifier") | EventLCAUtil.translateButton(event2.button);
            ControlLCAUtil.checkAndProcessMouseEvent(event2);
        }
        if (WidgetLCAUtil.wasEventSent(control, eventId = "org.eclipse.swt.events.mouseDoubleClick")) {
            event = new MouseEvent(control, 8);
            event.button = ControlLCAUtil.readIntParam("org.eclipse.swt.events.mouseDoubleClick.button");
            point = ControlLCAUtil.readXYParams(control, "org.eclipse.swt.events.mouseDoubleClick.x", "org.eclipse.swt.events.mouseDoubleClick.y");
            event.x = point.x;
            event.y = point.y;
            event.time = ControlLCAUtil.readIntParam("org.eclipse.swt.events.mouseDoubleClick.time");
            String stateMaskParam = "org.eclipse.swt.events.mouseDoubleClick.modifier";
            event.stateMask = EventLCAUtil.readStateMask(stateMaskParam) | EventLCAUtil.translateButton(event.button);
            ControlLCAUtil.checkAndProcessMouseEvent(event);
        }
        if (WidgetLCAUtil.wasEventSent(control, "org.eclipse.swt.events.mouseUp")) {
            event = new MouseEvent(control, 4);
            event.button = ControlLCAUtil.readIntParam("org.eclipse.swt.events.mouseUp.button");
            point = ControlLCAUtil.readXYParams(control, "org.eclipse.swt.events.mouseUp.x", "org.eclipse.swt.events.mouseUp.y");
            event.x = point.x;
            event.y = point.y;
            event.time = ControlLCAUtil.readIntParam("org.eclipse.swt.events.mouseUp.time");
            event.stateMask = EventLCAUtil.readStateMask("org.eclipse.swt.events.mouseUp.modifier") | EventLCAUtil.translateButton(event.button);
            ControlLCAUtil.checkAndProcessMouseEvent(event);
        }
    }

    public static void processKeyEvents(final Control control) {
        if (WidgetLCAUtil.wasEventSent(control, "org.eclipse.swt.events.keyDown")) {
            final int keyCode = ControlLCAUtil.readIntParam("org.eclipse.swt.events.keyDown.keyCode");
            final int charCode = ControlLCAUtil.readIntParam("org.eclipse.swt.events.keyDown.charCode");
            final int stateMask = EventLCAUtil.readStateMask("org.eclipse.swt.events.keyDown.modifier");
            final int traverseKey = ControlLCAUtil.getTraverseKey(keyCode, stateMask);
            ProcessActionRunner.add(new Runnable(){

                public void run() {
                    boolean allow = true;
                    if (traverseKey != 0) {
                        TraverseEvent traverseEvent = new TraverseEvent(control);
                        ControlLCAUtil.initializeKeyEvent(traverseEvent, keyCode, charCode, stateMask);
                        traverseEvent.detail = traverseKey;
                        traverseEvent.processEvent();
                        if (!traverseEvent.doit) {
                            allow = false;
                        }
                    }
                    KeyEvent pressedEvent = new KeyEvent(control, 1);
                    ControlLCAUtil.initializeKeyEvent(pressedEvent, keyCode, charCode, stateMask);
                    pressedEvent.processEvent();
                    if (pressedEvent.doit) {
                        KeyEvent releasedEvent = new KeyEvent(control, 2);
                        ControlLCAUtil.initializeKeyEvent(releasedEvent, keyCode, charCode, stateMask);
                        releasedEvent.processEvent();
                    } else {
                        allow = false;
                    }
                    if (allow) {
                        ControlLCAUtil.allowKeyEvent(control);
                    } else {
                        ControlLCAUtil.cancelKeyEvent(control);
                    }
                }
            });
        }
    }

    public static void processSelection(Widget widget, Item item, boolean readBounds) {
        SelectionEvent event;
        String eventId = "org.eclipse.swt.events.widgetSelected";
        if (WidgetLCAUtil.wasEventSent(widget, eventId)) {
            event = ControlLCAUtil.createSelectionEvent(widget, item, readBounds, 13);
            event.processEvent();
        }
        if (WidgetLCAUtil.wasEventSent(widget, eventId = "org.eclipse.swt.events.widgetDefaultSelected")) {
            int widgetDefaultSelected = 14;
            event = ControlLCAUtil.createSelectionEvent(widget, item, readBounds, widgetDefaultSelected);
            event.processEvent();
        }
    }

    public static void writeChanges(Control control) throws IOException {
        ControlLCAUtil.writeBounds(control);
        ControlLCAUtil.writeZIndex(control);
        ControlLCAUtil.writeTabIndex(control);
        ControlLCAUtil.writeToolTip(control);
        ControlLCAUtil.writeMenu(control);
        ControlLCAUtil.writeVisible(control);
        ControlLCAUtil.writeEnabled(control);
        ControlLCAUtil.writeForeground(control);
        ControlLCAUtil.writeBackground(control);
        ControlLCAUtil.writeBackgroundImage(control);
        ControlLCAUtil.writeFont(control);
        ControlLCAUtil.writeCursor(control);
        ControlLCAUtil.writeActivateListener(control);
        ControlLCAUtil.writeFocusListener(control);
        ControlLCAUtil.writeMouseListener(control);
        ControlLCAUtil.writeKeyListener(control);
        ControlLCAUtil.writeTraverseListener(control);
        ControlLCAUtil.writeKeyEventResponse(control);
        ControlLCAUtil.writeMenuDetectListener(control);
        WidgetLCAUtil.writeHelpListener(control);
    }

    public static void renderChanges(Control control) throws IOException {
        ControlLCAUtil.renderBounds(control);
        ControlLCAUtil.renderZIndex(control);
        ControlLCAUtil.renderTabIndex(control);
        ControlLCAUtil.renderToolTip(control);
        ControlLCAUtil.renderMenu(control);
        ControlLCAUtil.renderVisible(control);
        ControlLCAUtil.renderEnabled(control);
        ControlLCAUtil.renderForeground(control);
        ControlLCAUtil.renderBackground(control);
        ControlLCAUtil.renderBackgroundImage(control);
        ControlLCAUtil.renderFont(control);
        ControlLCAUtil.renderCursor(control);
        ControlLCAUtil.renderListenActivate(control);
        ControlLCAUtil.renderListenFocus(control);
        ControlLCAUtil.renderListenMouse(control);
        ControlLCAUtil.renderListenKey(control);
        ControlLCAUtil.renderListenTraverse(control);
        ControlLCAUtil.renderKeyEventResponse(control);
        ControlLCAUtil.renderListenMenuDetect(control);
        WidgetLCAUtil.renderListenHelp(control);
    }

    public static void writeBounds(Control control) throws IOException {
        Composite parent = control.getParent();
        WidgetLCAUtil.writeBounds(control, parent, control.getBounds());
    }

    public static void renderBounds(Control control) throws IOException {
        Composite parent = control.getParent();
        WidgetLCAUtil.renderBounds(control, parent, control.getBounds());
    }

    public static void writeZIndex(Control control) throws IOException {
        if (!(control instanceof Shell)) {
            JSWriter writer = JSWriter.getWriterFor(control);
            Integer newValue = new Integer(ControlLCAUtil.getZIndex(control));
            writer.set("zindex", "zIndex", newValue, null);
        }
    }

    public static void renderZIndex(Control control) throws IOException {
        Integer newValue;
        if (!(control instanceof Shell) && WidgetLCAUtil.hasChanged(control, "zindex", newValue = new Integer(ControlLCAUtil.getZIndex(control)))) {
            IClientObject clientObject = ClientObjectFactory.getForWidget(control);
            clientObject.setProperty("zIndex", newValue);
        }
    }

    private static void writeTabIndex(Control control) throws IOException {
        if (control instanceof Shell) {
            ControlLCAUtil.resetTabIndices((Shell)control);
            ControlLCAUtil.computeTabIndices((Shell)control, 1);
        }
        int tabIndex = ControlLCAUtil.getTabIndex(control);
        Integer newValue = new Integer(tabIndex);
        JSWriter writer = JSWriter.getWriterFor(control);
        writer.set(PROP_TAB_INDEX, PROP_TAB_INDEX, newValue);
    }

    public static void renderTabIndex(Control control) {
        Integer newValue;
        if (control instanceof Shell) {
            ControlLCAUtil.resetTabIndices((Shell)control);
            ControlLCAUtil.computeTabIndices((Shell)control, 1);
        }
        if (WidgetLCAUtil.hasChanged(control, PROP_TAB_INDEX, newValue = new Integer(ControlLCAUtil.getTabIndex(control)))) {
            IClientObject clientObject = ClientObjectFactory.getForWidget(control);
            clientObject.setProperty(PROP_TAB_INDEX, newValue);
        }
    }

    public static void writeToolTip(Control control) throws IOException {
        WidgetLCAUtil.writeToolTip(control, control.getToolTipText());
    }

    public static void renderToolTip(Control control) throws IOException {
        WidgetLCAUtil.renderToolTip(control, control.getToolTipText());
    }

    public static void writeMenu(Control control) throws IOException {
        if (!(control instanceof Shell)) {
            WidgetLCAUtil.writeMenu(control, control.getMenu());
        }
    }

    public static void renderMenu(Control control) throws IOException {
        WidgetLCAUtil.renderMenu(control, control.getMenu());
    }

    public static void writeVisible(Control control) throws IOException {
        Boolean newValue = ControlLCAUtil.getVisible(control);
        Boolean defValue = Boolean.TRUE;
        JSWriter writer = JSWriter.getWriterFor(control);
        writer.set("visible", "visibility", newValue, defValue);
    }

    public static void renderVisible(Control control) throws IOException {
        Boolean defValue;
        Boolean newValue = ControlLCAUtil.getVisible(control);
        if (WidgetLCAUtil.hasChanged(control, "visible", newValue, defValue = Boolean.TRUE)) {
            IClientObject clientObject = ClientObjectFactory.getForWidget(control);
            clientObject.setProperty("visibility", newValue);
        }
    }

    public static void writeEnabled(Control control) throws IOException {
        WidgetLCAUtil.writeEnabled(control, control.getEnabled());
    }

    public static void renderEnabled(Control control) throws IOException {
        WidgetLCAUtil.renderEnabled(control, control.getEnabled());
    }

    public static void writeForeground(Control control) throws IOException {
        IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
        WidgetLCAUtil.writeForeground(control, controlAdapter.getUserForeground());
    }

    public static void renderForeground(Control control) throws IOException {
        IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
        WidgetLCAUtil.renderForeground(control, controlAdapter.getUserForeground());
    }

    public static void writeBackground(Control control) throws IOException {
        IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
        WidgetLCAUtil.writeBackground(control, controlAdapter.getUserBackground(), controlAdapter.getBackgroundTransparency());
    }

    public static void renderBackground(Control control) throws IOException {
        IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
        WidgetLCAUtil.renderBackground(control, controlAdapter.getUserBackground(), controlAdapter.getBackgroundTransparency());
    }

    public static void writeBackgroundImage(Control control) throws IOException {
        IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
        Image image = controlAdapter.getUserBackgroundImage();
        if (WidgetLCAUtil.hasChanged(control, PROP_BACKGROUND_IMAGE, image, null)) {
            JSWriter writer = JSWriter.getWriterFor(control);
            if (image != null) {
                String imagePath = ImageFactory.getImagePath(image);
                Rectangle bounds = image.getBounds();
                Object[] args = new Object[]{USER_DATA_BACKGROUND_IMAGE_SIZE, new Integer[]{new Integer(bounds.width), new Integer(bounds.height)}};
                writer.call("setUserData", args);
                writer.set(PROP_BACKGROUND_IMAGE, imagePath);
            } else {
                Object[] objectArray = new Object[2];
                objectArray[0] = USER_DATA_BACKGROUND_IMAGE_SIZE;
                Object[] args = objectArray;
                writer.call("setUserData", args);
                writer.reset(PROP_BACKGROUND_IMAGE);
            }
        }
    }

    public static void renderBackgroundImage(Control control) throws IOException {
        IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
        Image image = controlAdapter.getUserBackgroundImage();
        if (WidgetLCAUtil.hasChanged(control, PROP_BACKGROUND_IMAGE, image, null)) {
            Object[] imageArray = null;
            if (image != null) {
                imageArray = new Object[]{ImageFactory.getImagePath(image), new Integer(image.getBounds().width), new Integer(image.getBounds().height)};
            }
            IClientObject clientObject = ClientObjectFactory.getForWidget(control);
            clientObject.setProperty(PROP_BACKGROUND_IMAGE, imageArray);
        }
    }

    public static void writeFont(Control control) throws IOException {
        IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
        Font newValue = controlAdapter.getUserFont();
        WidgetLCAUtil.writeFont(control, newValue);
    }

    public static void renderFont(Control control) throws IOException {
        IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
        Font newValue = controlAdapter.getUserFont();
        WidgetLCAUtil.renderFont(control, newValue);
    }

    static void writeCursor(Control control) throws IOException {
        Cursor newValue = control.getCursor();
        if (WidgetLCAUtil.hasChanged(control, PROP_CURSOR, newValue, null)) {
            String qxCursor = ControlLCAUtil.getQxCursor(newValue);
            JSWriter writer = JSWriter.getWriterFor(control);
            if (qxCursor == null) {
                writer.reset(PROP_CURSOR);
            } else {
                writer.set(PROP_CURSOR, qxCursor);
            }
        }
    }

    static void renderCursor(Control control) {
        Cursor newValue = control.getCursor();
        if (WidgetLCAUtil.hasChanged(control, PROP_CURSOR, newValue, null)) {
            IClientObject clientObject = ClientObjectFactory.getForWidget(control);
            clientObject.setProperty(PROP_CURSOR, ControlLCAUtil.getQxCursor(newValue));
        }
    }

    public static void writeActivateListener(Control control) throws IOException {
        if (!control.isDisposed()) {
            Boolean newValue = ActivateEvent.hasListener(control);
            Boolean defValue = Boolean.FALSE;
            String prop = PROP_ACTIVATE_LISTENER;
            Shell shell = control.getShell();
            if (!shell.isDisposed() && WidgetLCAUtil.hasChanged(control, prop, newValue, defValue)) {
                String function = newValue != false ? JS_FUNC_ADD_ACTIVATE_LISTENER_WIDGET : JS_FUNC_REMOVE_ACTIVATE_LISTENER_WIDGET;
                JSWriter writer = JSWriter.getWriterFor(control);
                writer.call(shell, function, new Object[]{control});
            }
        }
    }

    public static void renderListenActivate(Control control) {
        Boolean defValue;
        Boolean newValue;
        if (!control.isDisposed() && WidgetLCAUtil.hasChanged(control, PROP_ACTIVATE_LISTENER, newValue = Boolean.valueOf(ActivateEvent.hasListener(control)), defValue = Boolean.FALSE)) {
            IClientObject clientObject = ClientObjectFactory.getForWidget(control);
            if (newValue.booleanValue()) {
                clientObject.addListener("activate");
            } else {
                clientObject.removeListener("activate");
            }
        }
    }

    static void resetActivateListener(Control control) throws IOException {
        IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
        Shell shell = controlAdapter.getShell();
        if (!shell.isDisposed() && ActivateEvent.hasListener(control)) {
            JSWriter writer = JSWriter.getWriterFor(control);
            writer.call(shell, JS_FUNC_REMOVE_ACTIVATE_LISTENER_WIDGET, new Object[]{control});
        }
    }

    private static void writeFocusListener(Control control) throws IOException {
        Boolean hasListener;
        if ((control.getStyle() & 0x80000) == 0 && WidgetLCAUtil.hasChanged(control, PROP_FOCUS_LISTENER, hasListener = Boolean.valueOf(FocusEvent.hasListener(control)), Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor(control);
            Object[] args = new Object[]{control, JS_EVENT_TYPE_FOCUS, hasListener};
            writer.call(JSWriter.WIDGET_MANAGER_REF, JS_FUNC_SET_HAS_LISTENER, args);
        }
    }

    static void renderListenFocus(Control control) {
        Boolean hasListener;
        if ((control.getStyle() & 0x80000) == 0 && WidgetLCAUtil.hasChanged(control, PROP_FOCUS_LISTENER, hasListener = Boolean.valueOf(FocusEvent.hasListener(control)), Boolean.FALSE)) {
            IClientObject clientObject = ClientObjectFactory.getForWidget(control);
            if (hasListener.booleanValue()) {
                clientObject.addListener(JS_EVENT_TYPE_FOCUS);
            } else {
                clientObject.removeListener(JS_EVENT_TYPE_FOCUS);
            }
        }
    }

    private static void writeMouseListener(Control control) throws IOException {
        Boolean hasListener = MouseEvent.hasListener(control);
        if (WidgetLCAUtil.hasChanged(control, PROP_MOUSE_LISTENER, hasListener, Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor(control);
            Object[] args = new Object[]{control, JS_EVENT_TYPE_MOUSE, hasListener};
            writer.call(JSWriter.WIDGET_MANAGER_REF, JS_FUNC_SET_HAS_LISTENER, args);
        }
    }

    static void renderListenMouse(Control control) {
        Boolean hasListener = MouseEvent.hasListener(control);
        if (WidgetLCAUtil.hasChanged(control, PROP_MOUSE_LISTENER, hasListener, Boolean.FALSE)) {
            IClientObject clientObject = ClientObjectFactory.getForWidget(control);
            if (hasListener.booleanValue()) {
                clientObject.addListener(JS_EVENT_TYPE_MOUSE);
            } else {
                clientObject.removeListener(JS_EVENT_TYPE_MOUSE);
            }
        }
    }

    static void writeKeyListener(Control control) throws IOException {
        Boolean defValue;
        String prop = "keyListener";
        Boolean hasListener = KeyEvent.hasListener(control);
        if (WidgetLCAUtil.hasChanged(control, prop, hasListener, defValue = Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor(control);
            if (hasListener.booleanValue()) {
                Object[] args = new Object[]{"keyListener", hasListener};
                writer.call("setUserData", args);
            } else {
                Object[] objectArray = new Object[2];
                objectArray[0] = "keyListener";
                Object[] args = objectArray;
                writer.call("setUserData", args);
            }
        }
    }

    static void renderListenKey(Control control) {
        Boolean hasListener = KeyEvent.hasListener(control);
        if (WidgetLCAUtil.hasChanged(control, "keyListener", hasListener, Boolean.FALSE)) {
            IClientObject clientObject = ClientObjectFactory.getForWidget(control);
            if (hasListener.booleanValue()) {
                clientObject.addListener("key");
            } else {
                clientObject.removeListener("key");
            }
        }
    }

    static void writeTraverseListener(Control control) throws IOException {
        Boolean defValue;
        String prop = "traverseListener";
        Boolean hasListener = TraverseEvent.hasListener(control);
        if (WidgetLCAUtil.hasChanged(control, prop, hasListener, defValue = Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor(control);
            if (hasListener.booleanValue()) {
                Object[] args = new Object[]{"traverseListener", hasListener};
                writer.call("setUserData", args);
            } else {
                Object[] objectArray = new Object[2];
                objectArray[0] = "traverseListener";
                Object[] args = objectArray;
                writer.call("setUserData", args);
            }
        }
    }

    static void renderListenTraverse(Control control) {
        Boolean defValue;
        String prop = "traverseListener";
        Boolean hasListener = TraverseEvent.hasListener(control);
        if (WidgetLCAUtil.hasChanged(control, prop, hasListener, defValue = Boolean.FALSE)) {
            IClientObject clientObject = ClientObjectFactory.getForWidget(control);
            if (hasListener.booleanValue()) {
                clientObject.addListener("traverse");
            } else {
                clientObject.removeListener("traverse");
            }
        }
    }

    public static void writeMenuDetectListener(Control control) throws IOException {
        Boolean hasLsnr = MenuDetectEvent.hasListener(control);
        if (WidgetLCAUtil.hasChanged(control, PROP_MENU_DETECT_LISTENER, hasLsnr, Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor(control);
            Object[] args = new Object[]{control, JS_EVENT_TYPE_MENU_DETECT, hasLsnr};
            writer.call(JSWriter.WIDGET_MANAGER_REF, JS_FUNC_SET_HAS_LISTENER, args);
        }
    }

    public static void renderListenMenuDetect(Control control) {
        Boolean hasLsnr = MenuDetectEvent.hasListener(control);
        if (WidgetLCAUtil.hasChanged(control, PROP_MENU_DETECT_LISTENER, hasLsnr, Boolean.FALSE)) {
            IClientObject clientObject = ClientObjectFactory.getForWidget(control);
            if (hasLsnr.booleanValue()) {
                clientObject.addListener(JS_EVENT_TYPE_MENU_DETECT);
            } else {
                clientObject.removeListener(JS_EVENT_TYPE_MENU_DETECT);
            }
        }
    }

    static void writeKeyEventResponse(Control control) throws IOException {
        IServiceStateInfo serviceStore = ContextProvider.getStateInfo();
        if (serviceStore.getAttribute(ATT_ALLOW_KEY_EVENT) == control) {
            JSWriter writer = JSWriter.getWriterFor(control);
            writer.callStatic(JSFUNC_ALLOW_EVENT, null);
        } else if (serviceStore.getAttribute(ATT_CANCEL_KEY_EVENT) == control) {
            JSWriter writer = JSWriter.getWriterFor(control);
            writer.callStatic(JSFUNC_CANCEL_EVENT, null);
        }
    }

    static void renderKeyEventResponse(Control control) {
        IServiceStateInfo serviceStore = ContextProvider.getStateInfo();
        if (serviceStore.getAttribute(ATT_ALLOW_KEY_EVENT) == control) {
            IClientObject clientObject = ClientObjectFactory.getForDisplay(control.getDisplay());
            clientObject.call("allowEvent", null);
        } else if (serviceStore.getAttribute(ATT_CANCEL_KEY_EVENT) == control) {
            IClientObject clientObject = ClientObjectFactory.getForDisplay(control.getDisplay());
            clientObject.call("cancelEvent", null);
        }
    }

    public static void writeStyleFlags(Control control) throws IOException {
        WidgetLCAUtil.writeStyleFlag(control, 2048, "BORDER");
    }

    private static SelectionEvent createSelectionEvent(Widget widget, Item item, boolean readBounds, int type) {
        Rectangle bounds;
        if (widget instanceof Control && readBounds) {
            Control control = (Control)widget;
            bounds = WidgetLCAUtil.readBounds(control, control.getBounds());
        } else {
            bounds = new Rectangle(0, 0, 0, 0);
        }
        int stateMask = EventLCAUtil.readStateMask("org.eclipse.swt.events.widgetSelected.modifier");
        return new SelectionEvent(widget, item, type, bounds, stateMask, null, true, 0);
    }

    private static void initializeKeyEvent(KeyEvent evt, int keyCode, int charCode, int stateMask) {
        if (charCode == 0) {
            evt.keyCode = ControlLCAUtil.translateKeyCode(keyCode);
            if ((evt.keyCode & 0x1000000) == 0) {
                evt.character = ControlLCAUtil.translateCharacter(evt.keyCode);
            }
        } else {
            evt.keyCode = charCode;
            evt.character = ControlLCAUtil.translateCharacter(charCode);
        }
        evt.stateMask = stateMask;
    }

    static void cancelKeyEvent(Widget widget) {
        ContextProvider.getStateInfo().setAttribute(ATT_CANCEL_KEY_EVENT, widget);
    }

    static void allowKeyEvent(Widget widget) {
        ContextProvider.getStateInfo().setAttribute(ATT_ALLOW_KEY_EVENT, widget);
    }

    public static void processMenuDetect(Control control) {
        if (WidgetLCAUtil.wasEventSent(control, "org.eclipse.swt.events.menuDetect")) {
            MenuDetectEvent event = new MenuDetectEvent(control);
            Point point = ControlLCAUtil.readXYParams(control, "org.eclipse.swt.events.menuDetect.x", "org.eclipse.swt.events.menuDetect.y");
            point = control.getDisplay().map(control, null, point);
            event.x = point.x;
            event.y = point.y;
            event.processEvent();
        }
    }

    private static void checkAndProcessMouseEvent(MouseEvent event) {
        boolean pass = false;
        Control control = (Control)event.widget;
        if (control instanceof Scrollable) {
            Scrollable scrollable = (Scrollable)control;
            Rectangle clientArea = scrollable.getClientArea();
            pass = clientArea.contains(event.x, event.y);
        } else {
            boolean bl = pass = event.x >= 0 && event.y >= 0;
        }
        if (pass) {
            event.processEvent();
        }
    }

    private static Point readXYParams(Control control, String paramNameX, String paramNameY) {
        int x = ControlLCAUtil.readIntParam(paramNameX);
        int y = ControlLCAUtil.readIntParam(paramNameY);
        return control.getDisplay().map(null, control, x, y);
    }

    private static int readIntParam(String paramName) {
        String value = ControlLCAUtil.readStringParam(paramName);
        return NumberFormatUtil.parseInt(value);
    }

    private static String readStringParam(String paramName) {
        HttpServletRequest request = ContextProvider.getRequest();
        String value = request.getParameter(paramName);
        return value;
    }

    public static int getZIndex(Control control) {
        int max = 300;
        if (control.getParent() != null) {
            max = Math.max(control.getParent().getChildren().length, max);
        }
        IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
        return max - controlAdapter.getZIndex();
    }

    private static boolean getVisible(Control control) {
        Point size = control.getSize();
        return control.getVisible() && size.x > 0 && size.y > 0;
    }

    private static boolean takesFocus(Control control) {
        boolean result = true;
        result &= (control.getStyle() & 0x80000) == 0;
        result &= control.getClass() != Composite.class;
        return result &= control.getClass() != SashForm.class;
    }

    private static int getTabIndex(Control control) {
        int result = -1;
        if (ControlLCAUtil.takesFocus(control)) {
            result = ControlUtil.getControlAdapter(control).getTabIndex();
        }
        return result;
    }

    private static void resetTabIndices(Composite composite) {
        Control[] children = composite.getChildren();
        int i = 0;
        while (i < children.length) {
            Control control = children[i];
            ControlUtil.getControlAdapter(control).setTabIndex(-1);
            if (control instanceof Composite) {
                ControlLCAUtil.resetTabIndices((Composite)control);
            }
            ++i;
        }
    }

    private static int computeTabIndices(Composite composite, int startIndex) {
        Control[] tabList = composite.getTabList();
        int result = startIndex;
        int i = 0;
        while (i < tabList.length) {
            Control control = tabList[i];
            IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
            controlAdapter.setTabIndex(result);
            result = control instanceof Link ? (result += 300) : ++result;
            if (control instanceof Composite) {
                result = ControlLCAUtil.computeTabIndices((Composite)control, result);
            }
            ++i;
        }
        return result;
    }

    static int getTraverseKey(int keyCode, int stateMask) {
        int result = 0;
        switch (keyCode) {
            case 27: {
                result = 2;
                break;
            }
            case 13: {
                result = 4;
                break;
            }
            case 9: {
                if ((stateMask & SWT.MODIFIER_MASK) == 0) {
                    result = 16;
                    break;
                }
                if (stateMask != 131072) break;
                result = 8;
            }
        }
        return result;
    }

    static int translateKeyCode(int keyCode) {
        int result;
        switch (keyCode) {
            case 20: {
                result = 16777298;
                break;
            }
            case 38: {
                result = 0x1000001;
                break;
            }
            case 37: {
                result = 0x1000003;
                break;
            }
            case 39: {
                result = 0x1000004;
                break;
            }
            case 40: {
                result = 0x1000002;
                break;
            }
            case 33: {
                result = 0x1000005;
                break;
            }
            case 34: {
                result = 0x1000006;
                break;
            }
            case 35: {
                result = 0x1000008;
                break;
            }
            case 36: {
                result = 0x1000007;
                break;
            }
            case 45: {
                result = 0x1000009;
                break;
            }
            case 46: {
                result = 127;
                break;
            }
            case 112: {
                result = 0x100000A;
                break;
            }
            case 113: {
                result = 0x100000B;
                break;
            }
            case 114: {
                result = 0x100000C;
                break;
            }
            case 115: {
                result = 0x100000D;
                break;
            }
            case 116: {
                result = 0x100000E;
                break;
            }
            case 117: {
                result = 0x100000F;
                break;
            }
            case 118: {
                result = 0x1000010;
                break;
            }
            case 119: {
                result = 0x1000011;
                break;
            }
            case 120: {
                result = 0x1000012;
                break;
            }
            case 121: {
                result = 0x1000013;
                break;
            }
            case 122: {
                result = 0x1000014;
                break;
            }
            case 123: {
                result = 0x1000015;
                break;
            }
            case 144: {
                result = 16777299;
                break;
            }
            case 44: {
                result = 16777303;
                break;
            }
            case 145: {
                result = 16777300;
                break;
            }
            case 19: {
                result = 0x1000055;
                break;
            }
            default: {
                result = keyCode;
            }
        }
        return result;
    }

    private static char translateCharacter(int keyCode) {
        char result = '\u0000';
        if (Character.isDefined((char)keyCode)) {
            result = (char)keyCode;
        }
        return result;
    }

    private static String getQxCursor(Cursor newValue) {
        String result = null;
        if (newValue != null) {
            int value = 0;
            try {
                Class<Cursor> cursorClass = Cursor.class;
                Field field = cursorClass.getDeclaredField("value");
                field.setAccessible(true);
                value = field.getInt(newValue);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            switch (value) {
                case 0: {
                    result = "default";
                    break;
                }
                case 1: {
                    result = "wait";
                    break;
                }
                case 3: {
                    result = "progress";
                    break;
                }
                case 2: {
                    result = "crosshair";
                    break;
                }
                case 4: {
                    result = "help";
                    break;
                }
                case 5: {
                    result = "move";
                    break;
                }
                case 7: {
                    result = "row-resize";
                    break;
                }
                case 9: {
                    result = "col-resize";
                    break;
                }
                case 10: {
                    result = "n-resize";
                    break;
                }
                case 11: {
                    result = "s-resize";
                    break;
                }
                case 12: {
                    result = "e-resize";
                    break;
                }
                case 13: {
                    result = "w-resize";
                    break;
                }
                case 6: 
                case 14: {
                    result = "ne-resize";
                    break;
                }
                case 15: {
                    result = "se-resize";
                    break;
                }
                case 16: {
                    result = "sw-resize";
                    break;
                }
                case 8: 
                case 17: {
                    result = "nw-resize";
                    break;
                }
                case 19: {
                    result = "text";
                    break;
                }
                case 21: {
                    result = "pointer";
                    break;
                }
                case 20: {
                    result = "not-allowed";
                    break;
                }
                case 18: {
                    result = CURSOR_UPARROW;
                }
            }
        }
        return result;
    }
}

