/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import java.util.Map;
import org.eclipse.rwt.internal.util.EncodingUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.ImageFactory;
import org.eclipse.swt.internal.widgets.IRichTextParserCallback;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RichTextToHtmlTransformer
implements IRichTextParserCallback {
    private final StringBuilder buffer = new StringBuilder();
    private final Map<String, Image> imageMap;

    public RichTextToHtmlTransformer(TableItem tableItem) {
        this.imageMap = RichTextToHtmlTransformer.getImageMap(tableItem);
    }

    @Override
    public void beginHtml() {
        this.buffer.setLength(0);
        this.buffer.append("<div");
        this.appendAttribute("style", "line-height:normal;");
        this.buffer.append(">");
    }

    @Override
    public void endHtml() {
        this.buffer.append("</div>");
    }

    @Override
    public void beginFont(String name, int height) {
        this.buffer.append("<span");
        String encodeName = EncodingUtil.encodeHTMLEntities(name);
        String fontStyle = "font-family:" + encodeName + ";font-size:" + height + "px";
        this.appendAttribute("style", fontStyle);
        this.buffer.append(">");
    }

    @Override
    public void endFont() {
        this.buffer.append("</span>");
    }

    @Override
    public void image(String src) {
        Image image = this.imageMap.get(src);
        Rectangle imageBounds = image.getBounds();
        this.buffer.append("<img");
        this.appendAttribute("src", ImageFactory.getImagePath(image));
        this.appendAttribute("width", String.valueOf(imageBounds.width) + "px");
        this.appendAttribute("height", String.valueOf(image.getBounds().height) + "px");
        this.buffer.append(" />");
    }

    @Override
    public void lineBreak() {
        this.buffer.append("<br />");
    }

    @Override
    public void text(String text) {
        this.buffer.append(text);
    }

    public String getHtml() {
        return this.buffer.toString();
    }

    private void appendAttribute(String name, String value) {
        this.buffer.append(" ");
        this.buffer.append(name);
        this.buffer.append("=\"");
        this.buffer.append(value);
        this.buffer.append("\"");
    }

    private static Map<String, Image> getImageMap(TableItem tableItem) {
        return (Map)tableItem.getParent().getData(Table.IMAGE_MAP);
    }
}

