/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.datetimekit;

import java.io.IOException;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSVar;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.IDateTimeAdapter;
import org.eclipse.swt.widgets.DateTime;

final class DateTimeLCAUtil {
    private DateTimeLCAUtil() {
    }

    static IDateTimeAdapter getDateTimeAdapter(DateTime dateTime) {
        return dateTime.getAdapter(IDateTimeAdapter.class);
    }

    static void preserveSubWidgetBounds(DateTime dateTime, int subWidgetID) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter(dateTime);
        IDateTimeAdapter dateTimeAdapter = DateTimeLCAUtil.getDateTimeAdapter(dateTime);
        Rectangle subWidgetBounds = dateTimeAdapter.getBounds(subWidgetID);
        adapter.preserve(String.valueOf(subWidgetID) + "_BOUNDS", subWidgetBounds);
    }

    static void writeSubWidgetBounds(DateTime dateTime, int subWidgetID) throws IOException {
        IDateTimeAdapter dateTimeAdapter = DateTimeLCAUtil.getDateTimeAdapter(dateTime);
        Rectangle newValue = dateTimeAdapter.getBounds(subWidgetID);
        if (WidgetLCAUtil.hasChanged(dateTime, String.valueOf(subWidgetID) + "_BOUNDS", newValue)) {
            JSWriter writer = JSWriter.getWriterFor(dateTime);
            writer.call("setBounds", new Object[]{new Integer(subWidgetID), new Integer(newValue.x), new Integer(newValue.y), new Integer(newValue.width), new Integer(newValue.height)});
        }
    }

    static void writeListener(DateTime dateTime) throws IOException {
        String prop = "selectionListeners";
        boolean hasListener = SelectionEvent.hasListener(dateTime);
        Boolean newValue = hasListener;
        if (WidgetLCAUtil.hasChanged(dateTime, prop, newValue, Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor(dateTime);
            writer.set("hasSelectionListener", newValue);
        }
    }

    static void initCellSize(DateTime dateTime) {
        IDateTimeAdapter dateTimeAdapter = DateTimeLCAUtil.getDateTimeAdapter(dateTime);
        JSWriter writer = JSWriter.getWriterFor(dateTime);
        Point cellSize = dateTimeAdapter.getCellSize();
        writer.callFieldAssignment(new JSVar("org.eclipse.swt.widgets.Calendar"), "CELL_WIDTH", String.valueOf(cellSize.x));
        writer.callFieldAssignment(new JSVar("org.eclipse.swt.widgets.Calendar"), "CELL_HEIGHT", String.valueOf(cellSize.y));
    }
}

