/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.datetimekit;

import java.io.IOException;
import org.eclipse.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.internal.widgets.datetimekit.AbstractDateTimeLCADelegate;
import org.eclipse.swt.internal.widgets.datetimekit.DateTimeLCAUtil;
import org.eclipse.swt.widgets.DateTime;

final class DateTimeTimeLCA
extends AbstractDateTimeLCADelegate {
    static final String PROP_HOURS = "hours";
    static final String PROP_MINUTES = "minutes";
    static final String PROP_SECONDS = "seconds";

    DateTimeTimeLCA() {
    }

    void preserveValues(DateTime dateTime) {
        ControlLCAUtil.preserveValues(dateTime);
        IWidgetAdapter adapter = WidgetUtil.getAdapter(dateTime);
        boolean hasListeners = SelectionEvent.hasListener(dateTime);
        adapter.preserve("selectionListeners", hasListeners);
        adapter.preserve(PROP_HOURS, new Integer(dateTime.getHours()));
        adapter.preserve(PROP_MINUTES, new Integer(dateTime.getMinutes()));
        adapter.preserve(PROP_SECONDS, new Integer(dateTime.getSeconds()));
        this.preserveSubWidgetsBounds(dateTime);
        WidgetLCAUtil.preserveCustomVariant(dateTime);
    }

    void readData(DateTime dateTime) {
        String value = WidgetLCAUtil.readPropertyValue(dateTime, PROP_HOURS);
        if (value != null) {
            dateTime.setHours(NumberFormatUtil.parseInt(value));
        }
        if ((value = WidgetLCAUtil.readPropertyValue(dateTime, PROP_MINUTES)) != null) {
            dateTime.setMinutes(NumberFormatUtil.parseInt(value));
        }
        if ((value = WidgetLCAUtil.readPropertyValue(dateTime, PROP_SECONDS)) != null) {
            dateTime.setSeconds(NumberFormatUtil.parseInt(value));
        }
        ControlLCAUtil.processSelection(dateTime, null, true);
        ControlLCAUtil.processMouseEvents(dateTime);
        ControlLCAUtil.processKeyEvents(dateTime);
        ControlLCAUtil.processMenuDetect(dateTime);
        WidgetLCAUtil.processHelp(dateTime);
    }

    void renderInitialization(DateTime dateTime) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(dateTime);
        String style = "";
        if ((dateTime.getStyle() & 0x8000) != 0) {
            style = "short";
        } else if ((dateTime.getStyle() & 0x10000) != 0) {
            style = "medium";
        } else if ((dateTime.getStyle() & 0x10000000) != 0) {
            style = "long";
        }
        Object[] args = new Object[]{style};
        writer.newWidget("org.eclipse.swt.widgets.DateTimeTime", args);
        ControlLCAUtil.writeStyleFlags(dateTime);
    }

    void renderChanges(DateTime dateTime) throws IOException {
        ControlLCAUtil.writeChanges(dateTime);
        this.writeHours(dateTime);
        this.writeMinutes(dateTime);
        this.writeSeconds(dateTime);
        DateTimeLCAUtil.writeListener(dateTime);
        this.writeSubWidgetsBounds(dateTime);
        WidgetLCAUtil.writeCustomVariant(dateTime);
    }

    private void writeHours(DateTime dateTime) throws IOException {
        Integer newValue = new Integer(dateTime.getHours());
        if (WidgetLCAUtil.hasChanged(dateTime, PROP_HOURS, newValue)) {
            JSWriter writer = JSWriter.getWriterFor(dateTime);
            writer.set(PROP_HOURS, newValue);
        }
    }

    private void writeMinutes(DateTime dateTime) throws IOException {
        Integer newValue = new Integer(dateTime.getMinutes());
        if (WidgetLCAUtil.hasChanged(dateTime, PROP_MINUTES, newValue)) {
            JSWriter writer = JSWriter.getWriterFor(dateTime);
            writer.set(PROP_MINUTES, newValue);
        }
    }

    private void writeSeconds(DateTime dateTime) throws IOException {
        Integer newValue = new Integer(dateTime.getSeconds());
        if (WidgetLCAUtil.hasChanged(dateTime, PROP_SECONDS, newValue)) {
            JSWriter writer = JSWriter.getWriterFor(dateTime);
            writer.set(PROP_SECONDS, newValue);
        }
    }

    private void writeSubWidgetsBounds(DateTime dateTime) throws IOException {
        DateTimeLCAUtil.writeSubWidgetBounds(dateTime, 8);
        DateTimeLCAUtil.writeSubWidgetBounds(dateTime, 11);
        DateTimeLCAUtil.writeSubWidgetBounds(dateTime, 9);
        DateTimeLCAUtil.writeSubWidgetBounds(dateTime, 12);
        DateTimeLCAUtil.writeSubWidgetBounds(dateTime, 10);
        DateTimeLCAUtil.writeSubWidgetBounds(dateTime, 7);
    }

    private void preserveSubWidgetsBounds(DateTime dateTime) {
        DateTimeLCAUtil.preserveSubWidgetBounds(dateTime, 8);
        DateTimeLCAUtil.preserveSubWidgetBounds(dateTime, 11);
        DateTimeLCAUtil.preserveSubWidgetBounds(dateTime, 9);
        DateTimeLCAUtil.preserveSubWidgetBounds(dateTime, 12);
        DateTimeLCAUtil.preserveSubWidgetBounds(dateTime, 10);
        DateTimeLCAUtil.preserveSubWidgetBounds(dateTime, 7);
    }
}

