/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.displaykit;

import java.io.IOException;
import java.text.MessageFormat;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.branding.AbstractBranding;
import org.eclipse.rwt.internal.RWTMessages;
import org.eclipse.rwt.internal.application.RWTFactory;
import org.eclipse.rwt.internal.branding.BrandingUtil;
import org.eclipse.rwt.internal.lifecycle.DisplayUtil;
import org.eclipse.rwt.internal.lifecycle.DisposedWidgets;
import org.eclipse.rwt.internal.lifecycle.IDisplayLifeCycleAdapter;
import org.eclipse.rwt.internal.lifecycle.JavaScriptResponseWriter;
import org.eclipse.rwt.internal.lifecycle.RWTRequestVersionControl;
import org.eclipse.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rwt.internal.protocol.IClientObject;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.rwt.internal.theme.Theme;
import org.eclipse.rwt.internal.theme.ThemeUtil;
import org.eclipse.rwt.internal.uicallback.UICallBackServiceHandler;
import org.eclipse.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.EventUtil;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.internal.widgets.IShellAdapter;
import org.eclipse.swt.internal.widgets.WidgetAdapter;
import org.eclipse.swt.internal.widgets.WidgetTreeVisitor;
import org.eclipse.swt.internal.widgets.displaykit.ActiveKeysUtil;
import org.eclipse.swt.internal.widgets.displaykit.DNDSupport;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class DisplayLCA
implements IDisplayLifeCycleAdapter {
    static final String PROP_FOCUS_CONTROL = "focusControl";
    static final String PROP_CURR_THEME = "currTheme";
    static final String PROP_EXIT_CONFIRMATION = "exitConfirmation";
    static final String PROP_TIMEOUT_PAGE = "timeoutPage";

    public void readData(Display display) {
        DisplayLCA.readBounds(display);
        DisplayLCA.readCursorLocation(display);
        DisplayLCA.readFocusControl(display);
        ActiveKeysUtil.readKeyEvents(display);
        WidgetTreeVisitor.AllWidgetTreeVisitor visitor = new WidgetTreeVisitor.AllWidgetTreeVisitor(){

            public boolean doVisit(Widget widget) {
                AbstractWidgetLCA adapter = WidgetUtil.getLCA(widget);
                adapter.readData(widget);
                return true;
            }
        };
        Shell[] shells = DisplayLCA.getShells(display);
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            WidgetTreeVisitor.accept(shell, visitor);
            ++i;
        }
        i = 0;
        while (i < shells.length) {
            if (shells[i].getMaximized() || shells[i].getFullScreen()) {
                IShellAdapter adapter;
                IShellAdapter shellAdapter = adapter = shells[i].getAdapter(IShellAdapter.class);
                shellAdapter.setBounds(display.getBounds());
            }
            ++i;
        }
        DNDSupport.processEvents();
    }

    public void preserveValues(Display display) {
        IWidgetAdapter adapter = DisplayUtil.getAdapter(display);
        adapter.preserve(PROP_FOCUS_CONTROL, display.getFocusControl());
        adapter.preserve(PROP_CURR_THEME, ThemeUtil.getCurrentThemeId());
        adapter.preserve(PROP_TIMEOUT_PAGE, DisplayLCA.getTimeoutPage());
        adapter.preserve(PROP_EXIT_CONFIRMATION, DisplayLCA.getExitConfirmation());
        ActiveKeysUtil.preserveActiveKeys(display);
        if (adapter.isInitialized()) {
            Shell[] shells = DisplayLCA.getShells(display);
            int i = 0;
            while (i < shells.length) {
                WidgetTreeVisitor.accept(shells[i], new WidgetTreeVisitor.AllWidgetTreeVisitor(){

                    public boolean doVisit(Widget widget) {
                        AbstractWidgetLCA widgetLCA = WidgetUtil.getLCA(widget);
                        widgetLCA.preserveValues(widget);
                        return true;
                    }
                });
                ++i;
            }
        }
    }

    public void render(Display display) throws IOException {
        HttpServletRequest request = ContextProvider.getRequest();
        if (request.getParameter("uiRoot") != null) {
            DisplayLCA.disposeWidgets();
            DisplayLCA.renderRequestCounter();
            DisplayLCA.writeTheme(display);
            DisplayLCA.writeErrorPages(display);
            DisplayLCA.renderExitConfirmation(display);
            DisplayLCA.renderShells(display);
            DisplayLCA.writeFocus(display);
            DisplayLCA.writeUICallBackActivation(display);
            DisplayLCA.markInitialized(display);
            ActiveKeysUtil.writeActiveKeys(display);
        }
    }

    public void clearPreserved(Display display) {
        WidgetAdapter widgetAdapter = (WidgetAdapter)DisplayUtil.getAdapter(display);
        widgetAdapter.clearPreserved();
        Shell[] shells = DisplayLCA.getShells(display);
        int i = 0;
        while (i < shells.length) {
            WidgetTreeVisitor.accept(shells[i], new WidgetTreeVisitor.AllWidgetTreeVisitor(){

                public boolean doVisit(Widget widget) {
                    WidgetAdapter widgetAdapter = (WidgetAdapter)WidgetUtil.getAdapter(widget);
                    widgetAdapter.clearPreserved();
                    return true;
                }
            });
            ++i;
        }
    }

    private static void renderShells(Display display) throws IOException {
        RenderVisitor visitor = new RenderVisitor();
        Shell[] shells = DisplayLCA.getShells(display);
        int i = 0;
        while (i < shells.length) {
            WidgetTreeVisitor.accept(shells[i], visitor);
            visitor.reThrowProblem();
            ++i;
        }
    }

    private static void renderRequestCounter() {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        JavaScriptResponseWriter responseWriter = stateInfo.getResponseWriter();
        RWTRequestVersionControl.getInstance().nextRequestId();
        responseWriter.getProtocolWriter();
    }

    private static void writeTheme(Display display) {
        IWidgetAdapter adapter;
        Object oldThemeId;
        String currThemeId = ThemeUtil.getCurrentThemeId();
        if (!currThemeId.equals(oldThemeId = (adapter = DisplayUtil.getAdapter(display)).getPreserved(PROP_CURR_THEME))) {
            Theme theme = RWTFactory.getThemeManager().getTheme(currThemeId);
            StringBuffer buffer = new StringBuffer();
            buffer.append("qx.theme.manager.Meta.getInstance().setTheme( ");
            buffer.append(theme.getJsId());
            buffer.append(" );");
            IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
            JavaScriptResponseWriter responseWriter = stateInfo.getResponseWriter();
            responseWriter.write(buffer.toString());
        }
    }

    private static void writeErrorPages(Display display) {
        IWidgetAdapter adapter;
        Object oldTimeoutPage;
        String timeoutPage = DisplayLCA.getTimeoutPage();
        if (!timeoutPage.equals(oldTimeoutPage = (adapter = DisplayUtil.getAdapter(display)).getPreserved(PROP_TIMEOUT_PAGE))) {
            String pattern = "org.eclipse.swt.Request.getInstance().setTimeoutPage( \"{0}\" );";
            Object[] param = new Object[]{timeoutPage};
            String jsCode = MessageFormat.format(pattern, param);
            IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
            JavaScriptResponseWriter responseWriter = stateInfo.getResponseWriter();
            responseWriter.write(jsCode);
        }
    }

    private static String getTimeoutPage() {
        String timeoutTitle = RWTMessages.getMessage("RWT_SessionTimeoutPageTitle");
        String timeoutHeadline = RWTMessages.getMessage("RWT_SessionTimeoutPageHeadline");
        String pattern = RWTMessages.getMessage("RWT_SessionTimeoutPageMessage");
        Object[] arguments = new Object[]{"<a {HREF_URL}>", "</a>"};
        String timeoutMessage = MessageFormat.format(pattern, arguments);
        String timeoutPage = "<html><head><title>" + timeoutTitle + "</title></head><body><p>" + timeoutHeadline + "</p><p>" + timeoutMessage + "</p></body></html>";
        return timeoutPage;
    }

    private static void renderExitConfirmation(Display display) {
        boolean hasChanged;
        String exitConfirmation = DisplayLCA.getExitConfirmation();
        IWidgetAdapter adapter = DisplayUtil.getAdapter(display);
        Object oldExitConfirmation = adapter.getPreserved(PROP_EXIT_CONFIRMATION);
        boolean bl = exitConfirmation == null ? oldExitConfirmation != null : (hasChanged = !exitConfirmation.equals(oldExitConfirmation));
        if (hasChanged) {
            IClientObject clientObject = ClientObjectFactory.getForDisplay(display);
            clientObject.setProperty(PROP_EXIT_CONFIRMATION, exitConfirmation);
        }
    }

    private static String getExitConfirmation() {
        AbstractBranding branding = BrandingUtil.determineBranding();
        String result = null;
        if (branding.showExitConfirmation() && (result = branding.getExitConfirmationText()) == null) {
            result = "";
        }
        return result;
    }

    private static void disposeWidgets() throws IOException {
        AbstractWidgetLCA lca;
        Widget toDispose;
        Widget[] disposedWidgets = DisposedWidgets.getAll();
        int i = disposedWidgets.length - 1;
        while (i >= 0) {
            toDispose = disposedWidgets[i];
            if (toDispose instanceof DragSource || toDispose instanceof DropTarget) {
                lca = WidgetUtil.getLCA(toDispose);
                lca.renderDispose(toDispose);
            }
            --i;
        }
        i = disposedWidgets.length - 1;
        while (i >= 0) {
            toDispose = disposedWidgets[i];
            if (!(toDispose instanceof DragSource) && !(toDispose instanceof DropTarget)) {
                lca = WidgetUtil.getLCA(toDispose);
                lca.renderDispose(toDispose);
            }
            --i;
        }
    }

    private static void writeFocus(Display display) {
        if (!display.isDisposed()) {
            Control focusControl;
            IDisplayAdapter displayAdapter = DisplayLCA.getDisplayAdapter(display);
            IWidgetAdapter widgetAdapter = DisplayUtil.getAdapter(display);
            Object oldValue = widgetAdapter.getPreserved(PROP_FOCUS_CONTROL);
            if ((!widgetAdapter.isInitialized() || oldValue != display.getFocusControl() || displayAdapter.isFocusInvalidated()) && (focusControl = display.getFocusControl()) != null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("org.eclipse.swt.WidgetManager.getInstance().");
                buffer.append("focus( \"");
                buffer.append(WidgetUtil.getId(display.getFocusControl()));
                buffer.append("\" );");
                IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
                JavaScriptResponseWriter responseWriter = stateInfo.getResponseWriter();
                responseWriter.write(buffer.toString());
            }
        }
    }

    private static void writeUICallBackActivation(Display display) {
        JavaScriptResponseWriter responseWriter = ContextProvider.getStateInfo().getResponseWriter();
        UICallBackServiceHandler.writeUICallBackActivation(responseWriter);
    }

    private static void markInitialized(Display display) {
        WidgetAdapter adapter = (WidgetAdapter)DisplayUtil.getAdapter(display);
        adapter.setInitialized(true);
    }

    static void readBounds(Display display) {
        Rectangle oldBounds = display.getBounds();
        int width = DisplayLCA.readIntPropertyValue(display, "bounds.width", oldBounds.width);
        int height = DisplayLCA.readIntPropertyValue(display, "bounds.height", oldBounds.height);
        Rectangle bounds = new Rectangle(0, 0, width, height);
        DisplayLCA.getDisplayAdapter(display).setBounds(bounds);
    }

    private static void readCursorLocation(Display display) {
        int x = DisplayLCA.readIntPropertyValue(display, "cursorLocation.x", 0);
        int y = DisplayLCA.readIntPropertyValue(display, "cursorLocation.y", 0);
        DisplayLCA.getDisplayAdapter(display).setCursorLocation(x, y);
    }

    static void readFocusControl(Display display) {
        HttpServletRequest request = ContextProvider.getRequest();
        StringBuffer focusControlParam = new StringBuffer();
        focusControlParam.append(DisplayUtil.getId(display));
        focusControlParam.append(".focusControl");
        String id = request.getParameter(focusControlParam.toString());
        if (id != null) {
            Control focusControl = null;
            if (!"null".equals(id)) {
                Shell[] shells = DisplayLCA.getDisplayAdapter(display).getShells();
                int i = 0;
                while (focusControl == null && i < shells.length) {
                    Widget widget = WidgetUtil.find(shells[i], id);
                    if (widget instanceof Control) {
                        focusControl = (Control)widget;
                    }
                    ++i;
                }
            }
            if (focusControl != null && EventUtil.isAccessible(focusControl)) {
                DisplayLCA.getDisplayAdapter(display).setFocusControl(focusControl);
            }
        }
    }

    private static String readPropertyValue(Display display, String propertyName) {
        HttpServletRequest request = ContextProvider.getRequest();
        StringBuffer key = new StringBuffer();
        key.append(DisplayUtil.getId(display));
        key.append(".");
        key.append(propertyName);
        return request.getParameter(key.toString());
    }

    private static int readIntPropertyValue(Display display, String propertyName, int defaultValue) {
        String value = DisplayLCA.readPropertyValue(display, propertyName);
        int result = value == null ? defaultValue : NumberFormatUtil.parseInt(value);
        return result;
    }

    private static IDisplayAdapter getDisplayAdapter(Display display) {
        IDisplayAdapter adapter = display.getAdapter(IDisplayAdapter.class);
        return adapter;
    }

    private static Shell[] getShells(Display display) {
        return DisplayLCA.getDisplayAdapter(display).getShells();
    }

    private static final class RenderVisitor
    extends WidgetTreeVisitor.AllWidgetTreeVisitor {
        private IOException ioProblem;

        private RenderVisitor() {
        }

        public boolean doVisit(Widget widget) {
            this.ioProblem = null;
            boolean result = true;
            try {
                RenderVisitor.render(widget);
                RenderVisitor.runRenderRunnable(widget);
            }
            catch (IOException ioe) {
                this.ioProblem = ioe;
                result = false;
            }
            return result;
        }

        private void reThrowProblem() throws IOException {
            if (this.ioProblem != null) {
                throw this.ioProblem;
            }
        }

        private static void render(Widget widget) throws IOException {
            WidgetUtil.getLCA(widget).render(widget);
        }

        private static void runRenderRunnable(Widget widget) throws IOException {
            WidgetAdapter adapter = (WidgetAdapter)WidgetUtil.getAdapter(widget);
            if (adapter.getRenderRunnable() != null) {
                adapter.getRenderRunnable().afterRender();
                adapter.clearRenderRunnable();
            }
        }
    }
}

