/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.sliderkit;

import java.io.IOException;
import org.eclipse.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rwt.internal.protocol.IClientObject;
import org.eclipse.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Widget;

public class SliderLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.Slider";
    static final String PROP_MINIMUM = "minimum";
    static final String PROP_MAXIMUM = "maximum";
    static final String PROP_SELECTION = "selection";
    static final String PROP_INCREMENT = "increment";
    static final String PROP_PAGE_INCREMENT = "pageIncrement";
    static final String PROP_THUMB = "thumb";
    static final String PROP_SELECTION_LISTENER = "selection";
    private static final int DEFAULT_MINIMUM = 0;
    private static final int DEFAULT_MAXIMUM = 100;
    private static final int DEFAULT_SELECTION = 0;
    private static final int DEFAULT_INCREMENT = 1;
    private static final int DEFAULT_PINCREMENT = 10;
    private static final int DEFAULT_THUMB = 10;

    public void preserveValues(Widget widget) {
        Slider slider = (Slider)widget;
        ControlLCAUtil.preserveValues(slider);
        WidgetLCAUtil.preserveCustomVariant(slider);
        WidgetLCAUtil.preserveProperty((Widget)slider, PROP_MINIMUM, slider.getMinimum());
        WidgetLCAUtil.preserveProperty((Widget)slider, PROP_MAXIMUM, slider.getMaximum());
        WidgetLCAUtil.preserveProperty((Widget)slider, "selection", slider.getSelection());
        WidgetLCAUtil.preserveProperty((Widget)slider, PROP_INCREMENT, slider.getIncrement());
        WidgetLCAUtil.preserveProperty((Widget)slider, PROP_PAGE_INCREMENT, slider.getPageIncrement());
        WidgetLCAUtil.preserveProperty((Widget)slider, PROP_THUMB, slider.getThumb());
        WidgetLCAUtil.preserveListener(slider, "selection", SelectionEvent.hasListener(slider));
    }

    public void readData(Widget widget) {
        Slider slider = (Slider)widget;
        String value = WidgetLCAUtil.readPropertyValue(slider, "selection");
        if (value != null) {
            slider.setSelection(NumberFormatUtil.parseInt(value));
        }
        ControlLCAUtil.processSelection(slider, null, true);
        ControlLCAUtil.processMenuDetect(slider);
        WidgetLCAUtil.processHelp(slider);
    }

    public void renderInitialization(Widget widget) throws IOException {
        Slider slider = (Slider)widget;
        IClientObject clientObject = ClientObjectFactory.getForWidget(slider);
        clientObject.create(TYPE);
        clientObject.setProperty("parent", WidgetUtil.getId(slider.getParent()));
        clientObject.setProperty("style", WidgetLCAUtil.getStyles(slider));
    }

    public void renderChanges(Widget widget) throws IOException {
        Slider slider = (Slider)widget;
        ControlLCAUtil.renderChanges(slider);
        WidgetLCAUtil.renderCustomVariant(widget);
        WidgetLCAUtil.renderProperty((Widget)slider, PROP_MINIMUM, slider.getMinimum(), 0);
        WidgetLCAUtil.renderProperty((Widget)slider, PROP_MAXIMUM, slider.getMaximum(), 100);
        WidgetLCAUtil.renderProperty((Widget)slider, "selection", slider.getSelection(), 0);
        WidgetLCAUtil.renderProperty((Widget)slider, PROP_INCREMENT, slider.getIncrement(), 1);
        WidgetLCAUtil.renderProperty((Widget)slider, PROP_PAGE_INCREMENT, slider.getPageIncrement(), 10);
        WidgetLCAUtil.renderProperty((Widget)slider, PROP_THUMB, slider.getThumb(), 10);
        WidgetLCAUtil.renderListener(slider, "selection", SelectionEvent.hasListener(slider), false);
    }

    public void renderDispose(Widget widget) throws IOException {
        ClientObjectFactory.getForWidget(widget).destroy();
    }
}

