/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.graphics;

import java.io.InputStream;
import org.eclipse.rwt.internal.application.RWTFactory;
import org.eclipse.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public final class Graphics {
    public static Color getColor(RGB rgb) {
        Graphics.checkThread();
        if (rgb == null) {
            SWT.error(4);
        }
        return RWTFactory.getResourceFactory().getColor(rgb.red, rgb.green, rgb.blue);
    }

    public static Color getColor(int red, int green, int blue) {
        Graphics.checkThread();
        return RWTFactory.getResourceFactory().getColor(red, green, blue);
    }

    public static Font getFont(FontData data) {
        Graphics.checkThread();
        if (data == null) {
            SWT.error(4);
        }
        return RWTFactory.getResourceFactory().getFont(data);
    }

    public static Font getFont(String name, int height, int style) {
        Graphics.checkThread();
        return RWTFactory.getResourceFactory().getFont(new FontData(name, height, style));
    }

    public static Image getImage(String path) {
        Graphics.checkThread();
        if (path == null) {
            SWT.error(4);
        }
        if ("".equals(path)) {
            SWT.error(5);
        }
        return RWTFactory.getImageFactory().findImage(path);
    }

    public static Image getImage(String path, ClassLoader imageLoader) {
        Graphics.checkThread();
        if (path == null) {
            SWT.error(4);
        }
        if ("".equals(path)) {
            SWT.error(5);
        }
        return RWTFactory.getImageFactory().findImage(path, imageLoader);
    }

    public static Image getImage(String path, InputStream inputStream) {
        Graphics.checkThread();
        if (path == null) {
            SWT.error(4);
        }
        if (inputStream == null) {
            SWT.error(4);
        }
        if ("".equals(path)) {
            SWT.error(5);
        }
        return RWTFactory.getImageFactory().findImage(path, inputStream);
    }

    public static Cursor getCursor(int style) {
        Graphics.checkThread();
        return RWTFactory.getResourceFactory().getCursor(style);
    }

    public static Point textExtent(Font font, String string, int wrapWidth) {
        Graphics.checkThread();
        if (font == null || string == null) {
            SWT.error(4);
        }
        return TextSizeUtil.textExtent(font, string, wrapWidth);
    }

    public static Point stringExtent(Font font, String string) {
        Graphics.checkThread();
        if (font == null || string == null) {
            SWT.error(4);
        }
        return TextSizeUtil.stringExtent(font, string);
    }

    public static int getCharHeight(Font font) {
        Graphics.checkThread();
        if (font == null) {
            SWT.error(4);
        }
        return TextSizeUtil.getCharHeight(font);
    }

    public static float getAvgCharWidth(Font font) {
        if (font == null) {
            SWT.error(4);
        }
        return TextSizeUtil.getAvgCharWidth(font);
    }

    static void checkThread() {
        if (Graphics.getDisplayThread() != Thread.currentThread()) {
            SWT.error(22);
        }
    }

    private static Thread getDisplayThread() {
        Thread result = null;
        Display display = LifeCycleUtil.getSessionDisplay();
        if (display != null) {
            result = display.getThread();
        }
        return result;
    }

    private Graphics() {
    }
}

