/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.lifecycle;

import java.io.IOException;
import org.eclipse.rwt.internal.lifecycle.EntryPointUtil;
import org.eclipse.rwt.internal.lifecycle.IPhase;
import org.eclipse.rwt.internal.lifecycle.ISessionShutdownAdapter;
import org.eclipse.rwt.internal.lifecycle.IUIThreadHolder;
import org.eclipse.rwt.internal.lifecycle.LifeCycle;
import org.eclipse.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rwt.internal.lifecycle.PhaseListenerManager;
import org.eclipse.rwt.internal.lifecycle.ProcessAction;
import org.eclipse.rwt.internal.lifecycle.ReadData;
import org.eclipse.rwt.internal.lifecycle.Render;
import org.eclipse.rwt.internal.lifecycle.UIThread;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.ServiceContext;
import org.eclipse.rwt.internal.service.SessionStoreImpl;
import org.eclipse.rwt.internal.uicallback.UICallBackManager;
import org.eclipse.rwt.lifecycle.IEntryPoint;
import org.eclipse.rwt.lifecycle.PhaseId;
import org.eclipse.rwt.lifecycle.PhaseListener;
import org.eclipse.rwt.service.IServiceStore;
import org.eclipse.rwt.service.ISessionStore;
import org.eclipse.swt.widgets.Display;

public class RWTLifeCycle
extends LifeCycle {
    private static final Integer ZERO = 0;
    private static final String CURRENT_PHASE = String.valueOf(RWTLifeCycle.class.getName()) + ".currentPhase";
    private static final String PHASE_ORDER = String.valueOf(RWTLifeCycle.class.getName()) + ".phaseOrder";
    private static final String UI_THREAD_THROWABLE = String.valueOf(UIThreadController.class.getName()) + "#UIThreadThrowable";
    private static final String REQUEST_THREAD_RUNNABLE = String.valueOf(RWTLifeCycle.class.getName()) + "#requestThreadRunnable";
    private static final IPhase[] PHASE_ORDER_STARTUP = new IPhase[]{new IPhase.IInterruptible(){

        public PhaseId execute(Display display) throws IOException {
            return null;
        }

        public PhaseId getPhaseId() {
            return PhaseId.PREPARE_UI_ROOT;
        }
    }, new Render()};
    private static final IPhase[] PHASE_ORDER_SUBSEQUENT = new IPhase[]{new IPhase(){

        public PhaseId execute(Display display) throws IOException {
            return null;
        }

        public PhaseId getPhaseId() {
            return PhaseId.PREPARE_UI_ROOT;
        }
    }, new ReadData(), new IPhase.IInterruptible(){

        public PhaseId execute(Display display) throws IOException {
            new ProcessAction().execute(display);
            return null;
        }

        public PhaseId getPhaseId() {
            return PhaseId.PROCESS_ACTION;
        }
    }, new Render()};
    private final PhaseListenerManager phaseListenerManager = new PhaseListenerManager(this);
    Runnable uiRunnable = new UIThreadController();

    public void execute() throws IOException {
        if (LifeCycleUtil.isStartup()) {
            this.setPhaseOrder(PHASE_ORDER_STARTUP);
        } else {
            this.setPhaseOrder(PHASE_ORDER_SUBSEQUENT);
        }
        Runnable runnable = null;
        do {
            RWTLifeCycle.setRequestThreadRunnable(null);
            this.executeUIThread();
            runnable = RWTLifeCycle.getRequestThreadRunnable();
            if (runnable == null) continue;
            runnable.run();
        } while (runnable != null);
    }

    public void addPhaseListener(PhaseListener listener) {
        this.phaseListenerManager.addPhaseListener(listener);
    }

    public void removePhaseListener(PhaseListener listener) {
        this.phaseListenerManager.removePhaseListener(listener);
    }

    public void requestThreadExec(Runnable runnable) {
        RWTLifeCycle.setRequestThreadRunnable(runnable);
        RWTLifeCycle.getUIThreadHolder().switchThread();
    }

    private static void setRequestThreadRunnable(Runnable runnable) {
        IServiceStore serviceStore = ContextProvider.getServiceStore();
        serviceStore.setAttribute(REQUEST_THREAD_RUNNABLE, runnable);
    }

    private static Runnable getRequestThreadRunnable() {
        IServiceStore serviceStore = ContextProvider.getServiceStore();
        return (Runnable)serviceStore.getAttribute(REQUEST_THREAD_RUNNABLE);
    }

    void continueLifeCycle() {
        int start = 0;
        IPhase[] phaseOrder = this.getPhaseOrder();
        if (phaseOrder != null) {
            Integer currentPhase = RWTLifeCycle.getCurrentPhase();
            if (currentPhase != null) {
                int phaseIndex = currentPhase;
                this.phaseListenerManager.notifyAfterPhase(phaseOrder[phaseIndex].getPhaseId());
                start = currentPhase + 1;
            }
            boolean interrupted = false;
            int i = start;
            while (!interrupted && i < phaseOrder.length) {
                IPhase phase = phaseOrder[i];
                this.phaseListenerManager.notifyBeforePhase(phase.getPhaseId());
                if (phase instanceof IPhase.IInterruptible) {
                    IServiceStore serviceStore = ContextProvider.getServiceStore();
                    serviceStore.setAttribute(CURRENT_PHASE, new Integer(i));
                    interrupted = true;
                } else {
                    try {
                        phase.execute(LifeCycleUtil.getSessionDisplay());
                    }
                    catch (Throwable e) {
                        throw new PhaseExecutionError(e);
                    }
                    this.phaseListenerManager.notifyAfterPhase(phase.getPhaseId());
                }
                ++i;
            }
            if (!interrupted) {
                ContextProvider.getServiceStore().setAttribute(CURRENT_PHASE, null);
            }
        }
    }

    int createUI() {
        int result = -1;
        if (ZERO.equals(RWTLifeCycle.getCurrentPhase()) && LifeCycleUtil.isStartup()) {
            IEntryPoint entryPoint = EntryPointUtil.getCurrentEntryPoint();
            result = entryPoint.createUI();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeUIThread() throws IOException {
        ServiceContext context = ContextProvider.getContext();
        ISessionStore session = ContextProvider.getSessionStore();
        IUIThreadHolder uiThread = RWTLifeCycle.getUIThreadHolder();
        if (uiThread == null) {
            uiThread = this.createUIThread();
            uiThread.setServiceContext(context);
            Object object = uiThread.getLock();
            synchronized (object) {
                uiThread.getThread().start();
                uiThread.switchThread();
            }
        } else {
            uiThread.setServiceContext(context);
            uiThread.switchThread();
        }
        if (!uiThread.getThread().isAlive()) {
            LifeCycleUtil.setUIThread(session, null);
        }
        RWTLifeCycle.handleUIThreadException();
    }

    private static void handleUIThreadException() throws IOException {
        IServiceStore serviceStore = ContextProvider.getServiceStore();
        Throwable throwable = (Throwable)serviceStore.getAttribute(UI_THREAD_THROWABLE);
        if (throwable != null) {
            if (throwable instanceof PhaseExecutionError) {
                throwable = throwable.getCause();
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    public void sleep() {
        this.continueLifeCycle();
        IUIThreadHolder uiThread = RWTLifeCycle.getUIThreadHolder();
        UICallBackManager.getInstance().notifyUIThreadEnd();
        uiThread.switchThread();
        uiThread.updateServiceContext();
        UICallBackManager.getInstance().notifyUIThreadStart();
        this.continueLifeCycle();
    }

    private IUIThreadHolder createUIThread() {
        ISessionStore session = ContextProvider.getSessionStore();
        UIThread result = new UIThread(this.uiRunnable);
        result.getThread().setDaemon(true);
        result.getThread().setName("UIThread [" + session.getId() + "]");
        LifeCycleUtil.setUIThread(session, result);
        RWTLifeCycle.setShutdownAdapter(result);
        return result;
    }

    private static Integer getCurrentPhase() {
        IServiceStore serviceStore = ContextProvider.getServiceStore();
        return (Integer)serviceStore.getAttribute(CURRENT_PHASE);
    }

    private static void setShutdownAdapter(ISessionShutdownAdapter adapter) {
        ISessionStore sessionStore = ContextProvider.getSessionStore();
        SessionStoreImpl sessionStoreImpl = (SessionStoreImpl)sessionStore;
        sessionStoreImpl.setShutdownAdapter(adapter);
    }

    public void setPhaseOrder(IPhase[] phaseOrder) {
        IServiceStore serviceStore = ContextProvider.getServiceStore();
        serviceStore.setAttribute(PHASE_ORDER, phaseOrder);
    }

    IPhase[] getPhaseOrder() {
        IServiceStore serviceStore = ContextProvider.getServiceStore();
        return (IPhase[])serviceStore.getAttribute(PHASE_ORDER);
    }

    public static IUIThreadHolder getUIThreadHolder() {
        return LifeCycleUtil.getUIThread(ContextProvider.getSessionStore());
    }

    private static final class PhaseExecutionError
    extends ThreadDeath {
        public PhaseExecutionError(Throwable cause) {
            this.initCause(cause);
        }
    }

    private final class UIThreadController
    implements Runnable {
        private UIThreadController() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            IUIThreadHolder uiThread = (IUIThreadHolder)((Object)Thread.currentThread());
            try {
                Object object = uiThread.getLock();
                synchronized (object) {
                    try {
                        uiThread.updateServiceContext();
                        UICallBackManager.getInstance().notifyUIThreadStart();
                        RWTLifeCycle.this.continueLifeCycle();
                        RWTLifeCycle.this.createUI();
                        RWTLifeCycle.this.continueLifeCycle();
                        UICallBackManager.getInstance().notifyUIThreadEnd();
                    }
                    catch (UIThread.UIThreadTerminatedError thr) {
                        throw thr;
                    }
                    catch (Throwable thr) {
                        IServiceStore serviceStore = ContextProvider.getServiceStore();
                        serviceStore.setAttribute(UI_THREAD_THROWABLE, thr);
                    }
                    uiThread.switchThread();
                }
            }
            catch (UIThread.UIThreadTerminatedError uIThreadTerminatedError) {
                ((ISessionShutdownAdapter)((Object)uiThread)).processShutdown();
            }
        }
    }
}

