/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.protocol;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rwt.internal.lifecycle.DisplayUtil;
import org.eclipse.rwt.internal.protocol.ClientObject;
import org.eclipse.rwt.internal.protocol.IClientObject;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.rwt.service.IServiceStore;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClientObjectFactory {
    private static final String GC_SUFFIX = "#gc";
    private static final String CLIENT_OBJECT_MAP_KEY = "synchronizerMapKey";

    public static IClientObject getForWidget(Widget widget) {
        if (!ClientObjectFactory.isValidThread(widget)) {
            throw new IllegalStateException("Illegal thread access");
        }
        return ClientObjectFactory.getForId(WidgetUtil.getId(widget));
    }

    public static IClientObject getForGC(Widget widget) {
        if (!ClientObjectFactory.isValidThread(widget)) {
            throw new IllegalStateException("Illegal thread access");
        }
        return ClientObjectFactory.getForId(String.valueOf(WidgetUtil.getId(widget)) + GC_SUFFIX);
    }

    public static IClientObject getForDisplay(Display display) {
        ParamCheck.notNull(display, "display");
        if (!ClientObjectFactory.isValidThread(display)) {
            throw new IllegalStateException("Illegal thread access");
        }
        return ClientObjectFactory.getForId(DisplayUtil.getId(display));
    }

    private static IClientObject getForId(String id) {
        IClientObject result;
        Map<String, IClientObject> map = ClientObjectFactory.getClientObjectMap();
        if (map.containsKey(id)) {
            result = map.get(id);
        } else {
            result = new ClientObject(id);
            map.put(id, result);
        }
        return result;
    }

    private static Map<String, IClientObject> getClientObjectMap() {
        IServiceStore serviceStore = ContextProvider.getServiceStore();
        HashMap result = (HashMap)serviceStore.getAttribute(CLIENT_OBJECT_MAP_KEY);
        if (result == null) {
            result = new HashMap();
            serviceStore.setAttribute(CLIENT_OBJECT_MAP_KEY, result);
        }
        return result;
    }

    private static boolean isValidThread(Widget widget) {
        return ClientObjectFactory.isValidThread(widget.getDisplay());
    }

    private static boolean isValidThread(Display display) {
        IDisplayAdapter adapter = display.getAdapter(IDisplayAdapter.class);
        return adapter.isValidThread();
    }

    private ClientObjectFactory() {
    }
}

