/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.expandbarkit;

import java.io.IOException;
import org.eclipse.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rwt.internal.protocol.IClientObject;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.IExpandBarAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Widget;

public final class ExpandBarLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.ExpandBar";
    private static final String[] ALLOWED_STYLES = new String[]{"NO_RADIO_GROUP", "BORDER"};
    private static final String PROP_BOTTOM_SPACING_BOUNDS = "bottomSpacingBounds";
    private static final String PROP_VSCROLLBAR_VISIBLE = "vScrollBarVisible";
    private static final String PROP_VSCROLLBAR_MAX = "vScrollBarMax";

    public void preserveValues(Widget widget) {
        ExpandBar expandBar = (ExpandBar)widget;
        ControlLCAUtil.preserveValues(expandBar);
        WidgetLCAUtil.preserveCustomVariant(expandBar);
        WidgetLCAUtil.preserveProperty((Widget)expandBar, PROP_BOTTOM_SPACING_BOUNDS, ExpandBarLCA.getBottomSpacingBounds(expandBar));
        WidgetLCAUtil.preserveProperty((Widget)expandBar, PROP_VSCROLLBAR_VISIBLE, ExpandBarLCA.isVScrollBarVisible(expandBar));
        WidgetLCAUtil.preserveProperty((Widget)expandBar, PROP_VSCROLLBAR_MAX, ExpandBarLCA.getVScrollBarMax(expandBar));
    }

    public void readData(Widget widget) {
        ControlLCAUtil.processKeyEvents((Control)widget);
        ControlLCAUtil.processMenuDetect((Control)widget);
        WidgetLCAUtil.processHelp(widget);
    }

    public void renderInitialization(Widget widget) throws IOException {
        ExpandBar expandBar = (ExpandBar)widget;
        IClientObject clientObject = ClientObjectFactory.getForWidget(expandBar);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(expandBar.getParent()));
        clientObject.set("style", WidgetLCAUtil.getStyles(expandBar, ALLOWED_STYLES));
    }

    public void renderChanges(Widget widget) throws IOException {
        ExpandBar expandBar = (ExpandBar)widget;
        ControlLCAUtil.renderChanges(expandBar);
        WidgetLCAUtil.renderCustomVariant(expandBar);
        WidgetLCAUtil.renderProperty((Widget)expandBar, PROP_BOTTOM_SPACING_BOUNDS, ExpandBarLCA.getBottomSpacingBounds(expandBar), null);
        WidgetLCAUtil.renderProperty((Widget)expandBar, PROP_VSCROLLBAR_VISIBLE, ExpandBarLCA.isVScrollBarVisible(expandBar), false);
        WidgetLCAUtil.renderProperty((Widget)expandBar, PROP_VSCROLLBAR_MAX, ExpandBarLCA.getVScrollBarMax(expandBar), 0);
    }

    public void renderDispose(Widget widget) throws IOException {
        ClientObjectFactory.getForWidget(widget).destroy();
    }

    private static Rectangle getBottomSpacingBounds(ExpandBar bar) {
        return ExpandBarLCA.getExpandBarAdapter(bar).getBottomSpacingBounds();
    }

    private static boolean isVScrollBarVisible(ExpandBar bar) {
        return ExpandBarLCA.getExpandBarAdapter(bar).isVScrollbarVisible();
    }

    private static int getVScrollBarMax(ExpandBar bar) {
        int result = 0;
        if ((bar.getStyle() & 0x200) != 0) {
            IExpandBarAdapter expandBarAdapter = ExpandBarLCA.getExpandBarAdapter(bar);
            ExpandItem[] items = bar.getItems();
            int i = 0;
            while (i < items.length) {
                result += expandBarAdapter.getBounds((ExpandItem)items[i]).height;
                ++i;
            }
            result += bar.getSpacing() * (items.length + 1);
        }
        return result;
    }

    public static IExpandBarAdapter getExpandBarAdapter(ExpandBar bar) {
        return bar.getAdapter(IExpandBarAdapter.class);
    }
}

