/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.tablecolumnkit;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rwt.internal.protocol.IClientObject;
import org.eclipse.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.internal.widgets.ITableAdapter;
import org.eclipse.swt.internal.widgets.ItemLCAUtil;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public final class TableColumnLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.TableColumn";
    static final String PROP_INDEX = "index";
    static final String PROP_LEFT = "left";
    static final String PROP_WIDTH = "width";
    static final String PROP_RESIZABLE = "resizable";
    static final String PROP_MOVEABLE = "moveable";
    static final String PROP_ALIGNMENT = "alignment";
    static final String PROP_FIXED = "fixed";
    static final String PROP_SELECTION_LISTENER = "selection";
    private static final int ZERO = 0;
    private static final String DEFAULT_ALIGNMENT = "left";

    public void preserveValues(Widget widget) {
        TableColumn column = (TableColumn)widget;
        WidgetLCAUtil.preserveToolTipText(column, column.getToolTipText());
        WidgetLCAUtil.preserveCustomVariant(column);
        ItemLCAUtil.preserve(column);
        WidgetLCAUtil.preserveProperty((Widget)column, PROP_INDEX, TableColumnLCA.getIndex(column));
        WidgetLCAUtil.preserveProperty((Widget)column, "left", TableColumnLCA.getLeft(column));
        WidgetLCAUtil.preserveProperty((Widget)column, PROP_WIDTH, column.getWidth());
        WidgetLCAUtil.preserveProperty((Widget)column, PROP_RESIZABLE, column.getResizable());
        WidgetLCAUtil.preserveProperty((Widget)column, PROP_MOVEABLE, column.getMoveable());
        WidgetLCAUtil.preserveProperty((Widget)column, PROP_ALIGNMENT, TableColumnLCA.getAlignment(column));
        WidgetLCAUtil.preserveProperty((Widget)column, PROP_FIXED, TableColumnLCA.isFixed(column));
        WidgetLCAUtil.preserveListener(column, PROP_SELECTION_LISTENER, SelectionEvent.hasListener(column));
    }

    public void readData(Widget widget) {
        final TableColumn column = (TableColumn)widget;
        String value = WidgetLCAUtil.readPropertyValue(column, PROP_WIDTH);
        if (value != null) {
            final int newWidth = NumberFormatUtil.parseInt(value);
            ProcessActionRunner.add(new Runnable(){

                public void run() {
                    column.setWidth(newWidth);
                }
            });
        }
        if ((value = WidgetLCAUtil.readPropertyValue(column, "left")) != null) {
            final int newLeft = NumberFormatUtil.parseInt(value);
            ProcessActionRunner.add(new Runnable(){

                public void run() {
                    TableColumnLCA.moveColumn(column, newLeft);
                }
            });
        }
        ControlLCAUtil.processSelection(column, null, false);
    }

    public void renderInitialization(Widget widget) throws IOException {
        TableColumn column = (TableColumn)widget;
        IClientObject clientObject = ClientObjectFactory.getForWidget(column);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(column.getParent()));
    }

    public void renderChanges(Widget widget) throws IOException {
        TableColumn column = (TableColumn)widget;
        WidgetLCAUtil.renderToolTip(column, column.getToolTipText());
        WidgetLCAUtil.renderCustomVariant(column);
        ItemLCAUtil.renderChanges(column);
        WidgetLCAUtil.renderProperty((Widget)column, PROP_INDEX, TableColumnLCA.getIndex(column), 0);
        WidgetLCAUtil.renderProperty((Widget)column, "left", TableColumnLCA.getLeft(column), 0);
        WidgetLCAUtil.renderProperty((Widget)column, PROP_WIDTH, column.getWidth(), 0);
        WidgetLCAUtil.renderProperty((Widget)column, PROP_RESIZABLE, column.getResizable(), true);
        WidgetLCAUtil.renderProperty((Widget)column, PROP_MOVEABLE, column.getMoveable(), false);
        WidgetLCAUtil.renderProperty((Widget)column, PROP_ALIGNMENT, TableColumnLCA.getAlignment(column), "left");
        WidgetLCAUtil.renderProperty((Widget)column, PROP_FIXED, TableColumnLCA.isFixed(column), false);
        WidgetLCAUtil.renderListener(column, PROP_SELECTION_LISTENER, SelectionEvent.hasListener(column), false);
    }

    public void renderDispose(Widget widget) throws IOException {
        ClientObjectFactory.getForWidget(widget).destroy();
    }

    private static int getIndex(TableColumn column) {
        return column.getParent().indexOf(column);
    }

    private static int getLeft(TableColumn column) {
        ITableAdapter adapter = column.getParent().getAdapter(ITableAdapter.class);
        return adapter.getColumnLeft(column);
    }

    private static String getAlignment(TableColumn column) {
        int alignment = column.getAlignment();
        String result = "left";
        if ((alignment & 0x1000000) != 0) {
            result = "center";
        } else if ((alignment & 0x20000) != 0) {
            result = "right";
        }
        return result;
    }

    private static boolean isFixed(TableColumn column) {
        ITableAdapter adapter = column.getParent().getAdapter(ITableAdapter.class);
        return adapter.isFixedColumn(column);
    }

    static void moveColumn(TableColumn column, int newLeft) {
        Table table = column.getParent();
        int targetColumn = TableColumnLCA.findMoveTarget(table, newLeft);
        int[] columnOrder = table.getColumnOrder();
        int index = table.indexOf(column);
        int orderIndex = TableColumnLCA.arrayIndexOf(columnOrder, index);
        columnOrder = TableColumnLCA.arrayRemove(columnOrder, orderIndex);
        if (orderIndex < targetColumn) {
            --targetColumn;
        }
        if (TableColumnLCA.isFixed(column) || TableColumnLCA.isFixed(table.getColumn(targetColumn))) {
            targetColumn = table.indexOf(column);
        }
        if (Arrays.equals(columnOrder = TableColumnLCA.arrayInsert(columnOrder, targetColumn, index), table.getColumnOrder())) {
            TableColumn[] columns = table.getColumns();
            int i = 0;
            while (i < columns.length) {
                IWidgetAdapter adapter = WidgetUtil.getAdapter(columns[i]);
                adapter.preserve("left", null);
                ++i;
            }
        } else {
            table.setColumnOrder(columnOrder);
            IWidgetAdapter adapter = WidgetUtil.getAdapter(column);
            adapter.preserve("left", null);
        }
    }

    private static int findMoveTarget(Table table, int newLeft) {
        int result = -1;
        TableColumn[] columns = table.getColumns();
        int[] columnOrder = table.getColumnOrder();
        if (newLeft < 0) {
            result = 0;
        } else {
            int i = 0;
            while (result == -1 && i < columns.length) {
                TableColumn column = columns[columnOrder[i]];
                int left = TableColumnLCA.getLeft(column);
                int width = column.getWidth();
                if (TableColumnLCA.isFixed(column)) {
                    left += TableColumnLCA.getLeftOffset(column);
                }
                if (newLeft >= left && newLeft <= left + width) {
                    result = i;
                    if (newLeft >= left + width / 2 && result < columns.length && !TableColumnLCA.isFixed(column)) {
                        ++result;
                    }
                }
                ++i;
            }
        }
        if (result == -1) {
            result = columns.length;
        }
        return result;
    }

    private static int getLeftOffset(TableColumn column) {
        ITableAdapter adapter = column.getParent().getAdapter(ITableAdapter.class);
        return adapter.getLeftOffset();
    }

    private static int arrayIndexOf(int[] array, int value) {
        int result = -1;
        int i = 0;
        while (result == -1 && i < array.length) {
            if (array[i] == value) {
                result = i;
            }
            ++i;
        }
        return result;
    }

    private static int[] arrayRemove(int[] array, int index) {
        int length = array.length;
        int[] result = new int[length - 1];
        System.arraycopy(array, 0, result, 0, index);
        if (index < length - 1) {
            System.arraycopy(array, index + 1, result, index, length - index - 1);
        }
        return result;
    }

    private static int[] arrayInsert(int[] array, int index, int value) {
        int length = array.length;
        int[] result = new int[length + 1];
        System.arraycopy(array, 0, result, 0, length);
        System.arraycopy(result, index, result, index + 1, length - index);
        result[index] = value;
        return result;
    }
}

