/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.tooltipkit;

import java.io.IOException;
import org.eclipse.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rwt.internal.protocol.IClientObject;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.widgets.IToolTipAdapter;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Widget;

public final class ToolTipLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.ToolTip";
    private static final String[] ALLOWED_STYLES = new String[]{"BALLOON", "ICON_ERROR", "ICON_INFORMATION", "ICON_WARNING"};
    private static final String PROP_AUTO_HIDE = "autoHide";
    private static final String PROP_TEXT = "text";
    private static final String PROP_MESSAGE = "message";
    private static final String PROP_LOCATION = "location";
    private static final String PROP_VISIBLE = "visible";
    private static final String PROP_SELECTION_LISTENER = "selection";
    private static final Point DEFAULT_LOCATION = new Point(0, 0);

    public void preserveValues(Widget widget) {
        ToolTip toolTip = (ToolTip)widget;
        WidgetLCAUtil.preserveCustomVariant(widget);
        WidgetLCAUtil.preserveRoundedBorder(widget);
        WidgetLCAUtil.preserveBackgroundGradient(widget);
        WidgetLCAUtil.preserveProperty((Widget)toolTip, PROP_AUTO_HIDE, toolTip.getAutoHide());
        WidgetLCAUtil.preserveProperty((Widget)toolTip, PROP_TEXT, toolTip.getText());
        WidgetLCAUtil.preserveProperty((Widget)toolTip, PROP_MESSAGE, toolTip.getMessage());
        WidgetLCAUtil.preserveProperty((Widget)toolTip, PROP_LOCATION, ToolTipLCA.getLocation(toolTip));
        WidgetLCAUtil.preserveProperty((Widget)toolTip, PROP_VISIBLE, toolTip.isVisible());
        WidgetLCAUtil.preserveListener(toolTip, PROP_SELECTION_LISTENER, SelectionEvent.hasListener(toolTip));
    }

    public void readData(Widget widget) {
        ToolTip toolTip = (ToolTip)widget;
        ControlLCAUtil.processSelection(toolTip, null, false);
        ToolTipLCA.readVisible(toolTip);
    }

    public void renderInitialization(Widget widget) throws IOException {
        ToolTip toolTip = (ToolTip)widget;
        IClientObject clientObject = ClientObjectFactory.getForWidget(toolTip);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(toolTip.getParent()));
        clientObject.set("style", WidgetLCAUtil.getStyles(toolTip, ALLOWED_STYLES));
    }

    public void renderChanges(Widget widget) throws IOException {
        ToolTip toolTip = (ToolTip)widget;
        WidgetLCAUtil.renderCustomVariant(widget);
        WidgetLCAUtil.renderRoundedBorder(widget);
        WidgetLCAUtil.renderBackgroundGradient(widget);
        WidgetLCAUtil.renderProperty((Widget)toolTip, PROP_AUTO_HIDE, toolTip.getAutoHide(), false);
        WidgetLCAUtil.renderProperty((Widget)toolTip, PROP_TEXT, toolTip.getText(), "");
        WidgetLCAUtil.renderProperty((Widget)toolTip, PROP_MESSAGE, toolTip.getMessage(), "");
        WidgetLCAUtil.renderProperty((Widget)toolTip, PROP_LOCATION, ToolTipLCA.getLocation(toolTip), DEFAULT_LOCATION);
        WidgetLCAUtil.renderProperty((Widget)toolTip, PROP_VISIBLE, toolTip.isVisible(), false);
        WidgetLCAUtil.renderListener(toolTip, PROP_SELECTION_LISTENER, SelectionEvent.hasListener(toolTip), false);
    }

    public void renderDispose(Widget widget) throws IOException {
        ClientObjectFactory.getForWidget(widget).destroy();
    }

    private static void readVisible(ToolTip toolTip) {
        String value = WidgetLCAUtil.readPropertyValue(toolTip, PROP_VISIBLE);
        if (value != null) {
            toolTip.setVisible(new Boolean(value));
        }
    }

    private static Point getLocation(ToolTip toolTip) {
        return toolTip.getAdapter(IToolTipAdapter.class).getLocation();
    }
}

