/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.lifecycle;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.branding.AbstractBranding;
import org.eclipse.rwt.internal.application.RWTFactory;
import org.eclipse.rwt.internal.branding.BrandingUtil;
import org.eclipse.rwt.internal.lifecycle.EntryPointManager;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.rwt.lifecycle.IEntryPoint;
import org.eclipse.rwt.lifecycle.IEntryPointFactory;
import org.eclipse.rwt.service.ISessionStore;

public class EntryPointUtil {
    private static final String ATTR_CURRENT_ENTRY_POINT_NAME = String.valueOf(EntryPointUtil.class.getName()) + "#currentEntryPoint";
    public static final String DEFAULT = "default";

    private EntryPointUtil() {
    }

    public static IEntryPoint getCurrentEntryPoint() {
        String entryPointName = EntryPointUtil.getCurrentEntryPointName();
        return EntryPointUtil.getEntryPoint(entryPointName);
    }

    public static IEntryPoint getEntryPoint(String name) {
        ParamCheck.notNull(name, "name");
        EntryPointManager entryPointManager = RWTFactory.getEntryPointManager();
        IEntryPointFactory factory = entryPointManager.getEntryPointFactory(name);
        return factory.create();
    }

    public static String getCurrentEntryPointName() {
        String result = EntryPointUtil.readCurrentEntryPointName();
        if (result == null) {
            result = EntryPointUtil.determineCurrentEntryPointName();
            EntryPointUtil.storeCurrentEntryPointName(result);
        }
        return result;
    }

    private static String determineCurrentEntryPointName() {
        String result = EntryPointUtil.readFromStartupParameter();
        if (result == null && (result = EntryPointUtil.readFromBranding()) == null) {
            result = DEFAULT;
        }
        return result;
    }

    private static String readFromStartupParameter() {
        HttpServletRequest request = ContextProvider.getRequest();
        String result = request.getParameter("startup");
        if ("".equals(result)) {
            result = null;
        }
        return result;
    }

    private static String readFromBranding() {
        AbstractBranding branding = BrandingUtil.determineBranding();
        String result = branding.getDefaultEntryPoint();
        if ("".equals(result)) {
            result = null;
        }
        return result;
    }

    private static void storeCurrentEntryPointName(String name) {
        ISessionStore session = ContextProvider.getSessionStore();
        session.setAttribute(ATTR_CURRENT_ENTRY_POINT_NAME, name);
    }

    private static String readCurrentEntryPointName() {
        ISessionStore session = ContextProvider.getSessionStore();
        return (String)session.getAttribute(ATTR_CURRENT_ENTRY_POINT_NAME);
    }
}

