/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.lifecycle;

import org.eclipse.rwt.internal.lifecycle.LifeCycle;
import org.eclipse.rwt.internal.lifecycle.PhaseListenerRegistry;
import org.eclipse.rwt.internal.lifecycle.SimpleLifeCycle;
import org.eclipse.rwt.internal.util.ClassUtil;
import org.eclipse.rwt.lifecycle.ILifeCycle;
import org.eclipse.rwt.lifecycle.PhaseListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifeCycleFactory {
    private static final Class<? extends LifeCycle> DEFAULT_LIFE_CYCLE_CLASS = SimpleLifeCycle.class;
    private final PhaseListenerRegistry phaseListenerRegistry;
    private Class<? extends LifeCycle> lifeCycleClass;
    private LifeCycle lifeCycle;

    public LifeCycleFactory(PhaseListenerRegistry phaseListenerRegistry) {
        this.phaseListenerRegistry = phaseListenerRegistry;
        this.lifeCycleClass = DEFAULT_LIFE_CYCLE_CLASS;
    }

    public ILifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    public void configure(Class<? extends LifeCycle> lifeCycleClass) {
        this.lifeCycleClass = lifeCycleClass;
    }

    public void activate() {
        this.lifeCycle = this.newLifeCycle();
        PhaseListener[] phaseListenerArray = this.phaseListenerRegistry.getAll();
        int n = phaseListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PhaseListener phaseListener = phaseListenerArray[n2];
            this.lifeCycle.addPhaseListener(phaseListener);
            ++n2;
        }
    }

    public void deactivate() {
        this.lifeCycleClass = DEFAULT_LIFE_CYCLE_CLASS;
        this.lifeCycle = null;
    }

    private LifeCycle newLifeCycle() {
        return (LifeCycle)ClassUtil.newInstance(this.lifeCycleClass);
    }
}

