/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.protocol;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rwt.internal.protocol.JsonUtil;
import org.eclipse.rwt.internal.protocol.Operation;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.theme.JsonArray;
import org.eclipse.rwt.internal.theme.JsonObject;
import org.eclipse.rwt.internal.theme.JsonValue;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.service.IServiceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolMessageWriter {
    private static final String HAS_WIDGET_MANAGER = String.valueOf(JSWriter.class.getName()) + "#hasWidgetManager";
    private static final String CURRENT_WIDGET_REF = String.valueOf(JSWriter.class.getName()) + "#currentWidgetRef";
    private static final String JSEXECUTOR_ID = "jsex";
    private static final String ACTION_EXECUTE_SCRIPT = "execute";
    private static final String EXECUTE_SCRIPT_CONTENT = "content";
    private final JsonObject meta = new JsonObject();
    private final JsonArray operations = new JsonArray();
    private Operation pendingOperation;
    private boolean alreadyCreated;

    public boolean hasOperations() {
        return this.pendingOperation != null;
    }

    public void appendMeta(String property, int value) {
        this.appendMeta(property, JsonValue.valueOf(value));
    }

    public void appendMeta(String property, JsonValue value) {
        this.ensureMessagePending();
        this.meta.append(property, value);
    }

    public void appendCreate(String target, String type) {
        this.prepareOperation(target, "create");
        this.pendingOperation.appendDetail("type", JsonValue.valueOf(type));
    }

    public void appendSet(String target, String property, int value) {
        this.appendSet(target, property, JsonValue.valueOf(value));
    }

    public void appendSet(String target, String property, double value) {
        this.appendSet(target, property, JsonValue.valueOf(value));
    }

    public void appendSet(String target, String property, boolean value) {
        this.appendSet(target, property, JsonValue.valueOf(value));
    }

    public void appendSet(String target, String property, String value) {
        this.appendSet(target, property, JsonValue.valueOf(value));
    }

    public void appendSet(String target, String property, Object value) {
        this.appendSet(target, property, JsonUtil.createJsonValue(value));
    }

    private void appendSet(String target, String property, JsonValue value) {
        this.prepareOperation(target, "set");
        this.pendingOperation.appendProperty(property, value);
    }

    public void appendListen(String target, String eventType, boolean listen) {
        this.prepareOperation(target, "listen");
        this.pendingOperation.appendProperty(eventType, JsonValue.valueOf(listen));
    }

    public void appendCall(String target, String methodName, Map<String, Object> properties) {
        if (JSEXECUTOR_ID.equals(target) && ACTION_EXECUTE_SCRIPT.equals(methodName)) {
            this.appendExecuteScript(target, (String)properties.get(EXECUTE_SCRIPT_CONTENT));
        } else {
            this.prepareOperation(target, "call");
            this.pendingOperation.appendDetail("method", JsonValue.valueOf(methodName));
            this.pendingOperation.appendProperties(properties);
        }
    }

    public void appendDestroy(String target) {
        this.prepareOperation(target, "destroy");
    }

    private void prepareOperation(String target, String type) {
        this.ensureMessagePending();
        if (!this.canAppendToCurrentOperation(target, type)) {
            this.appendPendingOperation();
            this.pendingOperation = new Operation(target, type);
            ProtocolMessageWriter.invalidateJsWriterState();
        }
    }

    private static void invalidateJsWriterState() {
        IServiceStore serviceStore = ContextProvider.getServiceStore();
        serviceStore.removeAttribute(HAS_WIDGET_MANAGER);
        serviceStore.removeAttribute(CURRENT_WIDGET_REF);
    }

    public String createMessage() {
        this.ensureMessagePending();
        this.alreadyCreated = true;
        JsonObject message = this.createMessageObject();
        return message.toString();
    }

    private void ensureMessagePending() {
        if (this.alreadyCreated) {
            throw new IllegalStateException("Message already created");
        }
    }

    private JsonObject createMessageObject() {
        JsonObject message = new JsonObject();
        message.append("meta", this.meta);
        this.appendPendingOperation();
        message.append("operations", this.operations);
        return message;
    }

    private boolean canAppendToCurrentOperation(String target, String action) {
        boolean result = false;
        if (this.pendingOperation != null && this.pendingOperation.getTarget().equals(target)) {
            String pendingAction = this.pendingOperation.getAction();
            if ("listen".equals(action)) {
                result = pendingAction.equals("listen");
            } else if (ACTION_EXECUTE_SCRIPT.equals(action)) {
                result = pendingAction.equals(ACTION_EXECUTE_SCRIPT);
            } else if ("set".equals(action)) {
                result = pendingAction.equals("create") || pendingAction.equals("set");
            }
        }
        return result;
    }

    private void appendPendingOperation() {
        if (this.pendingOperation != null) {
            this.replaceExecuteScriptOperation();
            this.operations.append(this.pendingOperation.toJson());
        }
    }

    private void appendExecuteScript(String target, String code) {
        this.prepareOperation(target, ACTION_EXECUTE_SCRIPT);
        String pendingScript = (String)this.pendingOperation.getDetail(EXECUTE_SCRIPT_CONTENT);
        if (pendingScript != null) {
            this.pendingOperation.replaceDetail(EXECUTE_SCRIPT_CONTENT, String.valueOf(pendingScript) + code);
        } else {
            this.pendingOperation.appendDetail(EXECUTE_SCRIPT_CONTENT, code);
        }
    }

    private void replaceExecuteScriptOperation() {
        if (this.pendingOperation.getAction().equals(ACTION_EXECUTE_SCRIPT)) {
            String code = (String)this.pendingOperation.getDetail(EXECUTE_SCRIPT_CONTENT);
            this.pendingOperation = new Operation(JSEXECUTOR_ID, "call");
            this.pendingOperation.appendDetail("method", JsonValue.valueOf(ACTION_EXECUTE_SCRIPT));
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put(EXECUTE_SCRIPT_CONTENT, code);
            this.pendingOperation.appendProperties(properties);
        }
    }
}

