/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.rwt.internal.engine.RWTConfiguration;
import org.eclipse.rwt.internal.resources.ResourceRegistrationException;
import org.eclipse.rwt.internal.resources.ResourceUtil;
import org.eclipse.rwt.internal.resources.SystemProps;
import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.rwt.resources.IResourceManager;

public class ResourceManagerImpl
implements IResourceManager {
    public static final String RESOURCES = "rwt-resources";
    private final RWTConfiguration configuration;
    private final Map<String, Resource> resources;
    private final ThreadLocal<ClassLoader> contextLoader;

    public ResourceManagerImpl(RWTConfiguration configuration) {
        this.configuration = configuration;
        this.resources = new Hashtable<String, Resource>();
        this.contextLoader = new ThreadLocal();
    }

    public Integer findVersion(String name) {
        ParamCheck.notNull(name, "name");
        Integer result = null;
        Resource resource = this.resources.get(name);
        if (resource != null) {
            result = resource.getVersion();
        }
        return result;
    }

    public void register(String name) {
        ParamCheck.notNull(name, "name");
        this.internalRegister(name, null, IResourceManager.RegisterOptions.NONE);
    }

    public void register(String name, String charset) {
        ParamCheck.notNull(name, "name");
        ParamCheck.notNull(charset, "charset");
        this.internalRegister(name, charset, IResourceManager.RegisterOptions.NONE);
    }

    public void register(String name, String charset, IResourceManager.RegisterOptions options) {
        ParamCheck.notNull(name, "name");
        ParamCheck.notNull(charset, "charset");
        ParamCheck.notNull(options, "options");
        this.internalRegister(name, charset, options);
    }

    public void register(String name, InputStream is) {
        ParamCheck.notNull(name, "name");
        ParamCheck.notNull(is, "is");
        this.internalRegister(name, is, null, IResourceManager.RegisterOptions.NONE);
    }

    public void register(String name, InputStream is, String charset, IResourceManager.RegisterOptions options) {
        ParamCheck.notNull(name, "name");
        ParamCheck.notNull(is, "is");
        ParamCheck.notNull(charset, "charset");
        ParamCheck.notNull(options, "options");
        this.internalRegister(name, is, charset, options);
    }

    public boolean unregister(String name) {
        ParamCheck.notNull(name, "name");
        boolean result = false;
        Resource resource = this.resources.remove(name);
        if (resource != null) {
            result = true;
            Integer version = resource.getVersion();
            File file = this.getDiskLocation(name, version);
            file.delete();
        }
        return result;
    }

    public String getCharset(String name) {
        ParamCheck.notNull(name, "name");
        Resource resource = this.resources.get(name);
        return resource.getCharset();
    }

    public boolean isRegistered(String name) {
        ParamCheck.notNull(name, "name");
        return this.resources.containsKey(name);
    }

    public String getLocation(String name) {
        ParamCheck.notNull(name, "name");
        if (!this.resources.containsKey(name)) {
            throw new IllegalArgumentException("Resource does not exist: " + name);
        }
        return this.createRequestURL(name, this.findVersion(name));
    }

    public URL getResource(String name) {
        return this.getLoader().getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        URL resource = this.getLoader().getResource(name);
        InputStream result = null;
        if (resource != null) {
            try {
                URLConnection connection = resource.openConnection();
                connection.setUseCaches(false);
                result = connection.getInputStream();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    public Enumeration getResources(String name) throws IOException {
        return this.getLoader().getResources(name);
    }

    public void setContextLoader(ClassLoader classLoader) {
        this.contextLoader.set(classLoader);
    }

    public ClassLoader getContextLoader() {
        return this.contextLoader.get();
    }

    public InputStream getRegisteredContent(String name) {
        ParamCheck.notNull(name, "name");
        FileInputStream result = null;
        if (this.resources.containsKey(name)) {
            File file = this.getDiskLocation(name, null);
            try {
                result = new FileInputStream(file);
            }
            catch (FileNotFoundException fnfe) {
                throw new RuntimeException(fnfe);
            }
        }
        return result;
    }

    private ClassLoader getLoader() {
        ClassLoader result = this.getContextLoader() != null ? this.getContextLoader() : this.getClass().getClassLoader();
        return result;
    }

    private String createRequestURL(String fileName, Integer version) {
        String newFileName = fileName.replace('\\', '/');
        StringBuilder url = new StringBuilder();
        url.append(RESOURCES);
        url.append("/");
        String escapedFilename = ResourceManagerImpl.escapeFilename(newFileName);
        url.append(ResourceManagerImpl.versionedResourceName(escapedFilename, version));
        return url.toString();
    }

    private void internalRegister(String name, InputStream is, String charset, IResourceManager.RegisterOptions options) {
        boolean compress = ResourceManagerImpl.shouldCompress(options);
        try {
            byte[] content = ResourceUtil.read(is, charset, compress);
            this.registerContent(name, charset, options, content);
        }
        catch (IOException ioe) {
            throw new ResourceRegistrationException("Failed to register resource: " + name, ioe);
        }
    }

    private void internalRegister(String name, String charset, IResourceManager.RegisterOptions options) {
        if (!this.resources.containsKey(name)) {
            boolean compress = ResourceManagerImpl.shouldCompress(options);
            try {
                byte[] content = ResourceUtil.read(name, charset, compress, this);
                this.registerContent(name, charset, options, content);
            }
            catch (IOException ioe) {
                throw new ResourceRegistrationException("Failed to register resource: " + name, ioe);
            }
        }
    }

    private void registerContent(String name, String charset, IResourceManager.RegisterOptions options, byte[] content) throws IOException {
        Integer version = ResourceManagerImpl.computeVersion(content, options);
        File location = this.getDiskLocation(name, version);
        ResourceManagerImpl.createFile(location);
        ResourceUtil.write(location, content);
        this.resources.put(name, new Resource(charset, version));
    }

    private static void createFile(File fileToWrite) throws IOException {
        File dir = new File(fileToWrite.getParent());
        if (!dir.mkdirs() && !dir.exists()) {
            throw new IOException("Could not create directory structure: " + dir.getAbsolutePath());
        }
        if (!fileToWrite.exists()) {
            fileToWrite.createNewFile();
        }
    }

    private static Integer computeVersion(byte[] content, IResourceManager.RegisterOptions options) {
        Integer result = null;
        if (content != null && ResourceManagerImpl.shouldVersion(options)) {
            int version = 0;
            int i = 0;
            while (i < content.length) {
                version = version * 31 + content[i];
                ++i;
            }
            result = new Integer(version);
        }
        return result;
    }

    static String versionedResourceName(String name, Integer version) {
        String result = name;
        if (version != null) {
            String versionString = Integer.toHexString(version);
            int dotPos = name.lastIndexOf(46);
            if (name.replace('\\', '/').lastIndexOf("/") > dotPos) {
                dotPos = -1;
            }
            result = dotPos == -1 ? String.valueOf(name) + '-' + versionString : String.valueOf(name.substring(0, dotPos)) + '-' + versionString + name.substring(dotPos);
        }
        return result;
    }

    private static boolean shouldVersion(IResourceManager.RegisterOptions options) {
        return (options == IResourceManager.RegisterOptions.VERSION || options == IResourceManager.RegisterOptions.VERSION_AND_COMPRESS) && SystemProps.useVersionedJavaScript();
    }

    private static boolean shouldCompress(IResourceManager.RegisterOptions options) {
        return (options == IResourceManager.RegisterOptions.COMPRESS || options == IResourceManager.RegisterOptions.VERSION_AND_COMPRESS) && SystemProps.useCompressedJavaScript() && !SystemProps.isDevelopmentMode();
    }

    private File getDiskLocation(String name, Integer version) {
        StringBuilder filename = new StringBuilder();
        filename.append(this.configuration.getContextDirectory().toString());
        filename.append(File.separator);
        filename.append(RESOURCES);
        filename.append(File.separator);
        filename.append(ResourceManagerImpl.versionedResourceName(ResourceManagerImpl.escapeFilename(name), version));
        return new File(filename.toString());
    }

    private static String escapeFilename(String name) {
        String result = name;
        result = name.replaceAll("\\$", "\\$\\$");
        result = result.replaceAll(":", "\\$1");
        result = result.replaceAll("\\?", "\\$2");
        return result;
    }

    private static final class Resource {
        private final String charset;
        private final Integer version;

        public Resource(String charset, Integer version) {
            this.charset = charset;
            this.version = version;
        }

        public String getCharset() {
            return this.charset;
        }

        public Integer getVersion() {
            return this.version;
        }
    }
}

