/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.service;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.rwt.internal.RWTMessages;
import org.eclipse.rwt.internal.SingletonManager;
import org.eclipse.rwt.internal.lifecycle.LifeCycle;
import org.eclipse.rwt.internal.lifecycle.LifeCycleFactory;
import org.eclipse.rwt.internal.lifecycle.RWTRequestVersionControl;
import org.eclipse.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.RequestParameterBuffer;
import org.eclipse.rwt.internal.service.SessionStoreImpl;
import org.eclipse.rwt.internal.service.StartupPage;
import org.eclipse.rwt.service.IServiceHandler;
import org.eclipse.rwt.service.ISessionStore;

public class LifeCycleServiceHandler
implements IServiceHandler {
    public static final String RWT_INITIALIZE = "rwt_initialize";
    static final String SESSION_INITIALIZED = String.valueOf(LifeCycleServiceHandler.class.getName()) + "#isSessionInitialized";
    private final LifeCycleFactory lifeCycleFactory;
    private final StartupPage startupPage;

    public LifeCycleServiceHandler(LifeCycleFactory lifeCycleFactory, StartupPage startupPage) {
        this.lifeCycleFactory = lifeCycleFactory;
        this.startupPage = startupPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service() throws IOException {
        ISessionStore iSessionStore = ContextProvider.getSessionStore();
        synchronized (iSessionStore) {
            this.synchronizedService();
        }
    }

    void synchronizedService() throws IOException {
        LifeCycleServiceHandler.setJsonResponseHeaders((ServletResponse)ContextProvider.getResponse());
        if (RWTRequestVersionControl.getInstance().isValid() || LifeCycleServiceHandler.isSessionRestart() || ContextProvider.getRequest().getSession().isNew()) {
            this.runLifeCycle();
        } else {
            LifeCycleServiceHandler.handleInvalidRequestCounter();
        }
        LifeCycleServiceHandler.writeProtocolMessage();
    }

    public static void initializeSession() {
        if (!LifeCycleServiceHandler.isSessionInitialized() && ContextProvider.getRequest().getParameter(RWT_INITIALIZE) != null) {
            ISessionStore session = ContextProvider.getSessionStore();
            session.setAttribute(SESSION_INITIALIZED, Boolean.TRUE);
        }
    }

    private void runLifeCycle() throws IOException {
        LifeCycleServiceHandler.checkRequest();
        LifeCycleServiceHandler.initializeSession();
        if (LifeCycleServiceHandler.isSessionInitialized()) {
            RequestParameterBuffer.merge();
            LifeCycle lifeCycle = (LifeCycle)this.lifeCycleFactory.getLifeCycle();
            lifeCycle.execute();
        } else {
            Map parameters = ContextProvider.getRequest().getParameterMap();
            RequestParameterBuffer.store(parameters);
            this.startupPage.send();
        }
    }

    private static boolean isSessionRestart() {
        HttpServletRequest request = ContextProvider.getRequest();
        boolean startup = request.getParameter("startup") != null;
        String uiRoot = request.getParameter("uiRoot");
        HttpSession session = request.getSession();
        return !session.isNew() && !startup && uiRoot == null || startup && LifeCycleServiceHandler.isSessionInitialized();
    }

    private static void writeProtocolMessage() throws IOException {
        HttpServletResponse response = ContextProvider.getResponse();
        if (response.getContentType().startsWith("application/json")) {
            ProtocolMessageWriter protocolWriter = ContextProvider.getProtocolWriter();
            String message = protocolWriter.createMessage();
            response.getWriter().write(message);
        }
    }

    private static void handleInvalidRequestCounter() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("message", RWTMessages.getMessage("RWT_MultipleInstancesError"));
        ProtocolMessageWriter writer = ContextProvider.getProtocolWriter();
        writer.appendCall("w1", "reload", properties);
    }

    private static boolean isSessionInitialized() {
        ISessionStore session = ContextProvider.getSessionStore();
        return Boolean.TRUE.equals(session.getAttribute(SESSION_INITIALIZED));
    }

    private static void checkRequest() {
        if (LifeCycleServiceHandler.isSessionRestart()) {
            LifeCycleServiceHandler.clearSessionStore();
        }
    }

    private static void clearSessionStore() {
        Integer version = RWTRequestVersionControl.getInstance().getCurrentRequestId();
        SessionStoreImpl sessionStore = (SessionStoreImpl)ContextProvider.getSessionStore();
        sessionStore.valueUnbound(null);
        sessionStore.valueBound(null);
        SingletonManager.install(sessionStore);
        RWTRequestVersionControl.getInstance().setCurrentRequestId(version);
    }

    private static void setJsonResponseHeaders(ServletResponse response) {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
    }
}

