/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme;

import java.io.IOException;
import org.eclipse.rwt.internal.application.RWTFactory;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.theme.QxType;
import org.eclipse.rwt.internal.theme.SimpleSelector;
import org.eclipse.rwt.internal.theme.Theme;
import org.eclipse.rwt.internal.theme.ThemeCssValuesMap;
import org.eclipse.rwt.internal.theme.ThemeManager;
import org.eclipse.rwt.internal.theme.ThemeManagerException;
import org.eclipse.rwt.internal.theme.ValueSelector;
import org.eclipse.rwt.internal.theme.css.ConditionalValue;
import org.eclipse.rwt.internal.theme.css.CssFileReader;
import org.eclipse.rwt.internal.theme.css.StyleSheet;
import org.eclipse.rwt.resources.ResourceLoader;
import org.eclipse.rwt.service.ISessionStore;
import org.eclipse.swt.widgets.Widget;

public final class ThemeUtil {
    public static final String DEFAULT_THEME_ID = "org.eclipse.rap.rwt.theme.Default";
    private static final String DEFAULT_THEME_NAME = "RAP Default Theme";
    private static final String DEFAULT_THEME_CSS = "resource/theme/default.css";
    private static final String CURR_THEME_ATTR = "org.eclipse.rap.theme.current";

    public static String[] getAvailableThemeIds() {
        return RWTFactory.getThemeManager().getRegisteredThemeIds();
    }

    public static String getCurrentThemeId() {
        ISessionStore sessionStore = ContextProvider.getSessionStore();
        String result = (String)sessionStore.getAttribute(CURR_THEME_ATTR);
        if (result == null) {
            result = DEFAULT_THEME_ID;
        }
        return result;
    }

    public static void setCurrentThemeId(String themeId) {
        if (!RWTFactory.getThemeManager().hasTheme(themeId)) {
            throw new IllegalArgumentException("Illegal theme id: " + themeId);
        }
        ContextProvider.getSessionStore().setAttribute(CURR_THEME_ATTR, themeId);
    }

    public static Theme getCurrentTheme() {
        return RWTFactory.getThemeManager().getTheme(ThemeUtil.getCurrentThemeId());
    }

    public static Theme getDefaultTheme() {
        ThemeManager themeManager = RWTFactory.getThemeManager();
        return themeManager.getTheme(DEFAULT_THEME_ID);
    }

    private static Theme getFallbackTheme() {
        ThemeManager themeManager = RWTFactory.getThemeManager();
        return themeManager.getTheme("org.eclipse.rap.rwt.theme.Fallback");
    }

    public static void initializeDefaultTheme(ThemeManager themeManager) {
        if (!themeManager.hasTheme(DEFAULT_THEME_ID)) {
            StyleSheet defaultStyleSheet = ThemeUtil.readDafaultThemeStyleSheet();
            Theme defaultTheme = new Theme(DEFAULT_THEME_ID, DEFAULT_THEME_NAME, defaultStyleSheet);
            themeManager.registerTheme(defaultTheme);
        }
    }

    private static StyleSheet readDafaultThemeStyleSheet() {
        StyleSheet result;
        try {
            ResourceLoader resLoader = ThemeManager.STANDARD_RESOURCE_LOADER;
            result = CssFileReader.readStyleSheet(DEFAULT_THEME_CSS, resLoader);
        }
        catch (IOException e) {
            String msg = "Failed to load default theme: resource/theme/default.css";
            throw new ThemeManagerException(msg, e);
        }
        return result;
    }

    public static QxType getCssValue(String cssElement, String cssProperty, SimpleSelector selector) {
        return ThemeUtil.getCssValue(cssElement, cssProperty, selector, null);
    }

    public static QxType getCssValue(String cssElement, String cssProperty, ValueSelector selector, Widget widget) {
        Theme theme = ThemeUtil.getCurrentTheme();
        ThemeCssValuesMap valuesMap = theme.getValuesMap();
        ConditionalValue[] values = valuesMap.getValues(cssElement, cssProperty);
        QxType result = selector.select(values, widget);
        if (result == null) {
            theme = ThemeUtil.getFallbackTheme();
            valuesMap = theme.getValuesMap();
            values = valuesMap.getValues(cssElement, cssProperty);
            result = selector.select(values, widget);
        }
        return result;
    }

    private ThemeUtil() {
    }
}

