/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.sashkit;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rwt.internal.protocol.IClientObject;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Widget;

public final class SashLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.Sash";
    private static final String[] ALLOWED_STYLES = new String[]{"HORIZONTAL", "VERTICAL", "SMOOTH", "BORDER"};

    public void preserveValues(Widget widget) {
        ControlLCAUtil.preserveValues((Control)widget);
        WidgetLCAUtil.preserveCustomVariant(widget);
    }

    public void readData(Widget widget) {
        Sash sash = (Sash)widget;
        SashLCA.processSelection(sash);
        ControlLCAUtil.processMouseEvents(sash);
        ControlLCAUtil.processKeyEvents(sash);
        ControlLCAUtil.processMenuDetect(sash);
        WidgetLCAUtil.processHelp(sash);
    }

    public void renderInitialization(Widget widget) throws IOException {
        Sash sash = (Sash)widget;
        IClientObject clientObject = ClientObjectFactory.getForWidget(sash);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(sash.getParent()));
        clientObject.set("style", WidgetLCAUtil.getStyles(sash, ALLOWED_STYLES));
    }

    public void renderChanges(Widget widget) throws IOException {
        Sash sash = (Sash)widget;
        ControlLCAUtil.renderChanges(sash);
        WidgetLCAUtil.renderCustomVariant(sash);
    }

    public void renderDispose(Widget widget) throws IOException {
        ClientObjectFactory.getForWidget(widget).destroy();
    }

    private static void processSelection(Sash sash) {
        HttpServletRequest request = ContextProvider.getRequest();
        String eventId = "org.eclipse.swt.events.widgetSelected";
        if (WidgetLCAUtil.wasEventSent(sash, eventId)) {
            int eventType = 13;
            Rectangle bounds = WidgetLCAUtil.readBounds(sash, sash.getBounds());
            int stateMask = EventLCAUtil.readStateMask("org.eclipse.swt.events.widgetSelected.modifier");
            String detailStr = request.getParameter(String.valueOf(eventId) + ".detail");
            int detail = "drag".equals(detailStr) ? 1 : 0;
            SelectionEvent event = new SelectionEvent(sash, null, eventType, bounds, stateMask, null, true, detail);
            event.processEvent();
        }
    }
}

