/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.widgets;

import java.util.HashMap;
import org.eclipse.rwt.internal.application.RWTFactory;
import org.eclipse.rwt.internal.lifecycle.LifeCycleUtil;
import org.eclipse.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.lifecycle.PhaseEvent;
import org.eclipse.rwt.lifecycle.PhaseId;
import org.eclipse.rwt.lifecycle.PhaseListener;
import org.eclipse.rwt.service.IServiceStore;
import org.eclipse.swt.widgets.Display;

public final class JSExecutor {
    private static final String JS_EXECUTOR = String.valueOf(JSExecutor.class.getName()) + "#instance";
    private static final String JSEXECUTOR_ID = "jsex";
    private static final String PARAM_CONTENT = "content";
    private static final String METHOD_EXECUTE = "execute";

    public static void executeJS(String code) {
        JSExecutorPhaseListener jsExecutor = JSExecutor.getJSExecutor();
        if (jsExecutor == null) {
            jsExecutor = new JSExecutorPhaseListener();
            RWTFactory.getLifeCycleFactory().getLifeCycle().addPhaseListener(jsExecutor);
            JSExecutor.setJSExecutor(jsExecutor);
        }
        jsExecutor.append(code);
    }

    private JSExecutor() {
    }

    private static JSExecutorPhaseListener getJSExecutor() {
        IServiceStore serviceStore = ContextProvider.getServiceStore();
        return (JSExecutorPhaseListener)serviceStore.getAttribute(JS_EXECUTOR);
    }

    private static void setJSExecutor(JSExecutorPhaseListener jsExecutor) {
        IServiceStore serviceStore = ContextProvider.getServiceStore();
        serviceStore.setAttribute(JS_EXECUTOR, jsExecutor);
    }

    private static class JSExecutorPhaseListener
    implements PhaseListener {
        private final StringBuilder code;
        private final Display display = Display.getCurrent();

        JSExecutorPhaseListener() {
            this.code = new StringBuilder();
        }

        void append(String command) {
            this.code.append(command);
        }

        public void beforePhase(PhaseEvent event) {
        }

        public void afterPhase(PhaseEvent event) {
            if (this.display == LifeCycleUtil.getSessionDisplay()) {
                ProtocolMessageWriter protocolWriter = ContextProvider.getProtocolWriter();
                try {
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    properties.put(JSExecutor.PARAM_CONTENT, this.code.toString().trim());
                    protocolWriter.appendCall(JSExecutor.JSEXECUTOR_ID, JSExecutor.METHOD_EXECUTE, properties);
                }
                finally {
                    RWTFactory.getLifeCycleFactory().getLifeCycle().removePhaseListener(this);
                }
            }
        }

        public PhaseId getPhaseId() {
            return PhaseId.RENDER;
        }
    }
}

